/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;

public class STBEasyFont {
    protected STBEasyFont() {
        throw new UnsupportedOperationException();
    }

    public static native int nstb_easy_font_width(long var0);

    public static int stb_easy_font_width(ByteBuffer text) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
        }
        return STBEasyFont.nstb_easy_font_width(MemoryUtil.memAddress(text));
    }

    public static int stb_easy_font_width(CharSequence text) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textEncoded = __buffer.stringParamASCII(text, true);
        return STBEasyFont.nstb_easy_font_width(__buffer.address(textEncoded));
    }

    public static native int nstb_easy_font_print(float var0, float var1, long var2, long var4, long var6, int var8);

    public static int stb_easy_font_print(float x, float y, ByteBuffer text, ByteBuffer color, ByteBuffer vertex_buffer, int vbuf_size) {
        if (Checks.CHECKS) {
            Checks.checkNT1(text);
            if (color != null) {
                Checks.checkBuffer((Buffer)color, 4);
            }
            Checks.checkBuffer((Buffer)vertex_buffer, vbuf_size);
        }
        return STBEasyFont.nstb_easy_font_print(x, y, MemoryUtil.memAddress(text), MemoryUtil.memAddressSafe(color), MemoryUtil.memAddress(vertex_buffer), vbuf_size);
    }

    public static int stb_easy_font_print(float x, float y, ByteBuffer text, ByteBuffer color, ByteBuffer vertex_buffer) {
        if (Checks.CHECKS && color != null) {
            Checks.checkBuffer((Buffer)color, 4);
        }
        return STBEasyFont.nstb_easy_font_print(x, y, MemoryUtil.memAddress(text), MemoryUtil.memAddressSafe(color), MemoryUtil.memAddress(vertex_buffer), vertex_buffer.remaining());
    }

    public static int stb_easy_font_print(float x, float y, CharSequence text, ByteBuffer color, ByteBuffer vertex_buffer) {
        if (Checks.CHECKS && color != null) {
            Checks.checkBuffer((Buffer)color, 4);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int textEncoded = __buffer.stringParamASCII(text, true);
        return STBEasyFont.nstb_easy_font_print(x, y, __buffer.address(textEncoded), MemoryUtil.memAddressSafe(color), MemoryUtil.memAddress(vertex_buffer), vertex_buffer.remaining());
    }

    public static native void stb_easy_font_spacing(float var0);

    static {
        Library.initialize();
    }
}

