/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRVector3f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRViewScaleDesc
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HMDTOEYEVIEWOFFSET;
    public static final int HMDSPACETOWORLDSCALEINMETERS;

    OVRViewScaleDesc(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRViewScaleDesc(long struct) {
        this(struct, null);
    }

    public OVRViewScaleDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRVector3f.Buffer HmdToEyeViewOffset() {
        return OVRViewScaleDesc.nHmdToEyeViewOffset(this.address());
    }

    public OVRVector3f HmdToEyeViewOffset(int index) {
        return OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), index);
    }

    public float HmdSpaceToWorldScaleInMeters() {
        return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
    }

    public OVRViewScaleDesc HmdToEyeViewOffset(OVRVector3f.Buffer value) {
        OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc HmdToEyeViewOffset(int index, OVRVector3f value) {
        OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), index, value);
        return this;
    }

    public OVRViewScaleDesc HmdSpaceToWorldScaleInMeters(float value) {
        OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
        return this;
    }

    public OVRViewScaleDesc set(OVRVector3f.Buffer HmdToEyeViewOffset, float HmdSpaceToWorldScaleInMeters) {
        this.HmdToEyeViewOffset(HmdToEyeViewOffset);
        this.HmdSpaceToWorldScaleInMeters(HmdSpaceToWorldScaleInMeters);
        return this;
    }

    public OVRViewScaleDesc nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRViewScaleDesc set(OVRViewScaleDesc src) {
        return this.nset(src.address());
    }

    public OVRViewScaleDesc set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRViewScaleDesc malloc() {
        return new OVRViewScaleDesc(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRViewScaleDesc calloc() {
        return new OVRViewScaleDesc(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRViewScaleDesc create() {
        return new OVRViewScaleDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRVector3f.Buffer nHmdToEyeViewOffset(long struct) {
        return OVRVector3f.createBuffer(struct + (long)HMDTOEYEVIEWOFFSET, 2);
    }

    public static OVRVector3f nHmdToEyeViewOffset(long struct, int index) {
        return new OVRVector3f(struct + (long)HMDTOEYEVIEWOFFSET + (long)(index * OVRVector3f.SIZEOF));
    }

    public static float nHmdSpaceToWorldScaleInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS);
    }

    public static void nHmdToEyeViewOffset(long struct, OVRVector3f.Buffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 2);
        }
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEVIEWOFFSET, value.remaining() * OVRVector3f.SIZEOF);
    }

    public static void nHmdToEyeViewOffset(long struct, int index, OVRVector3f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HMDTOEYEVIEWOFFSET + (long)(index * OVRVector3f.SIZEOF), OVRVector3f.SIZEOF);
    }

    public static void nHmdSpaceToWorldScaleInMeters(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)HMDSPACETOWORLDSCALEINMETERS, value);
    }

    static {
        Struct.Layout layout = OVRViewScaleDesc.__struct(OVRViewScaleDesc.__array(OVRVector3f.SIZEOF, OVRVector3f.__ALIGNMENT, 2), OVRViewScaleDesc.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HMDTOEYEVIEWOFFSET = layout.offsetof(0);
        HMDSPACETOWORLDSCALEINMETERS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRViewScaleDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRViewScaleDesc newInstance(long address) {
            return new OVRViewScaleDesc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRVector3f.Buffer HmdToEyeViewOffset() {
            return OVRViewScaleDesc.nHmdToEyeViewOffset(this.address());
        }

        public OVRVector3f HmdToEyeViewOffset(int index) {
            return OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), index);
        }

        public float HmdSpaceToWorldScaleInMeters() {
            return OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address());
        }

        public Buffer HmdToEyeViewOffset(OVRVector3f.Buffer value) {
            OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), value);
            return this;
        }

        public Buffer HmdToEyeViewOffset(int index, OVRVector3f value) {
            OVRViewScaleDesc.nHmdToEyeViewOffset(this.address(), index, value);
            return this;
        }

        public Buffer HmdSpaceToWorldScaleInMeters(float value) {
            OVRViewScaleDesc.nHmdSpaceToWorldScaleInMeters(this.address(), value);
            return this;
        }
    }
}

