/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRSizei
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int W;
    public static final int H;

    OVRSizei(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRSizei(long struct) {
        this(struct, null);
    }

    public OVRSizei(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int w() {
        return OVRSizei.nw(this.address());
    }

    public int h() {
        return OVRSizei.nh(this.address());
    }

    public OVRSizei w(int value) {
        OVRSizei.nw(this.address(), value);
        return this;
    }

    public OVRSizei h(int value) {
        OVRSizei.nh(this.address(), value);
        return this;
    }

    public OVRSizei set(int w, int h) {
        this.w(w);
        this.h(h);
        return this;
    }

    public OVRSizei nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRSizei set(OVRSizei src) {
        return this.nset(src.address());
    }

    public OVRSizei set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRSizei malloc() {
        return new OVRSizei(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRSizei calloc() {
        return new OVRSizei(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRSizei create() {
        return new OVRSizei(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nw(long struct) {
        return MemoryUtil.memGetInt(struct + (long)W);
    }

    public static int nh(long struct) {
        return MemoryUtil.memGetInt(struct + (long)H);
    }

    public static void nw(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)W, value);
    }

    public static void nh(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)H, value);
    }

    static {
        Struct.Layout layout = OVRSizei.__struct(OVRSizei.__member(4), OVRSizei.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        W = layout.offsetof(0);
        H = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRSizei, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRSizei newInstance(long address) {
            return new OVRSizei(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int w() {
            return OVRSizei.nw(this.address());
        }

        public int h() {
            return OVRSizei.nh(this.address());
        }

        public Buffer w(int value) {
            OVRSizei.nw(this.address(), value);
            return this;
        }

        public Buffer h(int value) {
            OVRSizei.nh(this.address(), value);
            return this;
        }
    }
}

