/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRSessionStatus
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HASVRFOCUS;
    public static final int HMDPRESENT;

    OVRSessionStatus(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRSessionStatus(long struct) {
        this(struct, null);
    }

    public OVRSessionStatus(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean HasVrFocus() {
        return OVRSessionStatus.nHasVrFocus(this.address());
    }

    public boolean HmdPresent() {
        return OVRSessionStatus.nHmdPresent(this.address());
    }

    public static OVRSessionStatus malloc() {
        return new OVRSessionStatus(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRSessionStatus calloc() {
        return new OVRSessionStatus(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRSessionStatus create() {
        return new OVRSessionStatus(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static boolean nHasVrFocus(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HASVRFOCUS) != 0;
    }

    public static boolean nHmdPresent(long struct) {
        return MemoryUtil.memGetByte(struct + (long)HMDPRESENT) != 0;
    }

    static {
        Struct.Layout layout = OVRSessionStatus.__struct(OVRSessionStatus.__member(1), OVRSessionStatus.__member(1));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HASVRFOCUS = layout.offsetof(0);
        HMDPRESENT = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRSessionStatus, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRSessionStatus newInstance(long address) {
            return new OVRSessionStatus(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean HasVrFocus() {
            return OVRSessionStatus.nHasVrFocus(this.address());
        }

        public boolean HmdPresent() {
            return OVRSessionStatus.nHmdPresent(this.address());
        }
    }
}

