/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRMatrix4f
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int M;

    OVRMatrix4f(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRMatrix4f(long struct) {
        this(struct, null);
    }

    public OVRMatrix4f(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public FloatBuffer M() {
        return OVRMatrix4f.nM(this.address());
    }

    public float M(int index) {
        return OVRMatrix4f.nM(this.address(), index);
    }

    public OVRMatrix4f M(FloatBuffer value) {
        OVRMatrix4f.nM(this.address(), value);
        return this;
    }

    public OVRMatrix4f M(int index, float value) {
        OVRMatrix4f.nM(this.address(), index, value);
        return this;
    }

    public OVRMatrix4f nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRMatrix4f set(OVRMatrix4f src) {
        return this.nset(src.address());
    }

    public OVRMatrix4f set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRMatrix4f malloc() {
        return new OVRMatrix4f(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRMatrix4f calloc() {
        return new OVRMatrix4f(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRMatrix4f create() {
        return new OVRMatrix4f(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static FloatBuffer nM(long struct) {
        return MemoryUtil.memFloatBuffer(struct + (long)M, 16);
    }

    public static float nM(long struct, int index) {
        return MemoryUtil.memGetFloat(struct + (long)M + (long)(index * 4));
    }

    public static void nM(long struct, FloatBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBufferGT(value, 16);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(value), struct + (long)M, value.remaining() * 4);
    }

    public static void nM(long struct, int index, float value) {
        MemoryUtil.memPutFloat(struct + (long)M + (long)(index * 4), value);
    }

    static {
        Struct.Layout layout = OVRMatrix4f.__struct(OVRMatrix4f.__array(4, 16));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        M = layout.offsetof(0);
    }

    public static final class Buffer
    extends StructBuffer<OVRMatrix4f, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRMatrix4f newInstance(long address) {
            return new OVRMatrix4f(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public FloatBuffer M() {
            return OVRMatrix4f.nM(this.address());
        }

        public float M(int index) {
            return OVRMatrix4f.nM(this.address(), index);
        }

        public Buffer M(FloatBuffer value) {
            OVRMatrix4f.nM(this.address(), value);
            return this;
        }

        public Buffer M(int index, float value) {
            OVRMatrix4f.nM(this.address(), index, value);
            return this;
        }
    }
}

