/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRLayerHeader;
import org.lwjgl.ovr.OVRPosef;
import org.lwjgl.ovr.OVRRecti;
import org.lwjgl.ovr.OVRSwapTextureSet;
import org.lwjgl.ovr.OVRVector2f;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRLayerQuad
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int HEADER;
    public static final int COLORTEXTURE;
    public static final int VIEWPORT;
    public static final int QUADPOSECENTER;
    public static final int QUADSIZE;

    OVRLayerQuad(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRLayerQuad(long struct) {
        this(struct, null);
    }

    public OVRLayerQuad(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public OVRLayerHeader Header() {
        return OVRLayerQuad.nHeader(this.address());
    }

    public OVRSwapTextureSet ColorTexture() {
        return OVRLayerQuad.nColorTextureStruct(this.address());
    }

    public OVRRecti Viewport() {
        return OVRLayerQuad.nViewport(this.address());
    }

    public OVRPosef QuadPoseCenter() {
        return OVRLayerQuad.nQuadPoseCenter(this.address());
    }

    public OVRVector2f QuadSize() {
        return OVRLayerQuad.nQuadSize(this.address());
    }

    public OVRLayerQuad Header(OVRLayerHeader value) {
        OVRLayerQuad.nHeader(this.address(), value);
        return this;
    }

    public OVRLayerQuad ColorTexture(OVRSwapTextureSet value) {
        OVRLayerQuad.nColorTexture(this.address(), value);
        return this;
    }

    public OVRLayerQuad Viewport(OVRRecti value) {
        OVRLayerQuad.nViewport(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadPoseCenter(OVRPosef value) {
        OVRLayerQuad.nQuadPoseCenter(this.address(), value);
        return this;
    }

    public OVRLayerQuad QuadSize(OVRVector2f value) {
        OVRLayerQuad.nQuadSize(this.address(), value);
        return this;
    }

    public OVRLayerQuad set(OVRLayerHeader Header, OVRSwapTextureSet ColorTexture, OVRRecti Viewport, OVRPosef QuadPoseCenter, OVRVector2f QuadSize) {
        this.Header(Header);
        this.ColorTexture(ColorTexture);
        this.Viewport(Viewport);
        this.QuadPoseCenter(QuadPoseCenter);
        this.QuadSize(QuadSize);
        return this;
    }

    public OVRLayerQuad nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRLayerQuad set(OVRLayerQuad src) {
        return this.nset(src.address());
    }

    public OVRLayerQuad set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRLayerQuad malloc() {
        return new OVRLayerQuad(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRLayerQuad calloc() {
        return new OVRLayerQuad(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRLayerQuad create() {
        return new OVRLayerQuad(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static OVRLayerHeader nHeader(long struct) {
        return new OVRLayerHeader(struct + (long)HEADER);
    }

    public static OVRSwapTextureSet nColorTextureStruct(long struct) {
        return new OVRSwapTextureSet(MemoryUtil.memGetAddress(struct + (long)COLORTEXTURE));
    }

    public static OVRRecti nViewport(long struct) {
        return new OVRRecti(struct + (long)VIEWPORT);
    }

    public static OVRPosef nQuadPoseCenter(long struct) {
        return new OVRPosef(struct + (long)QUADPOSECENTER);
    }

    public static OVRVector2f nQuadSize(long struct) {
        return new OVRVector2f(struct + (long)QUADSIZE);
    }

    public static void nHeader(long struct, OVRLayerHeader value) {
        MemoryUtil.memCopy(value.address(), struct + (long)HEADER, OVRLayerHeader.SIZEOF);
    }

    public static void nColorTexture(long struct, OVRSwapTextureSet value) {
        MemoryUtil.memPutAddress(struct + (long)COLORTEXTURE, value.address());
    }

    public static void nViewport(long struct, OVRRecti value) {
        MemoryUtil.memCopy(value.address(), struct + (long)VIEWPORT, OVRRecti.SIZEOF);
    }

    public static void nQuadPoseCenter(long struct, OVRPosef value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUADPOSECENTER, OVRPosef.SIZEOF);
    }

    public static void nQuadSize(long struct, OVRVector2f value) {
        MemoryUtil.memCopy(value.address(), struct + (long)QUADSIZE, OVRVector2f.SIZEOF);
    }

    static {
        Struct.Layout layout = OVRLayerQuad.__struct(OVRLayerQuad.__member(OVRLayerHeader.SIZEOF, OVRLayerHeader.__ALIGNMENT), OVRLayerQuad.__member(Pointer.POINTER_SIZE), OVRLayerQuad.__member(OVRRecti.SIZEOF, OVRRecti.__ALIGNMENT), OVRLayerQuad.__member(OVRPosef.SIZEOF, OVRPosef.__ALIGNMENT), OVRLayerQuad.__member(OVRVector2f.SIZEOF, OVRVector2f.__ALIGNMENT));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        HEADER = layout.offsetof(0);
        COLORTEXTURE = layout.offsetof(1);
        VIEWPORT = layout.offsetof(2);
        QUADPOSECENTER = layout.offsetof(3);
        QUADSIZE = layout.offsetof(4);
    }

    public static final class Buffer
    extends StructBuffer<OVRLayerQuad, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRLayerQuad newInstance(long address) {
            return new OVRLayerQuad(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public OVRLayerHeader Header() {
            return OVRLayerQuad.nHeader(this.address());
        }

        public OVRSwapTextureSet ColorTexture() {
            return OVRLayerQuad.nColorTextureStruct(this.address());
        }

        public OVRRecti Viewport() {
            return OVRLayerQuad.nViewport(this.address());
        }

        public OVRPosef QuadPoseCenter() {
            return OVRLayerQuad.nQuadPoseCenter(this.address());
        }

        public OVRVector2f QuadSize() {
            return OVRLayerQuad.nQuadSize(this.address());
        }

        public Buffer Header(OVRLayerHeader value) {
            OVRLayerQuad.nHeader(this.address(), value);
            return this;
        }

        public Buffer ColorTexture(OVRSwapTextureSet value) {
            OVRLayerQuad.nColorTexture(this.address(), value);
            return this;
        }

        public Buffer Viewport(OVRRecti value) {
            OVRLayerQuad.nViewport(this.address(), value);
            return this;
        }

        public Buffer QuadPoseCenter(OVRPosef value) {
            OVRLayerQuad.nQuadPoseCenter(this.address(), value);
            return this;
        }

        public Buffer QuadSize(OVRVector2f value) {
            OVRLayerQuad.nQuadSize(this.address(), value);
            return this;
        }
    }
}

