/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.ovr.OVRFovPort;
import org.lwjgl.ovr.OVRSizei;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRHmdDesc
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int TYPE;
    public static final int PRODUCTNAME;
    public static final int MANUFACTURER;
    public static final int VENDORID;
    public static final int PRODUCTID;
    public static final int SERIALNUMBER;
    public static final int FIRMWAREMAJOR;
    public static final int FIRMWAREMINOR;
    public static final int CAMERAFRUSTUMHFOVINRADIANS;
    public static final int CAMERAFRUSTUMVFOVINRADIANS;
    public static final int CAMERAFRUSTUMNEARZINMETERS;
    public static final int CAMERAFRUSTUMFARZINMETERS;
    public static final int AVAILABLEHMDCAPS;
    public static final int DEFAULTHMDCAPS;
    public static final int AVAILABLETRACKINGCAPS;
    public static final int DEFAULTTRACKINGCAPS;
    public static final int DEFAULTEYEFOV;
    public static final int MAXEYEFOV;
    public static final int RESOLUTION;
    public static final int DISPLAYREFRESHRATE;

    OVRHmdDesc(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRHmdDesc(long struct) {
        this(struct, null);
    }

    public OVRHmdDesc(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int Type() {
        return OVRHmdDesc.nType(this.address());
    }

    public ByteBuffer ProductName() {
        return OVRHmdDesc.nProductName(this.address());
    }

    public String ProductNameString() {
        return OVRHmdDesc.nProductNameString(this.address());
    }

    public ByteBuffer Manufacturer() {
        return OVRHmdDesc.nManufacturer(this.address());
    }

    public String ManufacturerString() {
        return OVRHmdDesc.nManufacturerString(this.address());
    }

    public short VendorId() {
        return OVRHmdDesc.nVendorId(this.address());
    }

    public short ProductId() {
        return OVRHmdDesc.nProductId(this.address());
    }

    public ByteBuffer SerialNumber() {
        return OVRHmdDesc.nSerialNumber(this.address());
    }

    public String SerialNumberString() {
        return OVRHmdDesc.nSerialNumberString(this.address());
    }

    public short FirmwareMajor() {
        return OVRHmdDesc.nFirmwareMajor(this.address());
    }

    public short FirmwareMinor() {
        return OVRHmdDesc.nFirmwareMinor(this.address());
    }

    public float CameraFrustumHFovInRadians() {
        return OVRHmdDesc.nCameraFrustumHFovInRadians(this.address());
    }

    public float CameraFrustumVFovInRadians() {
        return OVRHmdDesc.nCameraFrustumVFovInRadians(this.address());
    }

    public float CameraFrustumNearZInMeters() {
        return OVRHmdDesc.nCameraFrustumNearZInMeters(this.address());
    }

    public float CameraFrustumFarZInMeters() {
        return OVRHmdDesc.nCameraFrustumFarZInMeters(this.address());
    }

    public int AvailableHmdCaps() {
        return OVRHmdDesc.nAvailableHmdCaps(this.address());
    }

    public int DefaultHmdCaps() {
        return OVRHmdDesc.nDefaultHmdCaps(this.address());
    }

    public int AvailableTrackingCaps() {
        return OVRHmdDesc.nAvailableTrackingCaps(this.address());
    }

    public int DefaultTrackingCaps() {
        return OVRHmdDesc.nDefaultTrackingCaps(this.address());
    }

    public OVRFovPort.Buffer DefaultEyeFov() {
        return OVRHmdDesc.nDefaultEyeFov(this.address());
    }

    public OVRFovPort DefaultEyeFov(int index) {
        return OVRHmdDesc.nDefaultEyeFov(this.address(), index);
    }

    public OVRFovPort.Buffer MaxEyeFov() {
        return OVRHmdDesc.nMaxEyeFov(this.address());
    }

    public OVRFovPort MaxEyeFov(int index) {
        return OVRHmdDesc.nMaxEyeFov(this.address(), index);
    }

    public OVRSizei Resolution() {
        return OVRHmdDesc.nResolution(this.address());
    }

    public float DisplayRefreshRate() {
        return OVRHmdDesc.nDisplayRefreshRate(this.address());
    }

    public static OVRHmdDesc malloc() {
        return new OVRHmdDesc(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRHmdDesc calloc() {
        return new OVRHmdDesc(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRHmdDesc create() {
        return new OVRHmdDesc(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)TYPE);
    }

    public static ByteBuffer nProductName(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)PRODUCTNAME, 64);
    }

    public static String nProductNameString(long struct) {
        return MemoryUtil.memDecodeUTF8(struct + (long)PRODUCTNAME);
    }

    public static ByteBuffer nManufacturer(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)MANUFACTURER, 64);
    }

    public static String nManufacturerString(long struct) {
        return MemoryUtil.memDecodeUTF8(struct + (long)MANUFACTURER);
    }

    public static short nVendorId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)VENDORID);
    }

    public static short nProductId(long struct) {
        return MemoryUtil.memGetShort(struct + (long)PRODUCTID);
    }

    public static ByteBuffer nSerialNumber(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)SERIALNUMBER, 24);
    }

    public static String nSerialNumberString(long struct) {
        return MemoryUtil.memDecodeASCII(struct + (long)SERIALNUMBER);
    }

    public static short nFirmwareMajor(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FIRMWAREMAJOR);
    }

    public static short nFirmwareMinor(long struct) {
        return MemoryUtil.memGetShort(struct + (long)FIRMWAREMINOR);
    }

    public static float nCameraFrustumHFovInRadians(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CAMERAFRUSTUMHFOVINRADIANS);
    }

    public static float nCameraFrustumVFovInRadians(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CAMERAFRUSTUMVFOVINRADIANS);
    }

    public static float nCameraFrustumNearZInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CAMERAFRUSTUMNEARZINMETERS);
    }

    public static float nCameraFrustumFarZInMeters(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)CAMERAFRUSTUMFARZINMETERS);
    }

    public static int nAvailableHmdCaps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)AVAILABLEHMDCAPS);
    }

    public static int nDefaultHmdCaps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEFAULTHMDCAPS);
    }

    public static int nAvailableTrackingCaps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)AVAILABLETRACKINGCAPS);
    }

    public static int nDefaultTrackingCaps(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEFAULTTRACKINGCAPS);
    }

    public static OVRFovPort.Buffer nDefaultEyeFov(long struct) {
        return OVRFovPort.createBuffer(struct + (long)DEFAULTEYEFOV, 2);
    }

    public static OVRFovPort nDefaultEyeFov(long struct, int index) {
        return new OVRFovPort(struct + (long)DEFAULTEYEFOV + (long)(index * OVRFovPort.SIZEOF));
    }

    public static OVRFovPort.Buffer nMaxEyeFov(long struct) {
        return OVRFovPort.createBuffer(struct + (long)MAXEYEFOV, 2);
    }

    public static OVRFovPort nMaxEyeFov(long struct, int index) {
        return new OVRFovPort(struct + (long)MAXEYEFOV + (long)(index * OVRFovPort.SIZEOF));
    }

    public static OVRSizei nResolution(long struct) {
        return new OVRSizei(struct + (long)RESOLUTION);
    }

    public static float nDisplayRefreshRate(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DISPLAYREFRESHRATE);
    }

    static {
        Struct.Layout layout = OVRHmdDesc.__struct(OVRHmdDesc.__member(4), OVRHmdDesc.__padding(4, Pointer.BITS64), OVRHmdDesc.__array(1, 64), OVRHmdDesc.__array(1, 64), OVRHmdDesc.__member(2), OVRHmdDesc.__member(2), OVRHmdDesc.__array(1, 24), OVRHmdDesc.__member(2), OVRHmdDesc.__member(2), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__member(4), OVRHmdDesc.__array(OVRFovPort.SIZEOF, OVRFovPort.__ALIGNMENT, 2), OVRHmdDesc.__array(OVRFovPort.SIZEOF, OVRFovPort.__ALIGNMENT, 2), OVRHmdDesc.__member(OVRSizei.SIZEOF, OVRSizei.__ALIGNMENT), OVRHmdDesc.__member(4), OVRHmdDesc.__padding(4, Pointer.BITS64));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        TYPE = layout.offsetof(0);
        PRODUCTNAME = layout.offsetof(2);
        MANUFACTURER = layout.offsetof(3);
        VENDORID = layout.offsetof(4);
        PRODUCTID = layout.offsetof(5);
        SERIALNUMBER = layout.offsetof(6);
        FIRMWAREMAJOR = layout.offsetof(7);
        FIRMWAREMINOR = layout.offsetof(8);
        CAMERAFRUSTUMHFOVINRADIANS = layout.offsetof(9);
        CAMERAFRUSTUMVFOVINRADIANS = layout.offsetof(10);
        CAMERAFRUSTUMNEARZINMETERS = layout.offsetof(11);
        CAMERAFRUSTUMFARZINMETERS = layout.offsetof(12);
        AVAILABLEHMDCAPS = layout.offsetof(13);
        DEFAULTHMDCAPS = layout.offsetof(14);
        AVAILABLETRACKINGCAPS = layout.offsetof(15);
        DEFAULTTRACKINGCAPS = layout.offsetof(16);
        DEFAULTEYEFOV = layout.offsetof(17);
        MAXEYEFOV = layout.offsetof(18);
        RESOLUTION = layout.offsetof(19);
        DISPLAYREFRESHRATE = layout.offsetof(20);
    }

    public static final class Buffer
    extends StructBuffer<OVRHmdDesc, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRHmdDesc newInstance(long address) {
            return new OVRHmdDesc(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int Type() {
            return OVRHmdDesc.nType(this.address());
        }

        public ByteBuffer ProductName() {
            return OVRHmdDesc.nProductName(this.address());
        }

        public String ProductNameString() {
            return OVRHmdDesc.nProductNameString(this.address());
        }

        public ByteBuffer Manufacturer() {
            return OVRHmdDesc.nManufacturer(this.address());
        }

        public String ManufacturerString() {
            return OVRHmdDesc.nManufacturerString(this.address());
        }

        public short VendorId() {
            return OVRHmdDesc.nVendorId(this.address());
        }

        public short ProductId() {
            return OVRHmdDesc.nProductId(this.address());
        }

        public ByteBuffer SerialNumber() {
            return OVRHmdDesc.nSerialNumber(this.address());
        }

        public String SerialNumberString() {
            return OVRHmdDesc.nSerialNumberString(this.address());
        }

        public short FirmwareMajor() {
            return OVRHmdDesc.nFirmwareMajor(this.address());
        }

        public short FirmwareMinor() {
            return OVRHmdDesc.nFirmwareMinor(this.address());
        }

        public float CameraFrustumHFovInRadians() {
            return OVRHmdDesc.nCameraFrustumHFovInRadians(this.address());
        }

        public float CameraFrustumVFovInRadians() {
            return OVRHmdDesc.nCameraFrustumVFovInRadians(this.address());
        }

        public float CameraFrustumNearZInMeters() {
            return OVRHmdDesc.nCameraFrustumNearZInMeters(this.address());
        }

        public float CameraFrustumFarZInMeters() {
            return OVRHmdDesc.nCameraFrustumFarZInMeters(this.address());
        }

        public int AvailableHmdCaps() {
            return OVRHmdDesc.nAvailableHmdCaps(this.address());
        }

        public int DefaultHmdCaps() {
            return OVRHmdDesc.nDefaultHmdCaps(this.address());
        }

        public int AvailableTrackingCaps() {
            return OVRHmdDesc.nAvailableTrackingCaps(this.address());
        }

        public int DefaultTrackingCaps() {
            return OVRHmdDesc.nDefaultTrackingCaps(this.address());
        }

        public OVRFovPort.Buffer DefaultEyeFov() {
            return OVRHmdDesc.nDefaultEyeFov(this.address());
        }

        public OVRFovPort DefaultEyeFov(int index) {
            return OVRHmdDesc.nDefaultEyeFov(this.address(), index);
        }

        public OVRFovPort.Buffer MaxEyeFov() {
            return OVRHmdDesc.nMaxEyeFov(this.address());
        }

        public OVRFovPort MaxEyeFov(int index) {
            return OVRHmdDesc.nMaxEyeFov(this.address(), index);
        }

        public OVRSizei Resolution() {
            return OVRHmdDesc.nResolution(this.address());
        }

        public float DisplayRefreshRate() {
            return OVRHmdDesc.nDisplayRefreshRate(this.address());
        }
    }
}

