/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRFovPort
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int UPTAN;
    public static final int DOWNTAN;
    public static final int LEFTTAN;
    public static final int RIGHTTAN;

    OVRFovPort(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRFovPort(long struct) {
        this(struct, null);
    }

    public OVRFovPort(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public float UpTan() {
        return OVRFovPort.nUpTan(this.address());
    }

    public float DownTan() {
        return OVRFovPort.nDownTan(this.address());
    }

    public float LeftTan() {
        return OVRFovPort.nLeftTan(this.address());
    }

    public float RightTan() {
        return OVRFovPort.nRightTan(this.address());
    }

    public OVRFovPort UpTan(float value) {
        OVRFovPort.nUpTan(this.address(), value);
        return this;
    }

    public OVRFovPort DownTan(float value) {
        OVRFovPort.nDownTan(this.address(), value);
        return this;
    }

    public OVRFovPort LeftTan(float value) {
        OVRFovPort.nLeftTan(this.address(), value);
        return this;
    }

    public OVRFovPort RightTan(float value) {
        OVRFovPort.nRightTan(this.address(), value);
        return this;
    }

    public OVRFovPort set(float UpTan, float DownTan, float LeftTan, float RightTan) {
        this.UpTan(UpTan);
        this.DownTan(DownTan);
        this.LeftTan(LeftTan);
        this.RightTan(RightTan);
        return this;
    }

    public OVRFovPort nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public OVRFovPort set(OVRFovPort src) {
        return this.nset(src.address());
    }

    public OVRFovPort set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static OVRFovPort malloc() {
        return new OVRFovPort(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRFovPort calloc() {
        return new OVRFovPort(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRFovPort create() {
        return new OVRFovPort(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static float nUpTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)UPTAN);
    }

    public static float nDownTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)DOWNTAN);
    }

    public static float nLeftTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)LEFTTAN);
    }

    public static float nRightTan(long struct) {
        return MemoryUtil.memGetFloat(struct + (long)RIGHTTAN);
    }

    public static void nUpTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)UPTAN, value);
    }

    public static void nDownTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)DOWNTAN, value);
    }

    public static void nLeftTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)LEFTTAN, value);
    }

    public static void nRightTan(long struct, float value) {
        MemoryUtil.memPutFloat(struct + (long)RIGHTTAN, value);
    }

    static {
        Struct.Layout layout = OVRFovPort.__struct(OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4), OVRFovPort.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        UPTAN = layout.offsetof(0);
        DOWNTAN = layout.offsetof(1);
        LEFTTAN = layout.offsetof(2);
        RIGHTTAN = layout.offsetof(3);
    }

    public static final class Buffer
    extends StructBuffer<OVRFovPort, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRFovPort newInstance(long address) {
            return new OVRFovPort(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public float UpTan() {
            return OVRFovPort.nUpTan(this.address());
        }

        public float DownTan() {
            return OVRFovPort.nDownTan(this.address());
        }

        public float LeftTan() {
            return OVRFovPort.nLeftTan(this.address());
        }

        public float RightTan() {
            return OVRFovPort.nRightTan(this.address());
        }

        public Buffer UpTan(float value) {
            OVRFovPort.nUpTan(this.address(), value);
            return this;
        }

        public Buffer DownTan(float value) {
            OVRFovPort.nDownTan(this.address(), value);
            return this;
        }

        public Buffer LeftTan(float value) {
            OVRFovPort.nLeftTan(this.address(), value);
            return this;
        }

        public Buffer RightTan(float value) {
            OVRFovPort.nRightTan(this.address(), value);
            return this;
        }
    }
}

