/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.ovr;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class OVRDetectResult
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ISOCULUSSERVICERUNNING;
    public static final int ISOCULUSHMDCONNECTED;

    OVRDetectResult(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public OVRDetectResult(long struct) {
        this(struct, null);
    }

    public OVRDetectResult(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public boolean IsOculusServiceRunning() {
        return OVRDetectResult.nIsOculusServiceRunning(this.address());
    }

    public boolean IsOculusHMDConnected() {
        return OVRDetectResult.nIsOculusHMDConnected(this.address());
    }

    public static OVRDetectResult malloc() {
        return new OVRDetectResult(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static OVRDetectResult calloc() {
        return new OVRDetectResult(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static OVRDetectResult create() {
        return new OVRDetectResult(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static boolean nIsOculusServiceRunning(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISOCULUSSERVICERUNNING) != 0;
    }

    public static boolean nIsOculusHMDConnected(long struct) {
        return MemoryUtil.memGetByte(struct + (long)ISOCULUSHMDCONNECTED) != 0;
    }

    static {
        Struct.Layout layout = OVRDetectResult.__struct(OVRDetectResult.__member(1), OVRDetectResult.__member(1), OVRDetectResult.__padding(6, true));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ISOCULUSSERVICERUNNING = layout.offsetof(0);
        ISOCULUSHMDCONNECTED = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<OVRDetectResult, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected OVRDetectResult newInstance(long address) {
            return new OVRDetectResult(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public boolean IsOculusServiceRunning() {
            return OVRDetectResult.nIsOculusServiceRunning(this.address());
        }

        public boolean IsOculusHMDConnected() {
            return OVRDetectResult.nIsOculusHMDConnected(this.address());
        }
    }
}

