/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVDrawInstanced {
    public final long DrawArraysInstancedNV;
    public final long DrawElementsInstancedNV;

    protected NVDrawInstanced() {
        throw new UnsupportedOperationException();
    }

    public NVDrawInstanced(FunctionProvider provider) {
        this.DrawArraysInstancedNV = provider.getFunctionAddress("glDrawArraysInstancedNV");
        this.DrawElementsInstancedNV = provider.getFunctionAddress("glDrawElementsInstancedNV");
    }

    public static NVDrawInstanced getInstance() {
        return NVDrawInstanced.getInstance(GLES.getCapabilities());
    }

    public static NVDrawInstanced getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVDrawInstanced);
    }

    static NVDrawInstanced create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_draw_instanced")) {
            return null;
        }
        NVDrawInstanced funcs = new NVDrawInstanced(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedNV, funcs.DrawElementsInstancedNV);
        return GLES.checkExtension("GL_NV_draw_instanced", funcs, supported);
    }

    public static void glDrawArraysInstancedNV(int mode, int first, int count, int primcount) {
        long __functionAddress = NVDrawInstanced.getInstance().DrawArraysInstancedNV;
        JNI.callIIIIV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstancedNV(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = NVDrawInstanced.getInstance().DrawElementsInstancedNV;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedNV(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        NVDrawInstanced.nglDrawElementsInstancedNV(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

