/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.util.HashSet;
import java.util.StringTokenizer;
import org.lwjgl.egl.EGL;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESUtil;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class GLES {
    private static final ThreadLocal<GLESCapabilities> capsTL = new ThreadLocal();
    private static final APIUtil.APIVersion MAX_VERSION = Configuration.getAPIVersion(Configuration.MAXVERSION_OPENGLES);
    private static FunctionProvider functionProvider;

    private GLES() {
    }

    public static void create() {
        SharedLibrary GLES2;
        switch (Platform.get()) {
            case LINUX: {
                GLES2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "libGLESv2.so.2");
                break;
            }
            case MACOSX: {
                GLES2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "GLESv2");
                break;
            }
            case WINDOWS: {
                GLES2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "libGLESv2", "GLESv2");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GLES.create(GLES2);
    }

    public static void create(String libName) {
        GLES.create(Library.loadNative(libName));
    }

    private static void create(final SharedLibrary GLES2) {
        try {
            FunctionProvider.Default functionProvider = new FunctionProvider.Default(){

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    long address = EGL.getFunctionProvider().getFunctionAddress(functionName);
                    if (address == 0L && (address = GLES2.getFunctionAddress(functionName)) == 0L) {
                        APIUtil.apiLog("Failed to locate address for GLES function " + functionName);
                    }
                    return address;
                }

                @Override
                protected void destroy() {
                    GLES2.release();
                }
            };
            GLES.create(functionProvider);
        }
        catch (RuntimeException e) {
            GLES2.release();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GLES.functionProvider != null) {
            throw new IllegalStateException("OpenGL ES has already been created.");
        }
        GLES.functionProvider = functionProvider;
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLESCapabilities caps) {
        capsTL.set(caps);
    }

    public static GLESCapabilities getCapabilities() {
        GLESCapabilities caps = capsTL.get();
        if (caps == null) {
            throw new IllegalStateException("No GLESCapabilities instance has been set for the current thread.");
        }
        return caps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLESCapabilities createCapabilities() {
        GLESCapabilities caps = null;
        try {
            int minorVersion;
            int majorVersion;
            long GetError = functionProvider.getFunctionAddress("glGetError");
            long GetString = functionProvider.getFunctionAddress("glGetString");
            long GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
            if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
                throw new IllegalStateException("Core OpenGL ES functions could not be found. Make sure that the OpenGL ES library has been loaded correctly.");
            }
            int errorCode = JNI.invokeI(GetError);
            if (errorCode != 0) {
                APIUtil.apiLog("An OpenGL ES context was in an error state before the creation of its capabilities instance. Error: " + GLESUtil.getErrorString(errorCode));
            }
            APIBuffer __buffer = APIUtil.apiBuffer();
            __buffer.intParam(0, 0, 0);
            JNI.invokeIPV(GetIntegerv, 33307, __buffer.address());
            if (JNI.invokeI(GetError) == 0 && 3 <= (majorVersion = __buffer.intValue(0))) {
                JNI.invokeIPV(GetIntegerv, 33308, __buffer.address());
                minorVersion = __buffer.intValue(0);
            } else {
                long versionString = JNI.invokeIP(GetString, 7938);
                if (JNI.invokeI(GetError) == 0) {
                    throw new IllegalStateException("There is no OpenGL ES context current in the current thread.");
                }
                APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memDecodeUTF8(versionString), "OpenGL ES");
                majorVersion = version.major;
                minorVersion = version.minor;
            }
            if (majorVersion < 2) {
                throw new IllegalStateException("OpenGL ES 2.0 is required.");
            }
            int[] GL_VERSIONS = new int[]{-1, 0, 2};
            HashSet<String> supportedExtensions = new HashSet<String>(128);
            int maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
            if (MAX_VERSION != null) {
                maxMajor = Math.min(GLES.MAX_VERSION.major, maxMajor);
            }
            for (int M = 2; M <= maxMajor; ++M) {
                int maxMinor = GL_VERSIONS[M - 1];
                if (M == majorVersion) {
                    maxMinor = Math.min(minorVersion, maxMinor);
                }
                if (MAX_VERSION != null && M == GLES.MAX_VERSION.major) {
                    maxMinor = Math.min(GLES.MAX_VERSION.minor, maxMinor);
                }
                for (int m = 0; m <= maxMinor; ++m) {
                    supportedExtensions.add(String.format("GLES%d%d", M, m));
                }
            }
            if (majorVersion < 3) {
                String extensionsString = MemoryUtil.memDecodeASCII(Checks.checkPointer(JNI.invokeIP(GetString, 7939)));
                StringTokenizer tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            } else {
                JNI.invokeIPV(GetIntegerv, 33309, __buffer.address());
                int extensionCount = __buffer.intValue(0);
                long GetStringi = Checks.checkFunctionAddress(functionProvider.getFunctionAddress("glGetStringi"));
                for (int i = 0; i < extensionCount; ++i) {
                    supportedExtensions.add(MemoryUtil.memDecodeASCII(Checks.checkPointer(JNI.callIIP(GetStringi, 7939, i))));
                }
            }
            caps = new GLESCapabilities(GLES.getFunctionProvider(), supportedExtensions);
        }
        catch (Throwable throwable) {
            GLES.setCapabilities(caps);
            throw throwable;
        }
        GLES.setCapabilities(caps);
        return caps;
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        APIUtil.apiLog("[GLES] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        if (!((Boolean)Configuration.EXPLICIT_INIT_OPENGLES.get()).booleanValue()) {
            GLES.create();
        }
    }
}

