/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTInstancedArrays {
    public static final int GL_VERTEX_ATTRIB_ARRAY_DIVISOR_EXT = 35070;
    public final long DrawArraysInstancedEXT;
    public final long DrawElementsInstancedEXT;
    public final long VertexAttribDivisorEXT;

    protected EXTInstancedArrays() {
        throw new UnsupportedOperationException();
    }

    public EXTInstancedArrays(FunctionProvider provider) {
        this.DrawArraysInstancedEXT = provider.getFunctionAddress("glDrawArraysInstancedEXT");
        this.DrawElementsInstancedEXT = provider.getFunctionAddress("glDrawElementsInstancedEXT");
        this.VertexAttribDivisorEXT = provider.getFunctionAddress("glVertexAttribDivisorEXT");
    }

    public static EXTInstancedArrays getInstance() {
        return EXTInstancedArrays.getInstance(GLES.getCapabilities());
    }

    public static EXTInstancedArrays getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTInstancedArrays);
    }

    static EXTInstancedArrays create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_instanced_arrays")) {
            return null;
        }
        EXTInstancedArrays funcs = new EXTInstancedArrays(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedEXT, funcs.DrawElementsInstancedEXT, funcs.VertexAttribDivisorEXT);
        return GLES.checkExtension("GL_EXT_instanced_arrays", funcs, supported);
    }

    public static void glDrawArraysInstancedEXT(int mode, int start, int count, int primcount) {
        long __functionAddress = EXTInstancedArrays.getInstance().DrawArraysInstancedEXT;
        JNI.callIIIIV(__functionAddress, mode, start, count, primcount);
    }

    public static void nglDrawElementsInstancedEXT(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = EXTInstancedArrays.getInstance().DrawElementsInstancedEXT;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTInstancedArrays.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glVertexAttribDivisorEXT(int index, int divisor) {
        long __functionAddress = EXTInstancedArrays.getInstance().VertexAttribDivisorEXT;
        JNI.callIIV(__functionAddress, index, divisor);
    }
}

