/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.opengles.GLESChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTDrawInstanced {
    public final long DrawArraysInstancedEXT;
    public final long DrawElementsInstancedEXT;

    protected EXTDrawInstanced() {
        throw new UnsupportedOperationException();
    }

    public EXTDrawInstanced(FunctionProvider provider) {
        this.DrawArraysInstancedEXT = provider.getFunctionAddress("glDrawArraysInstancedEXT");
        this.DrawElementsInstancedEXT = provider.getFunctionAddress("glDrawElementsInstancedEXT");
    }

    public static EXTDrawInstanced getInstance() {
        return EXTDrawInstanced.getInstance(GLES.getCapabilities());
    }

    public static EXTDrawInstanced getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTDrawInstanced);
    }

    static EXTDrawInstanced create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_draw_instanced")) {
            return null;
        }
        EXTDrawInstanced funcs = new EXTDrawInstanced(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedEXT, funcs.DrawElementsInstancedEXT);
        return GLES.checkExtension("GL_EXT_draw_instanced", funcs, supported);
    }

    public static void glDrawArraysInstancedEXT(int mode, int start, int count, int primcount) {
        long __functionAddress = EXTDrawInstanced.getInstance().DrawArraysInstancedEXT;
        JNI.callIIIIV(__functionAddress, mode, start, count, primcount);
    }

    public static void nglDrawElementsInstancedEXT(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = EXTDrawInstanced.getInstance().DrawElementsInstancedEXT;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLESChecks.typeToByteShift(type));
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, true);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining() >> GLESChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedEXT(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLESChecks.ensureBufferObject(34965, false);
        }
        EXTDrawInstanced.nglDrawElementsInstancedEXT(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

