/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTBlendFuncExtended {
    public static final int GL_SRC1_COLOR_EXT = 35065;
    public static final int GL_SRC1_ALPHA_EXT = 34185;
    public static final int GL_ONE_MINUS_SRC1_COLOR_EXT = 35066;
    public static final int GL_ONE_MINUS_SRC1_ALPHA_EXT = 35067;
    public static final int GL_SRC_ALPHA_SATURATE_EXT = 776;
    public static final int GL_LOCATION_INDEX_EXT = 37647;
    public static final int GL_MAX_DUAL_SOURCE_DRAW_BUFFERS_EXT = 35068;
    public final long BindFragDataLocationIndexedEXT;
    public final long GetFragDataIndexEXT;
    public final long BindFragDataLocationEXT;
    public final long GetProgramResourceLocationIndexEXT;

    protected EXTBlendFuncExtended() {
        throw new UnsupportedOperationException();
    }

    public EXTBlendFuncExtended(FunctionProvider provider) {
        this.BindFragDataLocationIndexedEXT = provider.getFunctionAddress("glBindFragDataLocationIndexedEXT");
        this.GetFragDataIndexEXT = provider.getFunctionAddress("glGetFragDataIndexEXT");
        this.BindFragDataLocationEXT = provider.getFunctionAddress("glBindFragDataLocationEXT");
        this.GetProgramResourceLocationIndexEXT = provider.getFunctionAddress("glGetProgramResourceLocationIndexEXT");
    }

    public static EXTBlendFuncExtended getInstance() {
        return EXTBlendFuncExtended.getInstance(GLES.getCapabilities());
    }

    public static EXTBlendFuncExtended getInstance(GLESCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTBlendFuncExtended);
    }

    static EXTBlendFuncExtended create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_blend_func_extended")) {
            return null;
        }
        EXTBlendFuncExtended funcs = new EXTBlendFuncExtended(provider);
        boolean supported = Checks.checkFunctions(funcs.BindFragDataLocationIndexedEXT, funcs.GetFragDataIndexEXT, funcs.BindFragDataLocationEXT, funcs.GetProgramResourceLocationIndexEXT);
        return GLES.checkExtension("GL_EXT_blend_func_extended", funcs, supported);
    }

    public static void nglBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, long name) {
        long __functionAddress = EXTBlendFuncExtended.getInstance().BindFragDataLocationIndexedEXT;
        JNI.callIIIPV(__functionAddress, program, colorNumber, index, name);
    }

    public static void glBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        EXTBlendFuncExtended.nglBindFragDataLocationIndexedEXT(program, colorNumber, index, MemoryUtil.memAddress(name));
    }

    public static void glBindFragDataLocationIndexedEXT(int program, int colorNumber, int index, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        EXTBlendFuncExtended.nglBindFragDataLocationIndexedEXT(program, colorNumber, index, __buffer.address(nameEncoded));
    }

    public static int nglGetFragDataIndexEXT(int program, long name) {
        long __functionAddress = EXTBlendFuncExtended.getInstance().GetFragDataIndexEXT;
        return JNI.callIPI(__functionAddress, program, name);
    }

    public static int glGetFragDataIndexEXT(int program, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return EXTBlendFuncExtended.nglGetFragDataIndexEXT(program, MemoryUtil.memAddress(name));
    }

    public static int glGetFragDataIndexEXT(int program, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return EXTBlendFuncExtended.nglGetFragDataIndexEXT(program, __buffer.address(nameEncoded));
    }

    public static void nglBindFragDataLocationEXT(int program, int colorNumber, long name) {
        long __functionAddress = EXTBlendFuncExtended.getInstance().BindFragDataLocationEXT;
        JNI.callIIPV(__functionAddress, program, colorNumber, name);
    }

    public static void glBindFragDataLocationEXT(int program, int colorNumber, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        EXTBlendFuncExtended.nglBindFragDataLocationEXT(program, colorNumber, MemoryUtil.memAddress(name));
    }

    public static void glBindFragDataLocationEXT(int program, int colorNumber, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        EXTBlendFuncExtended.nglBindFragDataLocationEXT(program, colorNumber, __buffer.address(nameEncoded));
    }

    public static int nglGetProgramResourceLocationIndexEXT(int program, int programInterface, long name) {
        long __functionAddress = EXTBlendFuncExtended.getInstance().GetProgramResourceLocationIndexEXT;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocationIndexEXT(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return EXTBlendFuncExtended.nglGetProgramResourceLocationIndexEXT(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocationIndexEXT(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return EXTBlendFuncExtended.nglGetProgramResourceLocationIndexEXT(program, programInterface, __buffer.address(nameEncoded));
    }
}

