/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class WGLNVDXInterop {
    public static final int WGL_ACCESS_READ_ONLY_NV = 0;
    public static final int WGL_ACCESS_READ_WRITE_NV = 1;
    public static final int WGL_ACCESS_WRITE_DISCARD_NV = 2;
    public final long DXSetResourceShareHandleNV;
    public final long DXOpenDeviceNV;
    public final long DXCloseDeviceNV;
    public final long DXRegisterObjectNV;
    public final long DXUnregisterObjectNV;
    public final long DXObjectAccessNV;
    public final long DXLockObjectsNV;
    public final long DXUnlockObjectsNV;

    protected WGLNVDXInterop() {
        throw new UnsupportedOperationException();
    }

    public WGLNVDXInterop(FunctionProvider provider) {
        this.DXSetResourceShareHandleNV = provider.getFunctionAddress("wglDXSetResourceShareHandleNV");
        this.DXOpenDeviceNV = provider.getFunctionAddress("wglDXOpenDeviceNV");
        this.DXCloseDeviceNV = provider.getFunctionAddress("wglDXCloseDeviceNV");
        this.DXRegisterObjectNV = provider.getFunctionAddress("wglDXRegisterObjectNV");
        this.DXUnregisterObjectNV = provider.getFunctionAddress("wglDXUnregisterObjectNV");
        this.DXObjectAccessNV = provider.getFunctionAddress("wglDXObjectAccessNV");
        this.DXLockObjectsNV = provider.getFunctionAddress("wglDXLockObjectsNV");
        this.DXUnlockObjectsNV = provider.getFunctionAddress("wglDXUnlockObjectsNV");
    }

    public static WGLNVDXInterop getInstance() {
        return WGLNVDXInterop.getInstance(GL.getCapabilities());
    }

    public static WGLNVDXInterop getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__WGLNVDXInterop);
    }

    static WGLNVDXInterop create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("WGL_NV_DX_interop")) {
            return null;
        }
        WGLNVDXInterop funcs = new WGLNVDXInterop(provider);
        boolean supported = Checks.checkFunctions(funcs.DXSetResourceShareHandleNV, funcs.DXOpenDeviceNV, funcs.DXCloseDeviceNV, funcs.DXRegisterObjectNV, funcs.DXUnregisterObjectNV, funcs.DXObjectAccessNV, funcs.DXLockObjectsNV, funcs.DXUnlockObjectsNV);
        return GL.checkExtension("WGL_NV_DX_interop", funcs, supported);
    }

    public static int wglDXSetResourceShareHandleNV(long dxObject, long shareHandle) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXSetResourceShareHandleNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dxObject);
            Checks.checkPointer(shareHandle);
        }
        return JNI.callPPI(__functionAddress, dxObject, shareHandle);
    }

    public static long wglDXOpenDeviceNV(long dxDevice) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXOpenDeviceNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(dxDevice);
        }
        return JNI.callPP(__functionAddress, dxDevice);
    }

    public static int wglDXCloseDeviceNV(long device) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXCloseDeviceNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPI(__functionAddress, device);
    }

    public static long wglDXRegisterObjectNV(long device, long dxResource, int name, int type, int access) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXRegisterObjectNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
            Checks.checkPointer(dxResource);
        }
        return JNI.callPPIIIP(__functionAddress, device, dxResource, name, type, access);
    }

    public static int wglDXUnregisterObjectNV(long device, long object) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXUnregisterObjectNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
            Checks.checkPointer(object);
        }
        return JNI.callPPI(__functionAddress, device, object);
    }

    public static int wglDXObjectAccessNV(long object, int access) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXObjectAccessNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(object);
        }
        return JNI.callPII(__functionAddress, object, access);
    }

    public static int nwglDXLockObjectsNV(long device, int count, long objects) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXLockObjectsNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPIPI(__functionAddress, device, count, objects);
    }

    public static int wglDXLockObjectsNV(long device, int count, ByteBuffer objects) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)objects, count << Pointer.POINTER_SHIFT);
        }
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, count, MemoryUtil.memAddress(objects));
    }

    public static int wglDXLockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXLockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects));
    }

    public static int nwglDXUnlockObjectsNV(long device, int count, long objects) {
        long __functionAddress = WGLNVDXInterop.getInstance().DXUnlockObjectsNV;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPIPI(__functionAddress, device, count, objects);
    }

    public static int wglDXUnlockObjectsNV(long device, int count, ByteBuffer objects) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)objects, count << Pointer.POINTER_SHIFT);
        }
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, count, MemoryUtil.memAddress(objects));
    }

    public static int wglDXUnlockObjectsNV(long device, PointerBuffer objects) {
        return WGLNVDXInterop.nwglDXUnlockObjectsNV(device, objects.remaining(), MemoryUtil.memAddress(objects));
    }
}

