/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVShaderBufferLoad {
    public static final int GL_BUFFER_GPU_ADDRESS_NV = 36637;
    public static final int GL_GPU_ADDRESS_NV = 36660;
    public static final int GL_MAX_SHADER_BUFFER_ADDRESS_NV = 36661;
    public final long MakeBufferResidentNV;
    public final long MakeBufferNonResidentNV;
    public final long IsBufferResidentNV;
    public final long MakeNamedBufferResidentNV;
    public final long MakeNamedBufferNonResidentNV;
    public final long IsNamedBufferResidentNV;
    public final long GetBufferParameterui64vNV;
    public final long GetNamedBufferParameterui64vNV;
    public final long GetIntegerui64vNV;
    public final long Uniformui64NV;
    public final long Uniformui64vNV;
    public final long GetUniformui64vNV;
    public final long ProgramUniformui64NV;
    public final long ProgramUniformui64vNV;

    protected NVShaderBufferLoad() {
        throw new UnsupportedOperationException();
    }

    public NVShaderBufferLoad(FunctionProvider provider) {
        this.MakeBufferResidentNV = provider.getFunctionAddress("glMakeBufferResidentNV");
        this.MakeBufferNonResidentNV = provider.getFunctionAddress("glMakeBufferNonResidentNV");
        this.IsBufferResidentNV = provider.getFunctionAddress("glIsBufferResidentNV");
        this.MakeNamedBufferResidentNV = provider.getFunctionAddress("glMakeNamedBufferResidentNV");
        this.MakeNamedBufferNonResidentNV = provider.getFunctionAddress("glMakeNamedBufferNonResidentNV");
        this.IsNamedBufferResidentNV = provider.getFunctionAddress("glIsNamedBufferResidentNV");
        this.GetBufferParameterui64vNV = provider.getFunctionAddress("glGetBufferParameterui64vNV");
        this.GetNamedBufferParameterui64vNV = provider.getFunctionAddress("glGetNamedBufferParameterui64vNV");
        this.GetIntegerui64vNV = provider.getFunctionAddress("glGetIntegerui64vNV");
        this.Uniformui64NV = provider.getFunctionAddress("glUniformui64NV");
        this.Uniformui64vNV = provider.getFunctionAddress("glUniformui64vNV");
        this.GetUniformui64vNV = provider.getFunctionAddress("glGetUniformui64vNV");
        this.ProgramUniformui64NV = provider.getFunctionAddress("glProgramUniformui64NV");
        this.ProgramUniformui64vNV = provider.getFunctionAddress("glProgramUniformui64vNV");
    }

    public static NVShaderBufferLoad getInstance() {
        return NVShaderBufferLoad.getInstance(GL.getCapabilities());
    }

    public static NVShaderBufferLoad getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVShaderBufferLoad);
    }

    static NVShaderBufferLoad create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_shader_buffer_load")) {
            return null;
        }
        NVShaderBufferLoad funcs = new NVShaderBufferLoad(provider);
        boolean supported = Checks.checkFunctions(funcs.MakeBufferResidentNV, funcs.MakeBufferNonResidentNV, funcs.IsBufferResidentNV, funcs.MakeNamedBufferResidentNV, funcs.MakeNamedBufferNonResidentNV, funcs.IsNamedBufferResidentNV, funcs.GetBufferParameterui64vNV, funcs.GetNamedBufferParameterui64vNV, funcs.GetIntegerui64vNV, funcs.Uniformui64NV, funcs.Uniformui64vNV, funcs.GetUniformui64vNV, funcs.ProgramUniformui64NV, funcs.ProgramUniformui64vNV);
        return GL.checkExtension("GL_NV_shader_buffer_load", funcs, supported);
    }

    public static void glMakeBufferResidentNV(int target, int access) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeBufferResidentNV;
        JNI.callIIV(__functionAddress, target, access);
    }

    public static void glMakeBufferNonResidentNV(int target) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeBufferNonResidentNV;
        JNI.callIV(__functionAddress, target);
    }

    public static boolean glIsBufferResidentNV(int target) {
        long __functionAddress = NVShaderBufferLoad.getInstance().IsBufferResidentNV;
        return JNI.callIZ(__functionAddress, target);
    }

    public static void glMakeNamedBufferResidentNV(int buffer, int access) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeNamedBufferResidentNV;
        JNI.callIIV(__functionAddress, buffer, access);
    }

    public static void glMakeNamedBufferNonResidentNV(int buffer) {
        long __functionAddress = NVShaderBufferLoad.getInstance().MakeNamedBufferNonResidentNV;
        JNI.callIV(__functionAddress, buffer);
    }

    public static boolean glIsNamedBufferResidentNV(int buffer) {
        long __functionAddress = NVShaderBufferLoad.getInstance().IsNamedBufferResidentNV;
        return JNI.callIZ(__functionAddress, buffer);
    }

    public static void nglGetBufferParameterui64vNV(int target, int pname, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetBufferParameterui64vNV;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetBufferParameterui64vNV(int target, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetBufferParameterui64NV(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetBufferParameterui64vNV(target, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetNamedBufferParameterui64vNV(int buffer, int pname, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetNamedBufferParameterui64vNV;
        JNI.callIIPV(__functionAddress, buffer, pname, params);
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetNamedBufferParameterui64vNV(int buffer, int pname, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, MemoryUtil.memAddress(params));
    }

    public static long glGetNamedBufferParameterui64NV(int buffer, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetNamedBufferParameterui64vNV(buffer, pname, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void nglGetIntegerui64vNV(int value, long result) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetIntegerui64vNV;
        JNI.callIPV(__functionAddress, value, result);
    }

    public static void glGetIntegerui64vNV(int value, ByteBuffer result) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)result, 8);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    public static void glGetIntegerui64vNV(int value, LongBuffer result) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)result, 1);
        }
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, MemoryUtil.memAddress(result));
    }

    public static long glGetIntegerui64NV(int value) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int result = __buffer.longParam();
        NVShaderBufferLoad.nglGetIntegerui64vNV(value, __buffer.address(result));
        return __buffer.longValue(result);
    }

    public static void glUniformui64NV(int location, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().Uniformui64NV;
        JNI.callIJV(__functionAddress, location, value);
    }

    public static void nglUniformui64vNV(int location, int count, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().Uniformui64vNV;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniformui64vNV(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        NVShaderBufferLoad.nglUniformui64vNV(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniformui64vNV(int location, LongBuffer value) {
        NVShaderBufferLoad.nglUniformui64vNV(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglGetUniformui64vNV(int program, int location, long params) {
        long __functionAddress = NVShaderBufferLoad.getInstance().GetUniformui64vNV;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformui64vNV(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformui64vNV(int program, int location, LongBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, MemoryUtil.memAddress(params));
    }

    public static long glGetUniformui64NV(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        NVShaderBufferLoad.nglGetUniformui64vNV(program, location, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void glProgramUniformui64NV(int program, int location, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().ProgramUniformui64NV;
        JNI.callIIJV(__functionAddress, program, location, value);
    }

    public static void nglProgramUniformui64vNV(int program, int location, int count, long value) {
        long __functionAddress = NVShaderBufferLoad.getInstance().ProgramUniformui64vNV;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniformui64vNV(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformui64vNV(int program, int location, LongBuffer value) {
        NVShaderBufferLoad.nglProgramUniformui64vNV(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }
}

