/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVPixelDataRange {
    public static final int GL_WRITE_PIXEL_DATA_RANGE_NV = 34936;
    public static final int GL_READ_PIXEL_DATA_RANGE_NV = 34937;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV = 34938;
    public static final int GL_READ_PIXEL_DATA_RANGE_LENGTH_NV = 34939;
    public static final int GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV = 34940;
    public static final int GL_READ_PIXEL_DATA_RANGE_POINTER_NV = 34941;
    public final long PixelDataRangeNV;
    public final long FlushPixelDataRangeNV;

    protected NVPixelDataRange() {
        throw new UnsupportedOperationException();
    }

    public NVPixelDataRange(FunctionProvider provider) {
        this.PixelDataRangeNV = provider.getFunctionAddress("glPixelDataRangeNV");
        this.FlushPixelDataRangeNV = provider.getFunctionAddress("glFlushPixelDataRangeNV");
    }

    public static NVPixelDataRange getInstance() {
        return NVPixelDataRange.getInstance(GL.getCapabilities());
    }

    public static NVPixelDataRange getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVPixelDataRange);
    }

    static NVPixelDataRange create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_pixel_data_range")) {
            return null;
        }
        NVPixelDataRange funcs = new NVPixelDataRange(provider);
        boolean supported = Checks.checkFunctions(funcs.PixelDataRangeNV, funcs.FlushPixelDataRangeNV);
        return GL.checkExtension("GL_NV_pixel_data_range", funcs, supported);
    }

    public static void nglPixelDataRangeNV(int target, int length, long pointer) {
        long __functionAddress = NVPixelDataRange.getInstance().PixelDataRangeNV;
        JNI.callIIPV(__functionAddress, target, length, pointer);
    }

    public static void glPixelDataRangeNV(int target, int length, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pointer, length);
        }
        NVPixelDataRange.nglPixelDataRangeNV(target, length, MemoryUtil.memAddress(pointer));
    }

    public static void glPixelDataRangeNV(int target, ByteBuffer pointer) {
        NVPixelDataRange.nglPixelDataRangeNV(target, pointer.remaining(), MemoryUtil.memAddress(pointer));
    }

    public static void glFlushPixelDataRangeNV(int target) {
        long __functionAddress = NVPixelDataRange.getInstance().FlushPixelDataRangeNV;
        JNI.callIV(__functionAddress, target);
    }
}

