/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVFramebufferMixedSamples {
    public static final int GL_RASTER_MULTISAMPLE_EXT = 37671;
    public static final int GL_COVERAGE_MODULATION_TABLE_NV = 37681;
    public static final int GL_RASTER_SAMPLES_EXT = 37672;
    public static final int GL_MAX_RASTER_SAMPLES_EXT = 37673;
    public static final int GL_RASTER_FIXED_SAMPLE_LOCATIONS_EXT = 37674;
    public static final int GL_MULTISAMPLE_RASTERIZATION_ALLOWED_EXT = 37675;
    public static final int GL_EFFECTIVE_RASTER_SAMPLES_EXT = 37676;
    public static final int GL_COLOR_SAMPLES_NV = 36384;
    public static final int GL_DEPTH_SAMPLES_NV = 37677;
    public static final int GL_STENCIL_SAMPLES_NV = 37678;
    public static final int GL_MIXED_DEPTH_SAMPLES_SUPPORTED_NV = 37679;
    public static final int GL_MIXED_STENCIL_SAMPLES_SUPPORTED_NV = 37680;
    public static final int GL_COVERAGE_MODULATION_NV = 37682;
    public static final int GL_COVERAGE_MODULATION_TABLE_SIZE_NV = 37683;
    public final long RasterSamplesEXT;
    public final long CoverageModulationTableNV;
    public final long GetCoverageModulationTableNV;
    public final long CoverageModulationNV;

    protected NVFramebufferMixedSamples() {
        throw new UnsupportedOperationException();
    }

    public NVFramebufferMixedSamples(FunctionProvider provider) {
        this.RasterSamplesEXT = provider.getFunctionAddress("glRasterSamplesEXT");
        this.CoverageModulationTableNV = provider.getFunctionAddress("glCoverageModulationTableNV");
        this.GetCoverageModulationTableNV = provider.getFunctionAddress("glGetCoverageModulationTableNV");
        this.CoverageModulationNV = provider.getFunctionAddress("glCoverageModulationNV");
    }

    public static NVFramebufferMixedSamples getInstance() {
        return NVFramebufferMixedSamples.getInstance(GL.getCapabilities());
    }

    public static NVFramebufferMixedSamples getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVFramebufferMixedSamples);
    }

    static NVFramebufferMixedSamples create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_framebuffer_mixed_samples")) {
            return null;
        }
        NVFramebufferMixedSamples funcs = new NVFramebufferMixedSamples(provider);
        boolean supported = Checks.checkFunctions(funcs.RasterSamplesEXT, funcs.CoverageModulationTableNV, funcs.GetCoverageModulationTableNV, funcs.CoverageModulationNV);
        return GL.checkExtension("GL_NV_framebuffer_mixed_samples", funcs, supported);
    }

    public static void glRasterSamplesEXT(int samples, boolean fixedsamplelocations) {
        long __functionAddress = NVFramebufferMixedSamples.getInstance().RasterSamplesEXT;
        JNI.callIZV(__functionAddress, samples, fixedsamplelocations);
    }

    public static void nglCoverageModulationTableNV(int n, long v) {
        long __functionAddress = NVFramebufferMixedSamples.getInstance().CoverageModulationTableNV;
        JNI.callIPV(__functionAddress, n, v);
    }

    public static void glCoverageModulationTableNV(int n, ByteBuffer v) {
        NVFramebufferMixedSamples.nglCoverageModulationTableNV(n, MemoryUtil.memAddress(v));
    }

    public static void glCoverageModulationTableNV(int n, FloatBuffer v) {
        NVFramebufferMixedSamples.nglCoverageModulationTableNV(n, MemoryUtil.memAddress(v));
    }

    public static void nglGetCoverageModulationTableNV(int bufsize, long v) {
        long __functionAddress = NVFramebufferMixedSamples.getInstance().GetCoverageModulationTableNV;
        JNI.callIPV(__functionAddress, bufsize, v);
    }

    public static void glGetCoverageModulationTableNV(int bufsize, ByteBuffer v) {
        NVFramebufferMixedSamples.nglGetCoverageModulationTableNV(bufsize, MemoryUtil.memAddress(v));
    }

    public static void glGetCoverageModulationTableNV(int bufsize, FloatBuffer v) {
        NVFramebufferMixedSamples.nglGetCoverageModulationTableNV(bufsize, MemoryUtil.memAddress(v));
    }

    public static void glCoverageModulationNV(int components) {
        long __functionAddress = NVFramebufferMixedSamples.getInstance().CoverageModulationNV;
        JNI.callIV(__functionAddress, components);
    }
}

