/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class NVFence {
    public static final int GL_ALL_COMPLETED_NV = 34034;
    public static final int GL_FENCE_STATUS_NV = 34035;
    public static final int GL_FENCE_CONDITION_NV = 34036;
    public final long DeleteFencesNV;
    public final long GenFencesNV;
    public final long IsFenceNV;
    public final long TestFenceNV;
    public final long GetFenceivNV;
    public final long FinishFenceNV;
    public final long SetFenceNV;

    protected NVFence() {
        throw new UnsupportedOperationException();
    }

    public NVFence(FunctionProvider provider) {
        this.DeleteFencesNV = provider.getFunctionAddress("glDeleteFencesNV");
        this.GenFencesNV = provider.getFunctionAddress("glGenFencesNV");
        this.IsFenceNV = provider.getFunctionAddress("glIsFenceNV");
        this.TestFenceNV = provider.getFunctionAddress("glTestFenceNV");
        this.GetFenceivNV = provider.getFunctionAddress("glGetFenceivNV");
        this.FinishFenceNV = provider.getFunctionAddress("glFinishFenceNV");
        this.SetFenceNV = provider.getFunctionAddress("glSetFenceNV");
    }

    public static NVFence getInstance() {
        return NVFence.getInstance(GL.getCapabilities());
    }

    public static NVFence getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__NVFence);
    }

    static NVFence create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_NV_fence")) {
            return null;
        }
        NVFence funcs = new NVFence(provider);
        boolean supported = Checks.checkFunctions(funcs.DeleteFencesNV, funcs.GenFencesNV, funcs.IsFenceNV, funcs.TestFenceNV, funcs.GetFenceivNV, funcs.FinishFenceNV, funcs.SetFenceNV);
        return GL.checkExtension("GL_NV_fence", funcs, supported);
    }

    public static void nglDeleteFencesNV(int n, long fences) {
        long __functionAddress = NVFence.getInstance().DeleteFencesNV;
        JNI.callIPV(__functionAddress, n, fences);
    }

    public static void glDeleteFencesNV(int n, ByteBuffer fences) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)fences, n << 2);
        }
        NVFence.nglDeleteFencesNV(n, MemoryUtil.memAddress(fences));
    }

    public static void glDeleteFencesNV(IntBuffer fences) {
        NVFence.nglDeleteFencesNV(fences.remaining(), MemoryUtil.memAddress(fences));
    }

    public static void glDeleteFencesNV(int fence) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int fences = __buffer.intParam(fence);
        NVFence.nglDeleteFencesNV(1, __buffer.address(fences));
    }

    public static void nglGenFencesNV(int n, long fences) {
        long __functionAddress = NVFence.getInstance().GenFencesNV;
        JNI.callIPV(__functionAddress, n, fences);
    }

    public static void glGenFencesNV(int n, ByteBuffer fences) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)fences, n << 2);
        }
        NVFence.nglGenFencesNV(n, MemoryUtil.memAddress(fences));
    }

    public static void glGenFencesNV(IntBuffer fences) {
        NVFence.nglGenFencesNV(fences.remaining(), MemoryUtil.memAddress(fences));
    }

    public static int glGenFencesNV() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int fences = __buffer.intParam();
        NVFence.nglGenFencesNV(1, __buffer.address(fences));
        return __buffer.intValue(fences);
    }

    public static boolean glIsFenceNV(int fence) {
        long __functionAddress = NVFence.getInstance().IsFenceNV;
        return JNI.callIZ(__functionAddress, fence);
    }

    public static boolean glTestFenceNV(int fence) {
        long __functionAddress = NVFence.getInstance().TestFenceNV;
        return JNI.callIZ(__functionAddress, fence);
    }

    public static void nglGetFenceivNV(int fence, int pname, long params) {
        long __functionAddress = NVFence.getInstance().GetFenceivNV;
        JNI.callIIPV(__functionAddress, fence, pname, params);
    }

    public static void glGetFenceivNV(int fence, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFenceivNV(int fence, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        NVFence.nglGetFenceivNV(fence, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFenceiNV(int fence, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        NVFence.nglGetFenceivNV(fence, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glFinishFenceNV(int fence) {
        long __functionAddress = NVFence.getInstance().FinishFenceNV;
        JNI.callIV(__functionAddress, fence);
    }

    public static void glSetFenceNV(int fence, int condition) {
        long __functionAddress = NVFence.getInstance().SetFenceNV;
        JNI.callIIV(__functionAddress, fence, condition);
    }
}

