/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GLXSGIVideoSync {
    public final long GetVideoSyncSGI;
    public final long WaitVideoSyncSGI;

    protected GLXSGIVideoSync() {
        throw new UnsupportedOperationException();
    }

    public GLXSGIVideoSync(FunctionProvider provider) {
        this.GetVideoSyncSGI = provider.getFunctionAddress("glXGetVideoSyncSGI");
        this.WaitVideoSyncSGI = provider.getFunctionAddress("glXWaitVideoSyncSGI");
    }

    public static GLXSGIVideoSync getInstance() {
        return GLXSGIVideoSync.getInstance(GL.getCapabilities());
    }

    public static GLXSGIVideoSync getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GLXSGIVideoSync);
    }

    static GLXSGIVideoSync create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GLX_SGI_video_sync")) {
            return null;
        }
        GLXSGIVideoSync funcs = new GLXSGIVideoSync(provider);
        boolean supported = Checks.checkFunctions(funcs.GetVideoSyncSGI, funcs.WaitVideoSyncSGI);
        return GL.checkExtension("GLX_SGI_video_sync", funcs, supported);
    }

    public static int nglXGetVideoSyncSGI(long count) {
        long __functionAddress = GLXSGIVideoSync.getInstance().GetVideoSyncSGI;
        return JNI.callPI(__functionAddress, count);
    }

    public static int glXGetVideoSyncSGI(ByteBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return GLXSGIVideoSync.nglXGetVideoSyncSGI(MemoryUtil.memAddress(count));
    }

    public static int glXGetVideoSyncSGI(IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXSGIVideoSync.nglXGetVideoSyncSGI(MemoryUtil.memAddress(count));
    }

    public static int nglXWaitVideoSyncSGI(int divisor, int remainder, long count) {
        long __functionAddress = GLXSGIVideoSync.getInstance().WaitVideoSyncSGI;
        return JNI.callIIPI(__functionAddress, divisor, remainder, count);
    }

    public static int glXWaitVideoSyncSGI(int divisor, int remainder, ByteBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 4);
        }
        return GLXSGIVideoSync.nglXWaitVideoSyncSGI(divisor, remainder, MemoryUtil.memAddress(count));
    }

    public static int glXWaitVideoSyncSGI(int divisor, int remainder, IntBuffer count) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, 1);
        }
        return GLXSGIVideoSync.nglXWaitVideoSyncSGI(divisor, remainder, MemoryUtil.memAddress(count));
    }
}

