/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.opengl.GLDebugMessageCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GL43 {
    public static final int GL_NUM_SHADING_LANGUAGE_VERSIONS = 33513;
    public static final int GL_VERTEX_ATTRIB_ARRAY_LONG = 34638;
    public static final int GL_COMPRESSED_RGB8_ETC2 = 37492;
    public static final int GL_COMPRESSED_SRGB8_ETC2 = 37493;
    public static final int GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37494;
    public static final int GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2 = 37495;
    public static final int GL_COMPRESSED_RGBA8_ETC2_EAC = 37496;
    public static final int GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC = 37497;
    public static final int GL_COMPRESSED_R11_EAC = 37488;
    public static final int GL_COMPRESSED_SIGNED_R11_EAC = 37489;
    public static final int GL_COMPRESSED_RG11_EAC = 37490;
    public static final int GL_COMPRESSED_SIGNED_RG11_EAC = 37491;
    public static final int GL_PRIMITIVE_RESTART_FIXED_INDEX = 36201;
    public static final int GL_ANY_SAMPLES_PASSED_CONSERVATIVE = 36202;
    public static final int GL_MAX_ELEMENT_INDEX = 36203;
    public static final int GL_TEXTURE_IMMUTABLE_LEVELS = 33503;
    public static final int GL_COMPUTE_SHADER = 37305;
    public static final int GL_MAX_COMPUTE_UNIFORM_BLOCKS = 37307;
    public static final int GL_MAX_COMPUTE_TEXTURE_IMAGE_UNITS = 37308;
    public static final int GL_MAX_COMPUTE_IMAGE_UNIFORMS = 37309;
    public static final int GL_MAX_COMPUTE_SHARED_MEMORY_SIZE = 33378;
    public static final int GL_MAX_COMPUTE_UNIFORM_COMPONENTS = 33379;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTER_BUFFERS = 33380;
    public static final int GL_MAX_COMPUTE_ATOMIC_COUNTERS = 33381;
    public static final int GL_MAX_COMBINED_COMPUTE_UNIFORM_COMPONENTS = 33382;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_INVOCATIONS = 37099;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_COUNT = 37310;
    public static final int GL_MAX_COMPUTE_WORK_GROUP_SIZE = 37311;
    public static final int GL_COMPUTE_WORK_GROUP_SIZE = 33383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_COMPUTE_SHADER = 37100;
    public static final int GL_ATOMIC_COUNTER_BUFFER_REFERENCED_BY_COMPUTE_SHADER = 37101;
    public static final int GL_DISPATCH_INDIRECT_BUFFER = 37102;
    public static final int GL_DISPATCH_INDIRECT_BUFFER_BINDING = 37103;
    public static final int GL_COMPUTE_SHADER_BIT = 32;
    public static final int GL_DEBUG_OUTPUT = 37600;
    public static final int GL_DEBUG_OUTPUT_SYNCHRONOUS = 33346;
    public static final int GL_CONTEXT_FLAG_DEBUG_BIT = 2;
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES = 37189;
    public static final int GL_DEBUG_NEXT_LOGGED_MESSAGE_LENGTH = 33347;
    public static final int GL_MAX_DEBUG_GROUP_STACK_DEPTH = 33388;
    public static final int GL_DEBUG_GROUP_STACK_DEPTH = 33389;
    public static final int GL_MAX_LABEL_LENGTH = 33512;
    public static final int GL_DEBUG_CALLBACK_FUNCTION = 33348;
    public static final int GL_DEBUG_CALLBACK_USER_PARAM = 33349;
    public static final int GL_DEBUG_SOURCE_API = 33350;
    public static final int GL_DEBUG_SOURCE_WINDOW_SYSTEM = 33351;
    public static final int GL_DEBUG_SOURCE_SHADER_COMPILER = 33352;
    public static final int GL_DEBUG_SOURCE_THIRD_PARTY = 33353;
    public static final int GL_DEBUG_SOURCE_APPLICATION = 33354;
    public static final int GL_DEBUG_SOURCE_OTHER = 33355;
    public static final int GL_DEBUG_TYPE_ERROR = 33356;
    public static final int GL_DEBUG_TYPE_DEPRECATED_BEHAVIOR = 33357;
    public static final int GL_DEBUG_TYPE_UNDEFINED_BEHAVIOR = 33358;
    public static final int GL_DEBUG_TYPE_PORTABILITY = 33359;
    public static final int GL_DEBUG_TYPE_PERFORMANCE = 33360;
    public static final int GL_DEBUG_TYPE_OTHER = 33361;
    public static final int GL_DEBUG_TYPE_MARKER = 33384;
    public static final int GL_DEBUG_TYPE_PUSH_GROUP = 33385;
    public static final int GL_DEBUG_TYPE_POP_GROUP = 33386;
    public static final int GL_DEBUG_SEVERITY_HIGH = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW = 37192;
    public static final int GL_DEBUG_SEVERITY_NOTIFICATION = 33387;
    public static final int GL_BUFFER = 33504;
    public static final int GL_SHADER = 33505;
    public static final int GL_PROGRAM = 33506;
    public static final int GL_QUERY = 33507;
    public static final int GL_PROGRAM_PIPELINE = 33508;
    public static final int GL_SAMPLER = 33510;
    public static final int GL_DISPLAY_LIST = 33511;
    public static final int GL_MAX_UNIFORM_LOCATIONS = 33390;
    public static final int GL_FRAMEBUFFER_DEFAULT_WIDTH = 37648;
    public static final int GL_FRAMEBUFFER_DEFAULT_HEIGHT = 37649;
    public static final int GL_FRAMEBUFFER_DEFAULT_LAYERS = 37650;
    public static final int GL_FRAMEBUFFER_DEFAULT_SAMPLES = 37651;
    public static final int GL_FRAMEBUFFER_DEFAULT_FIXED_SAMPLE_LOCATIONS = 37652;
    public static final int GL_MAX_FRAMEBUFFER_WIDTH = 37653;
    public static final int GL_MAX_FRAMEBUFFER_HEIGHT = 37654;
    public static final int GL_MAX_FRAMEBUFFER_LAYERS = 37655;
    public static final int GL_MAX_FRAMEBUFFER_SAMPLES = 37656;
    public static final int GL_INTERNALFORMAT_SUPPORTED = 33391;
    public static final int GL_INTERNALFORMAT_PREFERRED = 33392;
    public static final int GL_INTERNALFORMAT_RED_SIZE = 33393;
    public static final int GL_INTERNALFORMAT_GREEN_SIZE = 33394;
    public static final int GL_INTERNALFORMAT_BLUE_SIZE = 33395;
    public static final int GL_INTERNALFORMAT_ALPHA_SIZE = 33396;
    public static final int GL_INTERNALFORMAT_DEPTH_SIZE = 33397;
    public static final int GL_INTERNALFORMAT_STENCIL_SIZE = 33398;
    public static final int GL_INTERNALFORMAT_SHARED_SIZE = 33399;
    public static final int GL_INTERNALFORMAT_RED_TYPE = 33400;
    public static final int GL_INTERNALFORMAT_GREEN_TYPE = 33401;
    public static final int GL_INTERNALFORMAT_BLUE_TYPE = 33402;
    public static final int GL_INTERNALFORMAT_ALPHA_TYPE = 33403;
    public static final int GL_INTERNALFORMAT_DEPTH_TYPE = 33404;
    public static final int GL_INTERNALFORMAT_STENCIL_TYPE = 33405;
    public static final int GL_MAX_WIDTH = 33406;
    public static final int GL_MAX_HEIGHT = 33407;
    public static final int GL_MAX_DEPTH = 33408;
    public static final int GL_MAX_LAYERS = 33409;
    public static final int GL_MAX_COMBINED_DIMENSIONS = 33410;
    public static final int GL_COLOR_COMPONENTS = 33411;
    public static final int GL_DEPTH_COMPONENTS = 33412;
    public static final int GL_STENCIL_COMPONENTS = 33413;
    public static final int GL_COLOR_RENDERABLE = 33414;
    public static final int GL_DEPTH_RENDERABLE = 33415;
    public static final int GL_STENCIL_RENDERABLE = 33416;
    public static final int GL_FRAMEBUFFER_RENDERABLE = 33417;
    public static final int GL_FRAMEBUFFER_RENDERABLE_LAYERED = 33418;
    public static final int GL_FRAMEBUFFER_BLEND = 33419;
    public static final int GL_READ_PIXELS = 33420;
    public static final int GL_READ_PIXELS_FORMAT = 33421;
    public static final int GL_READ_PIXELS_TYPE = 33422;
    public static final int GL_TEXTURE_IMAGE_FORMAT = 33423;
    public static final int GL_TEXTURE_IMAGE_TYPE = 33424;
    public static final int GL_GET_TEXTURE_IMAGE_FORMAT = 33425;
    public static final int GL_GET_TEXTURE_IMAGE_TYPE = 33426;
    public static final int GL_MIPMAP = 33427;
    public static final int GL_MANUAL_GENERATE_MIPMAP = 33428;
    public static final int GL_AUTO_GENERATE_MIPMAP = 33429;
    public static final int GL_COLOR_ENCODING = 33430;
    public static final int GL_SRGB_READ = 33431;
    public static final int GL_SRGB_WRITE = 33432;
    public static final int GL_FILTER = 33434;
    public static final int GL_VERTEX_TEXTURE = 33435;
    public static final int GL_TESS_CONTROL_TEXTURE = 33436;
    public static final int GL_TESS_EVALUATION_TEXTURE = 33437;
    public static final int GL_GEOMETRY_TEXTURE = 33438;
    public static final int GL_FRAGMENT_TEXTURE = 33439;
    public static final int GL_COMPUTE_TEXTURE = 33440;
    public static final int GL_TEXTURE_SHADOW = 33441;
    public static final int GL_TEXTURE_GATHER = 33442;
    public static final int GL_TEXTURE_GATHER_SHADOW = 33443;
    public static final int GL_SHADER_IMAGE_LOAD = 33444;
    public static final int GL_SHADER_IMAGE_STORE = 33445;
    public static final int GL_SHADER_IMAGE_ATOMIC = 33446;
    public static final int GL_IMAGE_TEXEL_SIZE = 33447;
    public static final int GL_IMAGE_COMPATIBILITY_CLASS = 33448;
    public static final int GL_IMAGE_PIXEL_FORMAT = 33449;
    public static final int GL_IMAGE_PIXEL_TYPE = 33450;
    public static final int GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_TEST = 33452;
    public static final int GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_TEST = 33453;
    public static final int GL_SIMULTANEOUS_TEXTURE_AND_DEPTH_WRITE = 33454;
    public static final int GL_SIMULTANEOUS_TEXTURE_AND_STENCIL_WRITE = 33455;
    public static final int GL_TEXTURE_COMPRESSED_BLOCK_WIDTH = 33457;
    public static final int GL_TEXTURE_COMPRESSED_BLOCK_HEIGHT = 33458;
    public static final int GL_TEXTURE_COMPRESSED_BLOCK_SIZE = 33459;
    public static final int GL_CLEAR_BUFFER = 33460;
    public static final int GL_TEXTURE_VIEW = 33461;
    public static final int GL_VIEW_COMPATIBILITY_CLASS = 33462;
    public static final int GL_FULL_SUPPORT = 33463;
    public static final int GL_CAVEAT_SUPPORT = 33464;
    public static final int GL_IMAGE_CLASS_4_X_32 = 33465;
    public static final int GL_IMAGE_CLASS_2_X_32 = 33466;
    public static final int GL_IMAGE_CLASS_1_X_32 = 33467;
    public static final int GL_IMAGE_CLASS_4_X_16 = 33468;
    public static final int GL_IMAGE_CLASS_2_X_16 = 33469;
    public static final int GL_IMAGE_CLASS_1_X_16 = 33470;
    public static final int GL_IMAGE_CLASS_4_X_8 = 33471;
    public static final int GL_IMAGE_CLASS_2_X_8 = 33472;
    public static final int GL_IMAGE_CLASS_1_X_8 = 33473;
    public static final int GL_IMAGE_CLASS_11_11_10 = 33474;
    public static final int GL_IMAGE_CLASS_10_10_10_2 = 33475;
    public static final int GL_VIEW_CLASS_128_BITS = 33476;
    public static final int GL_VIEW_CLASS_96_BITS = 33477;
    public static final int GL_VIEW_CLASS_64_BITS = 33478;
    public static final int GL_VIEW_CLASS_48_BITS = 33479;
    public static final int GL_VIEW_CLASS_32_BITS = 33480;
    public static final int GL_VIEW_CLASS_24_BITS = 33481;
    public static final int GL_VIEW_CLASS_16_BITS = 33482;
    public static final int GL_VIEW_CLASS_8_BITS = 33483;
    public static final int GL_VIEW_CLASS_S3TC_DXT1_RGB = 33484;
    public static final int GL_VIEW_CLASS_S3TC_DXT1_RGBA = 33485;
    public static final int GL_VIEW_CLASS_S3TC_DXT3_RGBA = 33486;
    public static final int GL_VIEW_CLASS_S3TC_DXT5_RGBA = 33487;
    public static final int GL_VIEW_CLASS_RGTC1_RED = 33488;
    public static final int GL_VIEW_CLASS_RGTC2_RG = 33489;
    public static final int GL_VIEW_CLASS_BPTC_UNORM = 33490;
    public static final int GL_VIEW_CLASS_BPTC_FLOAT = 33491;
    public static final int GL_UNIFORM = 37601;
    public static final int GL_UNIFORM_BLOCK = 37602;
    public static final int GL_PROGRAM_INPUT = 37603;
    public static final int GL_PROGRAM_OUTPUT = 37604;
    public static final int GL_BUFFER_VARIABLE = 37605;
    public static final int GL_SHADER_STORAGE_BLOCK = 37606;
    public static final int GL_VERTEX_SUBROUTINE = 37608;
    public static final int GL_TESS_CONTROL_SUBROUTINE = 37609;
    public static final int GL_TESS_EVALUATION_SUBROUTINE = 37610;
    public static final int GL_GEOMETRY_SUBROUTINE = 37611;
    public static final int GL_FRAGMENT_SUBROUTINE = 37612;
    public static final int GL_COMPUTE_SUBROUTINE = 37613;
    public static final int GL_VERTEX_SUBROUTINE_UNIFORM = 37614;
    public static final int GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 37615;
    public static final int GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 37616;
    public static final int GL_GEOMETRY_SUBROUTINE_UNIFORM = 37617;
    public static final int GL_FRAGMENT_SUBROUTINE_UNIFORM = 37618;
    public static final int GL_COMPUTE_SUBROUTINE_UNIFORM = 37619;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING = 37620;
    public static final int GL_ACTIVE_RESOURCES = 37621;
    public static final int GL_MAX_NAME_LENGTH = 37622;
    public static final int GL_MAX_NUM_ACTIVE_VARIABLES = 37623;
    public static final int GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 37624;
    public static final int GL_NAME_LENGTH = 37625;
    public static final int GL_TYPE = 37626;
    public static final int GL_ARRAY_SIZE = 37627;
    public static final int GL_OFFSET = 37628;
    public static final int GL_BLOCK_INDEX = 37629;
    public static final int GL_ARRAY_STRIDE = 37630;
    public static final int GL_MATRIX_STRIDE = 37631;
    public static final int GL_IS_ROW_MAJOR = 37632;
    public static final int GL_ATOMIC_COUNTER_BUFFER_INDEX = 37633;
    public static final int GL_BUFFER_BINDING = 37634;
    public static final int GL_BUFFER_DATA_SIZE = 37635;
    public static final int GL_NUM_ACTIVE_VARIABLES = 37636;
    public static final int GL_ACTIVE_VARIABLES = 37637;
    public static final int GL_REFERENCED_BY_VERTEX_SHADER = 37638;
    public static final int GL_REFERENCED_BY_TESS_CONTROL_SHADER = 37639;
    public static final int GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 37640;
    public static final int GL_REFERENCED_BY_GEOMETRY_SHADER = 37641;
    public static final int GL_REFERENCED_BY_FRAGMENT_SHADER = 37642;
    public static final int GL_REFERENCED_BY_COMPUTE_SHADER = 37643;
    public static final int GL_TOP_LEVEL_ARRAY_SIZE = 37644;
    public static final int GL_TOP_LEVEL_ARRAY_STRIDE = 37645;
    public static final int GL_LOCATION = 37646;
    public static final int GL_LOCATION_INDEX = 37647;
    public static final int GL_IS_PER_PATCH = 37607;
    public static final int GL_SHADER_STORAGE_BUFFER = 37074;
    public static final int GL_SHADER_STORAGE_BUFFER_BINDING = 37075;
    public static final int GL_SHADER_STORAGE_BUFFER_START = 37076;
    public static final int GL_SHADER_STORAGE_BUFFER_SIZE = 37077;
    public static final int GL_MAX_VERTEX_SHADER_STORAGE_BLOCKS = 37078;
    public static final int GL_MAX_GEOMETRY_SHADER_STORAGE_BLOCKS = 37079;
    public static final int GL_MAX_TESS_CONTROL_SHADER_STORAGE_BLOCKS = 37080;
    public static final int GL_MAX_TESS_EVALUATION_SHADER_STORAGE_BLOCKS = 37081;
    public static final int GL_MAX_FRAGMENT_SHADER_STORAGE_BLOCKS = 37082;
    public static final int GL_MAX_COMPUTE_SHADER_STORAGE_BLOCKS = 37083;
    public static final int GL_MAX_COMBINED_SHADER_STORAGE_BLOCKS = 37084;
    public static final int GL_MAX_SHADER_STORAGE_BUFFER_BINDINGS = 37085;
    public static final int GL_MAX_SHADER_STORAGE_BLOCK_SIZE = 37086;
    public static final int GL_SHADER_STORAGE_BUFFER_OFFSET_ALIGNMENT = 37087;
    public static final int GL_SHADER_STORAGE_BARRIER_BIT = 8192;
    public static final int GL_MAX_COMBINED_SHADER_OUTPUT_RESOURCES = 36665;
    public static final int GL_DEPTH_STENCIL_TEXTURE_MODE = 37098;
    public static final int GL_TEXTURE_BUFFER_OFFSET = 37277;
    public static final int GL_TEXTURE_BUFFER_SIZE = 37278;
    public static final int GL_TEXTURE_BUFFER_OFFSET_ALIGNMENT = 37279;
    public static final int GL_TEXTURE_VIEW_MIN_LEVEL = 33499;
    public static final int GL_TEXTURE_VIEW_NUM_LEVELS = 33500;
    public static final int GL_TEXTURE_VIEW_MIN_LAYER = 33501;
    public static final int GL_TEXTURE_VIEW_NUM_LAYERS = 33502;
    public static final int GL_VERTEX_ATTRIB_BINDING = 33492;
    public static final int GL_VERTEX_ATTRIB_RELATIVE_OFFSET = 33493;
    public static final int GL_VERTEX_BINDING_DIVISOR = 33494;
    public static final int GL_VERTEX_BINDING_OFFSET = 33495;
    public static final int GL_VERTEX_BINDING_STRIDE = 33496;
    public static final int GL_VERTEX_BINDING_BUFFER = 36687;
    public static final int GL_MAX_VERTEX_ATTRIB_RELATIVE_OFFSET = 33497;
    public static final int GL_MAX_VERTEX_ATTRIB_BINDINGS = 33498;
    public final long ClearBufferData;
    public final long ClearBufferSubData;
    public final long DispatchCompute;
    public final long DispatchComputeIndirect;
    public final long CopyImageSubData;
    public final long DebugMessageControl;
    public final long DebugMessageInsert;
    public final long DebugMessageCallback;
    public final long GetDebugMessageLog;
    public final long PushDebugGroup;
    public final long PopDebugGroup;
    public final long ObjectLabel;
    public final long GetObjectLabel;
    public final long ObjectPtrLabel;
    public final long GetObjectPtrLabel;
    public final long FramebufferParameteri;
    public final long GetFramebufferParameteriv;
    public final long GetInternalformati64v;
    public final long InvalidateTexSubImage;
    public final long InvalidateTexImage;
    public final long InvalidateBufferSubData;
    public final long InvalidateBufferData;
    public final long InvalidateFramebuffer;
    public final long InvalidateSubFramebuffer;
    public final long MultiDrawArraysIndirect;
    public final long MultiDrawElementsIndirect;
    public final long GetProgramInterfaceiv;
    public final long GetProgramResourceIndex;
    public final long GetProgramResourceName;
    public final long GetProgramResourceiv;
    public final long GetProgramResourceLocation;
    public final long GetProgramResourceLocationIndex;
    public final long ShaderStorageBlockBinding;
    public final long TexBufferRange;
    public final long TexStorage2DMultisample;
    public final long TexStorage3DMultisample;
    public final long TextureView;
    public final long BindVertexBuffer;
    public final long VertexAttribFormat;
    public final long VertexAttribIFormat;
    public final long VertexAttribLFormat;
    public final long VertexAttribBinding;
    public final long VertexBindingDivisor;

    protected GL43() {
        throw new UnsupportedOperationException();
    }

    public GL43(FunctionProvider provider) {
        this.ClearBufferData = provider.getFunctionAddress("glClearBufferData");
        this.ClearBufferSubData = provider.getFunctionAddress("glClearBufferSubData");
        this.DispatchCompute = provider.getFunctionAddress("glDispatchCompute");
        this.DispatchComputeIndirect = provider.getFunctionAddress("glDispatchComputeIndirect");
        this.CopyImageSubData = provider.getFunctionAddress("glCopyImageSubData");
        this.DebugMessageControl = provider.getFunctionAddress("glDebugMessageControl");
        this.DebugMessageInsert = provider.getFunctionAddress("glDebugMessageInsert");
        this.DebugMessageCallback = provider.getFunctionAddress("glDebugMessageCallback");
        this.GetDebugMessageLog = provider.getFunctionAddress("glGetDebugMessageLog");
        this.PushDebugGroup = provider.getFunctionAddress("glPushDebugGroup");
        this.PopDebugGroup = provider.getFunctionAddress("glPopDebugGroup");
        this.ObjectLabel = provider.getFunctionAddress("glObjectLabel");
        this.GetObjectLabel = provider.getFunctionAddress("glGetObjectLabel");
        this.ObjectPtrLabel = provider.getFunctionAddress("glObjectPtrLabel");
        this.GetObjectPtrLabel = provider.getFunctionAddress("glGetObjectPtrLabel");
        this.FramebufferParameteri = provider.getFunctionAddress("glFramebufferParameteri");
        this.GetFramebufferParameteriv = provider.getFunctionAddress("glGetFramebufferParameteriv");
        this.GetInternalformati64v = provider.getFunctionAddress("glGetInternalformati64v");
        this.InvalidateTexSubImage = provider.getFunctionAddress("glInvalidateTexSubImage");
        this.InvalidateTexImage = provider.getFunctionAddress("glInvalidateTexImage");
        this.InvalidateBufferSubData = provider.getFunctionAddress("glInvalidateBufferSubData");
        this.InvalidateBufferData = provider.getFunctionAddress("glInvalidateBufferData");
        this.InvalidateFramebuffer = provider.getFunctionAddress("glInvalidateFramebuffer");
        this.InvalidateSubFramebuffer = provider.getFunctionAddress("glInvalidateSubFramebuffer");
        this.MultiDrawArraysIndirect = provider.getFunctionAddress("glMultiDrawArraysIndirect");
        this.MultiDrawElementsIndirect = provider.getFunctionAddress("glMultiDrawElementsIndirect");
        this.GetProgramInterfaceiv = provider.getFunctionAddress("glGetProgramInterfaceiv");
        this.GetProgramResourceIndex = provider.getFunctionAddress("glGetProgramResourceIndex");
        this.GetProgramResourceName = provider.getFunctionAddress("glGetProgramResourceName");
        this.GetProgramResourceiv = provider.getFunctionAddress("glGetProgramResourceiv");
        this.GetProgramResourceLocation = provider.getFunctionAddress("glGetProgramResourceLocation");
        this.GetProgramResourceLocationIndex = provider.getFunctionAddress("glGetProgramResourceLocationIndex");
        this.ShaderStorageBlockBinding = provider.getFunctionAddress("glShaderStorageBlockBinding");
        this.TexBufferRange = provider.getFunctionAddress("glTexBufferRange");
        this.TexStorage2DMultisample = provider.getFunctionAddress("glTexStorage2DMultisample");
        this.TexStorage3DMultisample = provider.getFunctionAddress("glTexStorage3DMultisample");
        this.TextureView = provider.getFunctionAddress("glTextureView");
        this.BindVertexBuffer = provider.getFunctionAddress("glBindVertexBuffer");
        this.VertexAttribFormat = provider.getFunctionAddress("glVertexAttribFormat");
        this.VertexAttribIFormat = provider.getFunctionAddress("glVertexAttribIFormat");
        this.VertexAttribLFormat = provider.getFunctionAddress("glVertexAttribLFormat");
        this.VertexAttribBinding = provider.getFunctionAddress("glVertexAttribBinding");
        this.VertexBindingDivisor = provider.getFunctionAddress("glVertexBindingDivisor");
    }

    public static GL43 getInstance() {
        return GL43.getInstance(GL.getCapabilities());
    }

    public static GL43 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL43);
    }

    static GL43 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL43")) {
            return null;
        }
        GL43 funcs = new GL43(provider);
        boolean supported = Checks.checkFunctions(funcs.ClearBufferData, funcs.ClearBufferSubData, funcs.DispatchCompute, funcs.DispatchComputeIndirect, funcs.CopyImageSubData, funcs.DebugMessageControl, funcs.DebugMessageInsert, funcs.DebugMessageCallback, funcs.GetDebugMessageLog, funcs.PushDebugGroup, funcs.PopDebugGroup, funcs.ObjectLabel, funcs.GetObjectLabel, funcs.ObjectPtrLabel, funcs.GetObjectPtrLabel, funcs.FramebufferParameteri, funcs.GetFramebufferParameteriv, funcs.GetInternalformati64v, funcs.InvalidateTexSubImage, funcs.InvalidateTexImage, funcs.InvalidateBufferSubData, funcs.InvalidateBufferData, funcs.InvalidateFramebuffer, funcs.InvalidateSubFramebuffer, funcs.MultiDrawArraysIndirect, funcs.MultiDrawElementsIndirect, funcs.GetProgramInterfaceiv, funcs.GetProgramResourceIndex, funcs.GetProgramResourceName, funcs.GetProgramResourceiv, funcs.GetProgramResourceLocation, funcs.GetProgramResourceLocationIndex, funcs.ShaderStorageBlockBinding, funcs.TexBufferRange, funcs.TexStorage2DMultisample, funcs.TexStorage3DMultisample, funcs.TextureView, funcs.BindVertexBuffer, funcs.VertexAttribFormat, funcs.VertexAttribIFormat, funcs.VertexAttribLFormat, funcs.VertexAttribBinding, funcs.VertexBindingDivisor);
        return GL.checkExtension("OpenGL43", funcs, supported);
    }

    public static void nglClearBufferData(int target, int internalformat, int format, int type, long data) {
        long __functionAddress = GL43.getInstance().ClearBufferData;
        JNI.callIIIIPV(__functionAddress, target, internalformat, format, type, data);
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ByteBuffer data) {
        GL43.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, ShortBuffer data) {
        GL43.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, IntBuffer data) {
        GL43.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferData(int target, int internalformat, int format, int type, FloatBuffer data) {
        GL43.nglClearBufferData(target, internalformat, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void nglClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, long data) {
        long __functionAddress = GL43.getInstance().ClearBufferSubData;
        JNI.callIIPPIIPV(__functionAddress, target, internalformat, offset, size, format, type, data);
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ByteBuffer data) {
        GL43.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, ShortBuffer data) {
        GL43.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, IntBuffer data) {
        GL43.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glClearBufferSubData(int target, int internalformat, long offset, long size, int format, int type, FloatBuffer data) {
        GL43.nglClearBufferSubData(target, internalformat, offset, size, format, type, MemoryUtil.memAddressSafe(data));
    }

    public static void glDispatchCompute(int num_groups_x, int num_groups_y, int num_groups_z) {
        long __functionAddress = GL43.getInstance().DispatchCompute;
        JNI.callIIIV(__functionAddress, num_groups_x, num_groups_y, num_groups_z);
    }

    public static void glDispatchComputeIndirect(long indirect) {
        long __functionAddress = GL43.getInstance().DispatchComputeIndirect;
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(37103, true);
        }
        JNI.callPV(__functionAddress, indirect);
    }

    public static void glCopyImageSubData(int srcName, int srcTarget, int srcLevel, int srcX, int srcY, int srcZ, int dstName, int dstTarget, int dstLevel, int dstX, int dstY, int dstZ, int srcWidth, int srcHeight, int srcDepth) {
        long __functionAddress = GL43.getInstance().CopyImageSubData;
        JNI.callIIIIIIIIIIIIIIIV(__functionAddress, srcName, srcTarget, srcLevel, srcX, srcY, srcZ, dstName, dstTarget, dstLevel, dstX, dstY, dstZ, srcWidth, srcHeight, srcDepth);
    }

    public static void nglDebugMessageControl(int source, int type, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = GL43.getInstance().DebugMessageControl;
        JNI.callIIIIPZV(__functionAddress, source, type, severity, count, ids, enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (Checks.CHECKS && ids != null) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        GL43.nglDebugMessageControl(source, type, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, IntBuffer ids, boolean enabled) {
        GL43.nglDebugMessageControl(source, type, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageControl(int source, int type, int severity, int id, boolean enabled) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GL43.nglDebugMessageControl(source, type, severity, 1, __buffer.address(ids), enabled);
    }

    public static void nglDebugMessageInsert(int source, int type, int id, int severity, int length, long message) {
        long __functionAddress = GL43.getInstance().DebugMessageInsert;
        JNI.callIIIIIPV(__functionAddress, source, type, id, severity, length, message);
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        GL43.nglDebugMessageInsert(source, type, id, severity, length, MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, ByteBuffer message) {
        GL43.nglDebugMessageInsert(source, type, id, severity, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glDebugMessageInsert(int source, int type, int id, int severity, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        GL43.nglDebugMessageInsert(source, type, id, severity, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glDebugMessageCallback(GLDebugMessageCallback callback, long userParam) {
        long __functionAddress = GL43.getInstance().DebugMessageCallback;
        JNI.callPPV(__functionAddress, callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLog(int count, int bufsize, long sources, long types, long ids, long severities, long lengths, long messageLog) {
        long __functionAddress = GL43.getInstance().GetDebugMessageLog;
        return JNI.callIIPPPPPPI(__functionAddress, count, bufsize, sources, types, ids, severities, lengths, messageLog);
    }

    public static int glGetDebugMessageLog(int count, int bufsize, ByteBuffer sources, ByteBuffer types, ByteBuffer ids, ByteBuffer severities, ByteBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count << 2);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return GL43.nglGetDebugMessageLog(count, bufsize, MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLog(int count, IntBuffer sources, IntBuffer types, IntBuffer ids, IntBuffer severities, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (sources != null) {
                Checks.checkBuffer((Buffer)sources, count);
            }
            if (types != null) {
                Checks.checkBuffer((Buffer)types, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return GL43.nglGetDebugMessageLog(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(sources), MemoryUtil.memAddressSafe(types), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static void nglPushDebugGroup(int source, int id, int length, long message) {
        long __functionAddress = GL43.getInstance().PushDebugGroup;
        JNI.callIIIPV(__functionAddress, source, id, length, message);
    }

    public static void glPushDebugGroup(int source, int id, int length, ByteBuffer message) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)message, length);
        }
        GL43.nglPushDebugGroup(source, id, length, MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, ByteBuffer message) {
        GL43.nglPushDebugGroup(source, id, message.remaining(), MemoryUtil.memAddress(message));
    }

    public static void glPushDebugGroup(int source, int id, CharSequence message) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int messageEncoded = __buffer.stringParamUTF8(message, false);
        int messageEncodedLen = __buffer.getOffset() - messageEncoded;
        GL43.nglPushDebugGroup(source, id, messageEncodedLen, __buffer.address(messageEncoded));
    }

    public static void glPopDebugGroup() {
        long __functionAddress = GL43.getInstance().PopDebugGroup;
        JNI.callV(__functionAddress);
    }

    public static void nglObjectLabel(int identifier, int name, int length, long label) {
        long __functionAddress = GL43.getInstance().ObjectLabel;
        JNI.callIIIPV(__functionAddress, identifier, name, length, label);
    }

    public static void glObjectLabel(int identifier, int name, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        GL43.nglObjectLabel(identifier, name, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, ByteBuffer label) {
        GL43.nglObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectLabel(int identifier, int name, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        GL43.nglObjectLabel(identifier, name, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectLabel(int identifier, int name, int bufSize, long length, long label) {
        long __functionAddress = GL43.getInstance().GetObjectLabel;
        JNI.callIIIPPV(__functionAddress, identifier, name, bufSize, length, label);
    }

    public static void glGetObjectLabel(int identifier, int name, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL43.nglGetObjectLabel(identifier, name, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectLabel(int identifier, int name, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL43.nglGetObjectLabel(identifier, name, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectLabel(int identifier, int name, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GL43.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectLabel(int identifier, int name) {
        int bufSize = GL11.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GL43.nglGetObjectLabel(identifier, name, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static void nglObjectPtrLabel(long ptr, int length, long label) {
        long __functionAddress = GL43.getInstance().ObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPV(__functionAddress, ptr, length, label);
    }

    public static void glObjectPtrLabel(long ptr, int length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, length);
        }
        GL43.nglObjectPtrLabel(ptr, length, MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, ByteBuffer label) {
        GL43.nglObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddress(label));
    }

    public static void glObjectPtrLabel(long ptr, CharSequence label) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int labelEncoded = __buffer.stringParamUTF8(label, false);
        int labelEncodedLen = __buffer.getOffset() - labelEncoded;
        GL43.nglObjectPtrLabel(ptr, labelEncodedLen, __buffer.address(labelEncoded));
    }

    public static void nglGetObjectPtrLabel(long ptr, int bufSize, long length, long label) {
        long __functionAddress = GL43.getInstance().GetObjectPtrLabel;
        if (Checks.CHECKS) {
            Checks.checkPointer(ptr);
        }
        JNI.callPIPPV(__functionAddress, ptr, bufSize, length, label);
    }

    public static void glGetObjectPtrLabel(long ptr, int bufSize, ByteBuffer length, ByteBuffer label) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)label, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL43.nglGetObjectPtrLabel(ptr, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static void glGetObjectPtrLabel(long ptr, IntBuffer length, ByteBuffer label) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL43.nglGetObjectPtrLabel(ptr, label.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(label));
    }

    public static String glGetObjectPtrLabel(long ptr, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GL43.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static String glGetObjectPtrLabel(long ptr) {
        int bufSize = GL11.glGetInteger(33512);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int label = __buffer.bufferParam(bufSize);
        GL43.nglGetObjectPtrLabel(ptr, bufSize, __buffer.address(length), __buffer.address(label));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), label);
    }

    public static void glFramebufferParameteri(int target, int pname, int param) {
        long __functionAddress = GL43.getInstance().FramebufferParameteri;
        JNI.callIIIV(__functionAddress, target, pname, param);
    }

    public static void nglGetFramebufferParameteriv(int target, int pname, long params) {
        long __functionAddress = GL43.getInstance().GetFramebufferParameteriv;
        JNI.callIIPV(__functionAddress, target, pname, params);
    }

    public static void glGetFramebufferParameteriv(int target, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL43.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetFramebufferParameteriv(int target, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL43.nglGetFramebufferParameteriv(target, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetFramebufferParameteri(int target, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL43.nglGetFramebufferParameteriv(target, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetInternalformati64v(int target, int internalformat, int pname, int bufSize, long params) {
        long __functionAddress = GL43.getInstance().GetInternalformati64v;
        JNI.callIIIIPV(__functionAddress, target, internalformat, pname, bufSize, params);
    }

    public static void glGetInternalformati64v(int target, int internalformat, int pname, int bufSize, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, bufSize << 3);
        }
        GL43.nglGetInternalformati64v(target, internalformat, pname, bufSize, MemoryUtil.memAddress(params));
    }

    public static void glGetInternalformati64v(int target, int internalformat, int pname, LongBuffer params) {
        GL43.nglGetInternalformati64v(target, internalformat, pname, params.remaining(), MemoryUtil.memAddress(params));
    }

    public static long glGetInternalformati64(int target, int internalformat, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.longParam();
        GL43.nglGetInternalformati64v(target, internalformat, pname, 1, __buffer.address(params));
        return __buffer.longValue(params);
    }

    public static void glInvalidateTexSubImage(int texture, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth) {
        long __functionAddress = GL43.getInstance().InvalidateTexSubImage;
        JNI.callIIIIIIIIV(__functionAddress, texture, level, xoffset, yoffset, zoffset, width, height, depth);
    }

    public static void glInvalidateTexImage(int texture, int level) {
        long __functionAddress = GL43.getInstance().InvalidateTexImage;
        JNI.callIIV(__functionAddress, texture, level);
    }

    public static void glInvalidateBufferSubData(int buffer, long offset, long length) {
        long __functionAddress = GL43.getInstance().InvalidateBufferSubData;
        JNI.callIPPV(__functionAddress, buffer, offset, length);
    }

    public static void glInvalidateBufferData(int buffer) {
        long __functionAddress = GL43.getInstance().InvalidateBufferData;
        JNI.callIV(__functionAddress, buffer);
    }

    public static void nglInvalidateFramebuffer(int target, int numAttachments, long attachments) {
        long __functionAddress = GL43.getInstance().InvalidateFramebuffer;
        JNI.callIIPV(__functionAddress, target, numAttachments, attachments);
    }

    public static void glInvalidateFramebuffer(int target, int numAttachments, ByteBuffer attachments) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL43.nglInvalidateFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, IntBuffer attachments) {
        GL43.nglInvalidateFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments));
    }

    public static void glInvalidateFramebuffer(int target, int attachment) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL43.nglInvalidateFramebuffer(target, 1, __buffer.address(attachments));
    }

    public static void nglInvalidateSubFramebuffer(int target, int numAttachments, long attachments, int x, int y, int width, int height) {
        long __functionAddress = GL43.getInstance().InvalidateSubFramebuffer;
        JNI.callIIPIIIIV(__functionAddress, target, numAttachments, attachments, x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int numAttachments, ByteBuffer attachments, int x, int y, int width, int height) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)attachments, numAttachments << 2);
        }
        GL43.nglInvalidateSubFramebuffer(target, numAttachments, MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, IntBuffer attachments, int x, int y, int width, int height) {
        GL43.nglInvalidateSubFramebuffer(target, attachments.remaining(), MemoryUtil.memAddress(attachments), x, y, width, height);
    }

    public static void glInvalidateSubFramebuffer(int target, int attachment, int x, int y, int width, int height) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int attachments = __buffer.intParam(attachment);
        GL43.nglInvalidateSubFramebuffer(target, 1, __buffer.address(attachments), x, y, width, height);
    }

    public static void nglMultiDrawArraysIndirect(int mode, long indirect, int primcount, int stride) {
        long __functionAddress = GL43.getInstance().MultiDrawArraysIndirect;
        JNI.callIPIIV(__functionAddress, mode, indirect, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        GL43.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, long indirectOffset, int primcount, int stride) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL43.nglMultiDrawArraysIndirect(mode, indirectOffset, primcount, stride);
    }

    public static void glMultiDrawArraysIndirect(int mode, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 16 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL43.nglMultiDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void nglMultiDrawElementsIndirect(int mode, int type, long indirect, int primcount, int stride) {
        long __functionAddress = GL43.getInstance().MultiDrawElementsIndirect;
        JNI.callIIPIIV(__functionAddress, mode, type, indirect, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, ByteBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride));
            GLChecks.ensureBufferObject(36675, false);
        }
        GL43.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, long indirectOffset, int primcount, int stride) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL43.nglMultiDrawElementsIndirect(mode, type, indirectOffset, primcount, stride);
    }

    public static void glMultiDrawElementsIndirect(int mode, int type, IntBuffer indirect, int primcount, int stride) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, primcount * (stride == 0 ? 20 : stride) >> 2);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL43.nglMultiDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect), primcount, stride);
    }

    public static void nglGetProgramInterfaceiv(int program, int programInterface, int pname, long params) {
        long __functionAddress = GL43.getInstance().GetProgramInterfaceiv;
        JNI.callIIIPV(__functionAddress, program, programInterface, pname, params);
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL43.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL43.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramInterfacei(int program, int programInterface, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL43.nglGetProgramInterfaceiv(program, programInterface, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int nglGetProgramResourceIndex(int program, int programInterface, long name) {
        long __functionAddress = GL43.getInstance().GetProgramResourceIndex;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL43.nglGetProgramResourceIndex(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return GL43.nglGetProgramResourceIndex(program, programInterface, __buffer.address(nameEncoded));
    }

    public static void nglGetProgramResourceName(int program, int programInterface, int index, int bufSize, long length, long name) {
        long __functionAddress = GL43.getInstance().GetProgramResourceName;
        JNI.callIIIIPPV(__functionAddress, program, programInterface, index, bufSize, length, name);
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, int bufSize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL43.nglGetProgramResourceName(program, programInterface, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL43.nglGetProgramResourceName(program, programInterface, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GL43.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index) {
        int bufSize = GL43.glGetProgramInterfacei(program, programInterface, 37622);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        GL43.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetProgramResourceiv(int program, int programInterface, int index, int propCount, long props, int bufSize, long length, long params) {
        long __functionAddress = GL43.getInstance().GetProgramResourceiv;
        JNI.callIIIIPIPPV(__functionAddress, program, programInterface, index, propCount, props, bufSize, length, params);
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, ByteBuffer props, int bufSize, ByteBuffer length, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)props, propCount << 2);
            Checks.checkBuffer((Buffer)params, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL43.nglGetProgramResourceiv(program, programInterface, index, propCount, MemoryUtil.memAddress(props), bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, IntBuffer length, IntBuffer params) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL43.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), params.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static IntBuffer glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        IntBuffer params = BufferUtils.createIntBuffer(bufSize);
        GL43.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), bufSize, __buffer.address(length), MemoryUtil.memAddress(params));
        params.limit(__buffer.intValue(length));
        return params.slice();
    }

    public static int nglGetProgramResourceLocation(int program, int programInterface, long name) {
        long __functionAddress = GL43.getInstance().GetProgramResourceLocation;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL43.nglGetProgramResourceLocation(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL43.nglGetProgramResourceLocation(program, programInterface, __buffer.address(nameEncoded));
    }

    public static int nglGetProgramResourceLocationIndex(int program, int programInterface, long name) {
        long __functionAddress = GL43.getInstance().GetProgramResourceLocationIndex;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocationIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL43.nglGetProgramResourceLocationIndex(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocationIndex(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL43.nglGetProgramResourceLocationIndex(program, programInterface, __buffer.address(nameEncoded));
    }

    public static void glShaderStorageBlockBinding(int program, int storageBlockIndex, int storageBlockBinding) {
        long __functionAddress = GL43.getInstance().ShaderStorageBlockBinding;
        JNI.callIIIV(__functionAddress, program, storageBlockIndex, storageBlockBinding);
    }

    public static void glTexBufferRange(int target, int internalformat, int buffer, long offset, long size) {
        long __functionAddress = GL43.getInstance().TexBufferRange;
        JNI.callIIIPPV(__functionAddress, target, internalformat, buffer, offset, size);
    }

    public static void glTexStorage2DMultisample(int target, int samples, int internalformat, int width, int height, boolean fixedsamplelocations) {
        long __functionAddress = GL43.getInstance().TexStorage2DMultisample;
        JNI.callIIIIIZV(__functionAddress, target, samples, internalformat, width, height, fixedsamplelocations);
    }

    public static void glTexStorage3DMultisample(int target, int samples, int internalformat, int width, int height, int depth, boolean fixedsamplelocations) {
        long __functionAddress = GL43.getInstance().TexStorage3DMultisample;
        JNI.callIIIIIIZV(__functionAddress, target, samples, internalformat, width, height, depth, fixedsamplelocations);
    }

    public static void glTextureView(int texture, int target, int origtexture, int internalformat, int minlevel, int numlevels, int minlayer, int numlayers) {
        long __functionAddress = GL43.getInstance().TextureView;
        JNI.callIIIIIIIIV(__functionAddress, texture, target, origtexture, internalformat, minlevel, numlevels, minlayer, numlayers);
    }

    public static void glBindVertexBuffer(int bindingindex, int buffer, long offset, int stride) {
        long __functionAddress = GL43.getInstance().BindVertexBuffer;
        JNI.callIIPIV(__functionAddress, bindingindex, buffer, offset, stride);
    }

    public static void glVertexAttribFormat(int attribindex, int size, int type, boolean normalized, int relativeoffset) {
        long __functionAddress = GL43.getInstance().VertexAttribFormat;
        JNI.callIIIZIV(__functionAddress, attribindex, size, type, normalized, relativeoffset);
    }

    public static void glVertexAttribIFormat(int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL43.getInstance().VertexAttribIFormat;
        JNI.callIIIIV(__functionAddress, attribindex, size, type, relativeoffset);
    }

    public static void glVertexAttribLFormat(int attribindex, int size, int type, int relativeoffset) {
        long __functionAddress = GL43.getInstance().VertexAttribLFormat;
        JNI.callIIIIV(__functionAddress, attribindex, size, type, relativeoffset);
    }

    public static void glVertexAttribBinding(int attribindex, int bindingindex) {
        long __functionAddress = GL43.getInstance().VertexAttribBinding;
        JNI.callIIV(__functionAddress, attribindex, bindingindex);
    }

    public static void glVertexBindingDivisor(int bindingindex, int divisor) {
        long __functionAddress = GL43.getInstance().VertexBindingDivisor;
        JNI.callIIV(__functionAddress, bindingindex, divisor);
    }
}

