/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class GL41 {
    public static final int GL_SHADER_COMPILER = 36346;
    public static final int GL_SHADER_BINARY_FORMATS = 36344;
    public static final int GL_NUM_SHADER_BINARY_FORMATS = 36345;
    public static final int GL_MAX_VERTEX_UNIFORM_VECTORS = 36347;
    public static final int GL_MAX_VARYING_VECTORS = 36348;
    public static final int GL_MAX_FRAGMENT_UNIFORM_VECTORS = 36349;
    public static final int GL_IMPLEMENTATION_COLOR_READ_TYPE = 35738;
    public static final int GL_IMPLEMENTATION_COLOR_READ_FORMAT = 35739;
    public static final int GL_FIXED = 5132;
    public static final int GL_LOW_FLOAT = 36336;
    public static final int GL_MEDIUM_FLOAT = 36337;
    public static final int GL_HIGH_FLOAT = 36338;
    public static final int GL_LOW_INT = 36339;
    public static final int GL_MEDIUM_INT = 36340;
    public static final int GL_HIGH_INT = 36341;
    public static final int GL_RGB565 = 36194;
    public static final int GL_PROGRAM_BINARY_RETRIEVABLE_HINT = 33367;
    public static final int GL_PROGRAM_BINARY_LENGTH = 34625;
    public static final int GL_NUM_PROGRAM_BINARY_FORMATS = 34814;
    public static final int GL_PROGRAM_BINARY_FORMATS = 34815;
    public static final int GL_VERTEX_SHADER_BIT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT = 2;
    public static final int GL_GEOMETRY_SHADER_BIT = 4;
    public static final int GL_TESS_CONTROL_SHADER_BIT = 8;
    public static final int GL_TESS_EVALUATION_SHADER_BIT = 16;
    public static final int GL_ALL_SHADER_BITS = -1;
    public static final int GL_PROGRAM_SEPARABLE = 33368;
    public static final int GL_ACTIVE_PROGRAM = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING = 33370;
    public static final int GL_MAX_VIEWPORTS = 33371;
    public static final int GL_VIEWPORT_SUBPIXEL_BITS = 33372;
    public static final int GL_VIEWPORT_BOUNDS_RANGE = 33373;
    public static final int GL_LAYER_PROVOKING_VERTEX = 33374;
    public static final int GL_VIEWPORT_INDEX_PROVOKING_VERTEX = 33375;
    public static final int GL_UNDEFINED_VERTEX = 33376;
    public final long ReleaseShaderCompiler;
    public final long ShaderBinary;
    public final long GetShaderPrecisionFormat;
    public final long DepthRangef;
    public final long ClearDepthf;
    public final long GetProgramBinary;
    public final long ProgramBinary;
    public final long ProgramParameteri;
    public final long UseProgramStages;
    public final long ActiveShaderProgram;
    public final long CreateShaderProgramv;
    public final long BindProgramPipeline;
    public final long DeleteProgramPipelines;
    public final long GenProgramPipelines;
    public final long IsProgramPipeline;
    public final long GetProgramPipelineiv;
    public final long ProgramUniform1i;
    public final long ProgramUniform2i;
    public final long ProgramUniform3i;
    public final long ProgramUniform4i;
    public final long ProgramUniform1ui;
    public final long ProgramUniform2ui;
    public final long ProgramUniform3ui;
    public final long ProgramUniform4ui;
    public final long ProgramUniform1f;
    public final long ProgramUniform2f;
    public final long ProgramUniform3f;
    public final long ProgramUniform4f;
    public final long ProgramUniform1d;
    public final long ProgramUniform2d;
    public final long ProgramUniform3d;
    public final long ProgramUniform4d;
    public final long ProgramUniform1iv;
    public final long ProgramUniform2iv;
    public final long ProgramUniform3iv;
    public final long ProgramUniform4iv;
    public final long ProgramUniform1uiv;
    public final long ProgramUniform2uiv;
    public final long ProgramUniform3uiv;
    public final long ProgramUniform4uiv;
    public final long ProgramUniform1fv;
    public final long ProgramUniform2fv;
    public final long ProgramUniform3fv;
    public final long ProgramUniform4fv;
    public final long ProgramUniform1dv;
    public final long ProgramUniform2dv;
    public final long ProgramUniform3dv;
    public final long ProgramUniform4dv;
    public final long ProgramUniformMatrix2fv;
    public final long ProgramUniformMatrix3fv;
    public final long ProgramUniformMatrix4fv;
    public final long ProgramUniformMatrix2dv;
    public final long ProgramUniformMatrix3dv;
    public final long ProgramUniformMatrix4dv;
    public final long ProgramUniformMatrix2x3fv;
    public final long ProgramUniformMatrix3x2fv;
    public final long ProgramUniformMatrix2x4fv;
    public final long ProgramUniformMatrix4x2fv;
    public final long ProgramUniformMatrix3x4fv;
    public final long ProgramUniformMatrix4x3fv;
    public final long ProgramUniformMatrix2x3dv;
    public final long ProgramUniformMatrix3x2dv;
    public final long ProgramUniformMatrix2x4dv;
    public final long ProgramUniformMatrix4x2dv;
    public final long ProgramUniformMatrix3x4dv;
    public final long ProgramUniformMatrix4x3dv;
    public final long ValidateProgramPipeline;
    public final long GetProgramPipelineInfoLog;
    public final long VertexAttribL1d;
    public final long VertexAttribL2d;
    public final long VertexAttribL3d;
    public final long VertexAttribL4d;
    public final long VertexAttribL1dv;
    public final long VertexAttribL2dv;
    public final long VertexAttribL3dv;
    public final long VertexAttribL4dv;
    public final long VertexAttribLPointer;
    public final long GetVertexAttribLdv;
    public final long ViewportArrayv;
    public final long ViewportIndexedf;
    public final long ViewportIndexedfv;
    public final long ScissorArrayv;
    public final long ScissorIndexed;
    public final long ScissorIndexedv;
    public final long DepthRangeArrayv;
    public final long DepthRangeIndexed;
    public final long GetFloati_v;
    public final long GetDoublei_v;

    protected GL41() {
        throw new UnsupportedOperationException();
    }

    public GL41(FunctionProvider provider) {
        this.ReleaseShaderCompiler = provider.getFunctionAddress("glReleaseShaderCompiler");
        this.ShaderBinary = provider.getFunctionAddress("glShaderBinary");
        this.GetShaderPrecisionFormat = provider.getFunctionAddress("glGetShaderPrecisionFormat");
        this.DepthRangef = provider.getFunctionAddress("glDepthRangef");
        this.ClearDepthf = provider.getFunctionAddress("glClearDepthf");
        this.GetProgramBinary = provider.getFunctionAddress("glGetProgramBinary");
        this.ProgramBinary = provider.getFunctionAddress("glProgramBinary");
        this.ProgramParameteri = provider.getFunctionAddress("glProgramParameteri");
        this.UseProgramStages = provider.getFunctionAddress("glUseProgramStages");
        this.ActiveShaderProgram = provider.getFunctionAddress("glActiveShaderProgram");
        this.CreateShaderProgramv = provider.getFunctionAddress("glCreateShaderProgramv");
        this.BindProgramPipeline = provider.getFunctionAddress("glBindProgramPipeline");
        this.DeleteProgramPipelines = provider.getFunctionAddress("glDeleteProgramPipelines");
        this.GenProgramPipelines = provider.getFunctionAddress("glGenProgramPipelines");
        this.IsProgramPipeline = provider.getFunctionAddress("glIsProgramPipeline");
        this.GetProgramPipelineiv = provider.getFunctionAddress("glGetProgramPipelineiv");
        this.ProgramUniform1i = provider.getFunctionAddress("glProgramUniform1i");
        this.ProgramUniform2i = provider.getFunctionAddress("glProgramUniform2i");
        this.ProgramUniform3i = provider.getFunctionAddress("glProgramUniform3i");
        this.ProgramUniform4i = provider.getFunctionAddress("glProgramUniform4i");
        this.ProgramUniform1ui = provider.getFunctionAddress("glProgramUniform1ui");
        this.ProgramUniform2ui = provider.getFunctionAddress("glProgramUniform2ui");
        this.ProgramUniform3ui = provider.getFunctionAddress("glProgramUniform3ui");
        this.ProgramUniform4ui = provider.getFunctionAddress("glProgramUniform4ui");
        this.ProgramUniform1f = provider.getFunctionAddress("glProgramUniform1f");
        this.ProgramUniform2f = provider.getFunctionAddress("glProgramUniform2f");
        this.ProgramUniform3f = provider.getFunctionAddress("glProgramUniform3f");
        this.ProgramUniform4f = provider.getFunctionAddress("glProgramUniform4f");
        this.ProgramUniform1d = provider.getFunctionAddress("glProgramUniform1d");
        this.ProgramUniform2d = provider.getFunctionAddress("glProgramUniform2d");
        this.ProgramUniform3d = provider.getFunctionAddress("glProgramUniform3d");
        this.ProgramUniform4d = provider.getFunctionAddress("glProgramUniform4d");
        this.ProgramUniform1iv = provider.getFunctionAddress("glProgramUniform1iv");
        this.ProgramUniform2iv = provider.getFunctionAddress("glProgramUniform2iv");
        this.ProgramUniform3iv = provider.getFunctionAddress("glProgramUniform3iv");
        this.ProgramUniform4iv = provider.getFunctionAddress("glProgramUniform4iv");
        this.ProgramUniform1uiv = provider.getFunctionAddress("glProgramUniform1uiv");
        this.ProgramUniform2uiv = provider.getFunctionAddress("glProgramUniform2uiv");
        this.ProgramUniform3uiv = provider.getFunctionAddress("glProgramUniform3uiv");
        this.ProgramUniform4uiv = provider.getFunctionAddress("glProgramUniform4uiv");
        this.ProgramUniform1fv = provider.getFunctionAddress("glProgramUniform1fv");
        this.ProgramUniform2fv = provider.getFunctionAddress("glProgramUniform2fv");
        this.ProgramUniform3fv = provider.getFunctionAddress("glProgramUniform3fv");
        this.ProgramUniform4fv = provider.getFunctionAddress("glProgramUniform4fv");
        this.ProgramUniform1dv = provider.getFunctionAddress("glProgramUniform1dv");
        this.ProgramUniform2dv = provider.getFunctionAddress("glProgramUniform2dv");
        this.ProgramUniform3dv = provider.getFunctionAddress("glProgramUniform3dv");
        this.ProgramUniform4dv = provider.getFunctionAddress("glProgramUniform4dv");
        this.ProgramUniformMatrix2fv = provider.getFunctionAddress("glProgramUniformMatrix2fv");
        this.ProgramUniformMatrix3fv = provider.getFunctionAddress("glProgramUniformMatrix3fv");
        this.ProgramUniformMatrix4fv = provider.getFunctionAddress("glProgramUniformMatrix4fv");
        this.ProgramUniformMatrix2dv = provider.getFunctionAddress("glProgramUniformMatrix2dv");
        this.ProgramUniformMatrix3dv = provider.getFunctionAddress("glProgramUniformMatrix3dv");
        this.ProgramUniformMatrix4dv = provider.getFunctionAddress("glProgramUniformMatrix4dv");
        this.ProgramUniformMatrix2x3fv = provider.getFunctionAddress("glProgramUniformMatrix2x3fv");
        this.ProgramUniformMatrix3x2fv = provider.getFunctionAddress("glProgramUniformMatrix3x2fv");
        this.ProgramUniformMatrix2x4fv = provider.getFunctionAddress("glProgramUniformMatrix2x4fv");
        this.ProgramUniformMatrix4x2fv = provider.getFunctionAddress("glProgramUniformMatrix4x2fv");
        this.ProgramUniformMatrix3x4fv = provider.getFunctionAddress("glProgramUniformMatrix3x4fv");
        this.ProgramUniformMatrix4x3fv = provider.getFunctionAddress("glProgramUniformMatrix4x3fv");
        this.ProgramUniformMatrix2x3dv = provider.getFunctionAddress("glProgramUniformMatrix2x3dv");
        this.ProgramUniformMatrix3x2dv = provider.getFunctionAddress("glProgramUniformMatrix3x2dv");
        this.ProgramUniformMatrix2x4dv = provider.getFunctionAddress("glProgramUniformMatrix2x4dv");
        this.ProgramUniformMatrix4x2dv = provider.getFunctionAddress("glProgramUniformMatrix4x2dv");
        this.ProgramUniformMatrix3x4dv = provider.getFunctionAddress("glProgramUniformMatrix3x4dv");
        this.ProgramUniformMatrix4x3dv = provider.getFunctionAddress("glProgramUniformMatrix4x3dv");
        this.ValidateProgramPipeline = provider.getFunctionAddress("glValidateProgramPipeline");
        this.GetProgramPipelineInfoLog = provider.getFunctionAddress("glGetProgramPipelineInfoLog");
        this.VertexAttribL1d = provider.getFunctionAddress("glVertexAttribL1d");
        this.VertexAttribL2d = provider.getFunctionAddress("glVertexAttribL2d");
        this.VertexAttribL3d = provider.getFunctionAddress("glVertexAttribL3d");
        this.VertexAttribL4d = provider.getFunctionAddress("glVertexAttribL4d");
        this.VertexAttribL1dv = provider.getFunctionAddress("glVertexAttribL1dv");
        this.VertexAttribL2dv = provider.getFunctionAddress("glVertexAttribL2dv");
        this.VertexAttribL3dv = provider.getFunctionAddress("glVertexAttribL3dv");
        this.VertexAttribL4dv = provider.getFunctionAddress("glVertexAttribL4dv");
        this.VertexAttribLPointer = provider.getFunctionAddress("glVertexAttribLPointer");
        this.GetVertexAttribLdv = provider.getFunctionAddress("glGetVertexAttribLdv");
        this.ViewportArrayv = provider.getFunctionAddress("glViewportArrayv");
        this.ViewportIndexedf = provider.getFunctionAddress("glViewportIndexedf");
        this.ViewportIndexedfv = provider.getFunctionAddress("glViewportIndexedfv");
        this.ScissorArrayv = provider.getFunctionAddress("glScissorArrayv");
        this.ScissorIndexed = provider.getFunctionAddress("glScissorIndexed");
        this.ScissorIndexedv = provider.getFunctionAddress("glScissorIndexedv");
        this.DepthRangeArrayv = provider.getFunctionAddress("glDepthRangeArrayv");
        this.DepthRangeIndexed = provider.getFunctionAddress("glDepthRangeIndexed");
        this.GetFloati_v = provider.getFunctionAddress("glGetFloati_v");
        this.GetDoublei_v = provider.getFunctionAddress("glGetDoublei_v");
    }

    public static GL41 getInstance() {
        return GL41.getInstance(GL.getCapabilities());
    }

    public static GL41 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL41);
    }

    static GL41 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL41")) {
            return null;
        }
        GL41 funcs = new GL41(provider);
        boolean supported = Checks.checkFunctions(funcs.ReleaseShaderCompiler, funcs.ShaderBinary, funcs.GetShaderPrecisionFormat, funcs.DepthRangef, funcs.ClearDepthf, funcs.GetProgramBinary, funcs.ProgramBinary, funcs.ProgramParameteri, funcs.UseProgramStages, funcs.ActiveShaderProgram, funcs.CreateShaderProgramv, funcs.BindProgramPipeline, funcs.DeleteProgramPipelines, funcs.GenProgramPipelines, funcs.IsProgramPipeline, funcs.GetProgramPipelineiv, funcs.ProgramUniform1i, funcs.ProgramUniform2i, funcs.ProgramUniform3i, funcs.ProgramUniform4i, funcs.ProgramUniform1ui, funcs.ProgramUniform2ui, funcs.ProgramUniform3ui, funcs.ProgramUniform4ui, funcs.ProgramUniform1f, funcs.ProgramUniform2f, funcs.ProgramUniform3f, funcs.ProgramUniform4f, funcs.ProgramUniform1d, funcs.ProgramUniform2d, funcs.ProgramUniform3d, funcs.ProgramUniform4d, funcs.ProgramUniform1iv, funcs.ProgramUniform2iv, funcs.ProgramUniform3iv, funcs.ProgramUniform4iv, funcs.ProgramUniform1uiv, funcs.ProgramUniform2uiv, funcs.ProgramUniform3uiv, funcs.ProgramUniform4uiv, funcs.ProgramUniform1fv, funcs.ProgramUniform2fv, funcs.ProgramUniform3fv, funcs.ProgramUniform4fv, funcs.ProgramUniform1dv, funcs.ProgramUniform2dv, funcs.ProgramUniform3dv, funcs.ProgramUniform4dv, funcs.ProgramUniformMatrix2fv, funcs.ProgramUniformMatrix3fv, funcs.ProgramUniformMatrix4fv, funcs.ProgramUniformMatrix2dv, funcs.ProgramUniformMatrix3dv, funcs.ProgramUniformMatrix4dv, funcs.ProgramUniformMatrix2x3fv, funcs.ProgramUniformMatrix3x2fv, funcs.ProgramUniformMatrix2x4fv, funcs.ProgramUniformMatrix4x2fv, funcs.ProgramUniformMatrix3x4fv, funcs.ProgramUniformMatrix4x3fv, funcs.ProgramUniformMatrix2x3dv, funcs.ProgramUniformMatrix3x2dv, funcs.ProgramUniformMatrix2x4dv, funcs.ProgramUniformMatrix4x2dv, funcs.ProgramUniformMatrix3x4dv, funcs.ProgramUniformMatrix4x3dv, funcs.ValidateProgramPipeline, funcs.GetProgramPipelineInfoLog, funcs.VertexAttribL1d, funcs.VertexAttribL2d, funcs.VertexAttribL3d, funcs.VertexAttribL4d, funcs.VertexAttribL1dv, funcs.VertexAttribL2dv, funcs.VertexAttribL3dv, funcs.VertexAttribL4dv, funcs.VertexAttribLPointer, funcs.GetVertexAttribLdv, funcs.ViewportArrayv, funcs.ViewportIndexedf, funcs.ViewportIndexedfv, funcs.ScissorArrayv, funcs.ScissorIndexed, funcs.ScissorIndexedv, funcs.DepthRangeArrayv, funcs.DepthRangeIndexed, funcs.GetFloati_v, funcs.GetDoublei_v);
        return GL.checkExtension("OpenGL41", funcs, supported);
    }

    public static void glReleaseShaderCompiler() {
        long __functionAddress = GL41.getInstance().ReleaseShaderCompiler;
        JNI.callV(__functionAddress);
    }

    public static void nglShaderBinary(int count, long shaders, int binaryformat, long binary, int length) {
        long __functionAddress = GL41.getInstance().ShaderBinary;
        JNI.callIPIPIV(__functionAddress, count, shaders, binaryformat, binary, length);
    }

    public static void glShaderBinary(int count, ByteBuffer shaders, int binaryformat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)shaders, count << 2);
            Checks.checkBuffer((Buffer)binary, length);
        }
        GL41.nglShaderBinary(count, MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), length);
    }

    public static void glShaderBinary(IntBuffer shaders, int binaryformat, ByteBuffer binary) {
        GL41.nglShaderBinary(shaders.remaining(), MemoryUtil.memAddress(shaders), binaryformat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void nglGetShaderPrecisionFormat(int shadertype, int precisiontype, long range, long precision) {
        long __functionAddress = GL41.getInstance().GetShaderPrecisionFormat;
        JNI.callIIPPV(__functionAddress, shadertype, precisiontype, range, precision);
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, ByteBuffer range, ByteBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 8);
            Checks.checkBuffer((Buffer)precision, 4);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
            Checks.checkBuffer((Buffer)precision, 1);
        }
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), MemoryUtil.memAddress(precision));
    }

    public static int glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)range, 2);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int precision = __buffer.intParam();
        GL41.nglGetShaderPrecisionFormat(shadertype, precisiontype, MemoryUtil.memAddress(range), __buffer.address(precision));
        return __buffer.intValue(precision);
    }

    public static void glDepthRangef(float zNear, float zFar) {
        long __functionAddress = GL41.getInstance().DepthRangef;
        JNI.callFFV(__functionAddress, zNear, zFar);
    }

    public static void glClearDepthf(float depth) {
        long __functionAddress = GL41.getInstance().ClearDepthf;
        JNI.callFV(__functionAddress, depth);
    }

    public static void nglGetProgramBinary(int program, int bufSize, long length, long binaryFormat, long binary) {
        long __functionAddress = GL41.getInstance().GetProgramBinary;
        JNI.callIIPPPV(__functionAddress, program, bufSize, length, binaryFormat, binary);
    }

    public static void glGetProgramBinary(int program, int bufSize, ByteBuffer length, ByteBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 4);
        }
        GL41.nglGetProgramBinary(program, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static void glGetProgramBinary(int program, IntBuffer length, IntBuffer binaryFormat, ByteBuffer binary) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        GL41.nglGetProgramBinary(program, binary.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
    }

    public static ByteBuffer glGetProgramBinary(int program, int bufSize, IntBuffer binaryFormat) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        GL41.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static ByteBuffer glGetProgramBinary(int program, IntBuffer binaryFormat) {
        int bufSize = GL20.glGetProgrami(program, 34625);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binaryFormat, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        ByteBuffer binary = BufferUtils.createByteBuffer(bufSize);
        GL41.nglGetProgramBinary(program, bufSize, __buffer.address(length), MemoryUtil.memAddress(binaryFormat), MemoryUtil.memAddress(binary));
        binary.limit(__buffer.intValue(length));
        return binary.slice();
    }

    public static void nglProgramBinary(int program, int binaryFormat, long binary, int length) {
        long __functionAddress = GL41.getInstance().ProgramBinary;
        JNI.callIIPIV(__functionAddress, program, binaryFormat, binary, length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary, int length) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)binary, length);
        }
        GL41.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), length);
    }

    public static void glProgramBinary(int program, int binaryFormat, ByteBuffer binary) {
        GL41.nglProgramBinary(program, binaryFormat, MemoryUtil.memAddress(binary), binary.remaining());
    }

    public static void glProgramParameteri(int program, int pname, int value) {
        long __functionAddress = GL41.getInstance().ProgramParameteri;
        JNI.callIIIV(__functionAddress, program, pname, value);
    }

    public static void glUseProgramStages(int pipeline, int stages, int program) {
        long __functionAddress = GL41.getInstance().UseProgramStages;
        JNI.callIIIV(__functionAddress, pipeline, stages, program);
    }

    public static void glActiveShaderProgram(int pipeline, int program) {
        long __functionAddress = GL41.getInstance().ActiveShaderProgram;
        JNI.callIIV(__functionAddress, pipeline, program);
    }

    public static int nglCreateShaderProgramv(int type, int count, long strings) {
        long __functionAddress = GL41.getInstance().CreateShaderProgramv;
        return JNI.callIIPI(__functionAddress, type, count, strings);
    }

    public static int glCreateShaderProgramv(int type, int count, ByteBuffer strings) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)strings, count << Pointer.POINTER_SHIFT);
        }
        return GL41.nglCreateShaderProgramv(type, count, MemoryUtil.memAddress(strings));
    }

    public static int glCreateShaderProgramv(int type, PointerBuffer strings) {
        return GL41.nglCreateShaderProgramv(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence ... strings) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(strings);
        try {
            int n = GL41.nglCreateShaderProgramv(type, strings.length, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, strings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramv(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringsAddress = __buffer.pointerArrayParamUTF8(string);
        try {
            int n = GL41.nglCreateShaderProgramv(type, 1, __buffer.address(stringsAddress));
            return n;
        }
        finally {
            __buffer.pointerArrayFree(stringsAddress, 1);
        }
    }

    public static void glBindProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().BindProgramPipeline;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static void nglDeleteProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL41.getInstance().DeleteProgramPipelines;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glDeleteProgramPipelines(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL41.nglDeleteProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(IntBuffer pipelines) {
        GL41.nglDeleteProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static void glDeleteProgramPipelines(int pipeline) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam(pipeline);
        GL41.nglDeleteProgramPipelines(1, __buffer.address(pipelines));
    }

    public static void nglGenProgramPipelines(int n, long pipelines) {
        long __functionAddress = GL41.getInstance().GenProgramPipelines;
        JNI.callIPV(__functionAddress, n, pipelines);
    }

    public static void glGenProgramPipelines(int n, ByteBuffer pipelines) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)pipelines, n << 2);
        }
        GL41.nglGenProgramPipelines(n, MemoryUtil.memAddress(pipelines));
    }

    public static void glGenProgramPipelines(IntBuffer pipelines) {
        GL41.nglGenProgramPipelines(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    public static int glGenProgramPipelines() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int pipelines = __buffer.intParam();
        GL41.nglGenProgramPipelines(1, __buffer.address(pipelines));
        return __buffer.intValue(pipelines);
    }

    public static boolean glIsProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().IsProgramPipeline;
        return JNI.callIZ(__functionAddress, pipeline);
    }

    public static void nglGetProgramPipelineiv(int pipeline, int pname, long params) {
        long __functionAddress = GL41.getInstance().GetProgramPipelineiv;
        JNI.callIIPV(__functionAddress, pipeline, pname, params);
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramPipelineiv(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL41.nglGetProgramPipelineiv(pipeline, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramPipelinei(int pipeline, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL41.nglGetProgramPipelineiv(pipeline, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void glProgramUniform1i(int program, int location, int x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1i;
        JNI.callIIIV(__functionAddress, program, location, x);
    }

    public static void glProgramUniform2i(int program, int location, int x, int y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2i;
        JNI.callIIIIV(__functionAddress, program, location, x, y);
    }

    public static void glProgramUniform3i(int program, int location, int x, int y, int z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3i;
        JNI.callIIIIIV(__functionAddress, program, location, x, y, z);
    }

    public static void glProgramUniform4i(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4i;
        JNI.callIIIIIIV(__functionAddress, program, location, x, y, z, w);
    }

    public static void glProgramUniform1ui(int program, int location, int x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1ui;
        JNI.callIIIV(__functionAddress, program, location, x);
    }

    public static void glProgramUniform2ui(int program, int location, int x, int y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2ui;
        JNI.callIIIIV(__functionAddress, program, location, x, y);
    }

    public static void glProgramUniform3ui(int program, int location, int x, int y, int z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3ui;
        JNI.callIIIIIV(__functionAddress, program, location, x, y, z);
    }

    public static void glProgramUniform4ui(int program, int location, int x, int y, int z, int w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4ui;
        JNI.callIIIIIIV(__functionAddress, program, location, x, y, z, w);
    }

    public static void glProgramUniform1f(int program, int location, float x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1f;
        JNI.callIIFV(__functionAddress, program, location, x);
    }

    public static void glProgramUniform2f(int program, int location, float x, float y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2f;
        JNI.callIIFFV(__functionAddress, program, location, x, y);
    }

    public static void glProgramUniform3f(int program, int location, float x, float y, float z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3f;
        JNI.callIIFFFV(__functionAddress, program, location, x, y, z);
    }

    public static void glProgramUniform4f(int program, int location, float x, float y, float z, float w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4f;
        JNI.callIIFFFFV(__functionAddress, program, location, x, y, z, w);
    }

    public static void glProgramUniform1d(int program, int location, double x) {
        long __functionAddress = GL41.getInstance().ProgramUniform1d;
        JNI.callIIDV(__functionAddress, program, location, x);
    }

    public static void glProgramUniform2d(int program, int location, double x, double y) {
        long __functionAddress = GL41.getInstance().ProgramUniform2d;
        JNI.callIIDDV(__functionAddress, program, location, x, y);
    }

    public static void glProgramUniform3d(int program, int location, double x, double y, double z) {
        long __functionAddress = GL41.getInstance().ProgramUniform3d;
        JNI.callIIDDDV(__functionAddress, program, location, x, y, z);
    }

    public static void glProgramUniform4d(int program, int location, double x, double y, double z, double w) {
        long __functionAddress = GL41.getInstance().ProgramUniform4d;
        JNI.callIIDDDDV(__functionAddress, program, location, x, y, z, w);
    }

    public static void nglProgramUniform1iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1iv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform1iv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2iv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform2iv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3iv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform3iv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4iv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4iv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4iv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4iv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4iv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform4iv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1uiv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform1uiv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2uiv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform2uiv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3uiv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform3uiv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uiv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4uiv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4uiv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4uiv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4uiv(int program, int location, IntBuffer value) {
        GL41.nglProgramUniform4uiv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2);
        }
        GL41.nglProgramUniform1fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1fv(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform1fv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 2);
        }
        GL41.nglProgramUniform2fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fv(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform2fv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniform3fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fv(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform3fv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4fv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4fv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4fv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniform4fv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fv(int program, int location, FloatBuffer value) {
        GL41.nglProgramUniform4fv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform1dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform1dv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1dv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        GL41.nglProgramUniform1dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1dv(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform1dv(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform2dv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2dv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 3);
        }
        GL41.nglProgramUniform2dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2dv(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform2dv(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform3dv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3dv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        GL41.nglProgramUniform3dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3dv(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform3dv(program, location, value.remaining() / 9, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4dv(int program, int location, int count, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniform4dv;
        JNI.callIIIPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4dv(int program, int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL41.nglProgramUniform4dv(program, location, count, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4dv(int program, int location, DoubleBuffer value) {
        GL41.nglProgramUniform4dv(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 2);
        }
        GL41.nglProgramUniformMatrix2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2fv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 2);
        }
        GL41.nglProgramUniformMatrix3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3fv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 2);
        }
        GL41.nglProgramUniformMatrix4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4fv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL41.nglProgramUniformMatrix2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2dv(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        GL41.nglProgramUniformMatrix3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3dv(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 3);
        }
        GL41.nglProgramUniformMatrix4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4dv(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL41.nglProgramUniformMatrix2x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2x3fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 2);
        }
        GL41.nglProgramUniformMatrix3x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3x2fv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL41.nglProgramUniformMatrix2x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix2x4fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x2fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 2);
        }
        GL41.nglProgramUniformMatrix4x2fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4x2fv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x4fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL41.nglProgramUniformMatrix3x4fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix3x4fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x3fv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 2);
        }
        GL41.nglProgramUniformMatrix4x3fv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3fv(int program, int location, boolean transpose, FloatBuffer value) {
        GL41.nglProgramUniformMatrix4x3fv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x3dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL41.nglProgramUniformMatrix2x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2x3dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x2dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL41.nglProgramUniformMatrix3x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3x2dv(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix2x4dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL41.nglProgramUniformMatrix2x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix2x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix2x4dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x2dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL41.nglProgramUniformMatrix4x2dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x2dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4x2dv(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix3x4dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL41.nglProgramUniformMatrix3x4dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix3x4dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix3x4dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GL41.getInstance().ProgramUniformMatrix4x3dv;
        JNI.callIIIZPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL41.nglProgramUniformMatrix4x3dv(program, location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniformMatrix4x3dv(int program, int location, boolean transpose, DoubleBuffer value) {
        GL41.nglProgramUniformMatrix4x3dv(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glValidateProgramPipeline(int pipeline) {
        long __functionAddress = GL41.getInstance().ValidateProgramPipeline;
        JNI.callIV(__functionAddress, pipeline);
    }

    public static void nglGetProgramPipelineInfoLog(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = GL41.getInstance().GetProgramPipelineInfoLog;
        JNI.callIIPPV(__functionAddress, pipeline, bufSize, length, infoLog);
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, int bufSize, ByteBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)infoLog, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineInfoLog(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL41.nglGetProgramPipelineInfoLog(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    public static String glGetProgramPipelineInfoLog(int pipeline, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static String glGetProgramPipelineInfoLog(int pipeline) {
        int bufSize = GL41.glGetProgramPipelinei(pipeline, 35716);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int infoLog = __buffer.bufferParam(bufSize);
        GL41.nglGetProgramPipelineInfoLog(pipeline, bufSize, __buffer.address(length), __buffer.address(infoLog));
        return MemoryUtil.memDecodeUTF8(__buffer.buffer(), __buffer.intValue(length), infoLog);
    }

    public static void glVertexAttribL1d(int index, double x) {
        long __functionAddress = GL41.getInstance().VertexAttribL1d;
        JNI.callIDV(__functionAddress, index, x);
    }

    public static void glVertexAttribL2d(int index, double x, double y) {
        long __functionAddress = GL41.getInstance().VertexAttribL2d;
        JNI.callIDDV(__functionAddress, index, x, y);
    }

    public static void glVertexAttribL3d(int index, double x, double y, double z) {
        long __functionAddress = GL41.getInstance().VertexAttribL3d;
        JNI.callIDDDV(__functionAddress, index, x, y, z);
    }

    public static void glVertexAttribL4d(int index, double x, double y, double z, double w) {
        long __functionAddress = GL41.getInstance().VertexAttribL4d;
        JNI.callIDDDDV(__functionAddress, index, x, y, z, w);
    }

    public static void nglVertexAttribL1dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL1dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL1dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 8);
        }
        GL41.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL1dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 1);
        }
        GL41.nglVertexAttribL1dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL2dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL2dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL2dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL2dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 2);
        }
        GL41.nglVertexAttribL2dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL3dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL3dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL3dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 24);
        }
        GL41.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL3dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 3);
        }
        GL41.nglVertexAttribL3dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribL4dv(int index, long v) {
        long __functionAddress = GL41.getInstance().VertexAttribL4dv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glVertexAttribL4dv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 32);
        }
        GL41.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void glVertexAttribL4dv(int index, DoubleBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglVertexAttribL4dv(index, MemoryUtil.memAddress(v));
    }

    public static void nglVertexAttribLPointer(int index, int size, int type, int stride, long pointer) {
        long __functionAddress = GL41.getInstance().VertexAttribLPointer;
        JNI.callIIIIPV(__functionAddress, index, size, type, stride, pointer);
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, ByteBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, MemoryUtil.memAddress(pointer));
    }

    public static void glVertexAttribLPointer(int index, int size, int type, int stride, long pointerOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, true);
        }
        GL41.nglVertexAttribLPointer(index, size, type, stride, pointerOffset);
    }

    public static void glVertexAttribLPointer(int index, int size, int stride, DoubleBuffer pointer) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34964, false);
        }
        GL41.nglVertexAttribLPointer(index, size, 5130, stride, MemoryUtil.memAddress(pointer));
    }

    public static void nglGetVertexAttribLdv(int index, int pname, long params) {
        long __functionAddress = GL41.getInstance().GetVertexAttribLdv;
        JNI.callIIPV(__functionAddress, index, pname, params);
    }

    public static void glGetVertexAttribLdv(int index, int pname, ByteBuffer params) {
        GL41.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetVertexAttribLdv(int index, int pname, DoubleBuffer params) {
        GL41.nglGetVertexAttribLdv(index, pname, MemoryUtil.memAddress(params));
    }

    public static void nglViewportArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().ViewportArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glViewportArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        GL41.nglViewportArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glViewportArrayv(int first, FloatBuffer v) {
        GL41.nglViewportArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedf(int index, float x, float y, float w, float h) {
        long __functionAddress = GL41.getInstance().ViewportIndexedf;
        JNI.callIFFFFV(__functionAddress, index, x, y, w, h);
    }

    public static void nglViewportIndexedfv(int index, long v) {
        long __functionAddress = GL41.getInstance().ViewportIndexedfv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glViewportIndexedfv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static void glViewportIndexedfv(int index, FloatBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglViewportIndexedfv(index, MemoryUtil.memAddress(v));
    }

    public static void nglScissorArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().ScissorArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glScissorArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 2 << 2);
        }
        GL41.nglScissorArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glScissorArrayv(int first, IntBuffer v) {
        GL41.nglScissorArrayv(first, v.remaining() >> 2, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexed(int index, int left, int bottom, int width, int height) {
        long __functionAddress = GL41.getInstance().ScissorIndexed;
        JNI.callIIIIIV(__functionAddress, index, left, bottom, width, height);
    }

    public static void nglScissorIndexedv(int index, long v) {
        long __functionAddress = GL41.getInstance().ScissorIndexedv;
        JNI.callIPV(__functionAddress, index, v);
    }

    public static void glScissorIndexedv(int index, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 16);
        }
        GL41.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static void glScissorIndexedv(int index, IntBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, 4);
        }
        GL41.nglScissorIndexedv(index, MemoryUtil.memAddress(v));
    }

    public static void nglDepthRangeArrayv(int first, int count, long v) {
        long __functionAddress = GL41.getInstance().DepthRangeArrayv;
        JNI.callIIPV(__functionAddress, first, count, v);
    }

    public static void glDepthRangeArrayv(int first, int count, ByteBuffer v) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)v, count << 1 << 3);
        }
        GL41.nglDepthRangeArrayv(first, count, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeArrayv(int first, DoubleBuffer v) {
        GL41.nglDepthRangeArrayv(first, v.remaining() >> 1, MemoryUtil.memAddress(v));
    }

    public static void glDepthRangeIndexed(int index, double zNear, double zFar) {
        long __functionAddress = GL41.getInstance().DepthRangeIndexed;
        JNI.callIDDV(__functionAddress, index, zNear, zFar);
    }

    public static void nglGetFloati_v(int target, int index, long data) {
        long __functionAddress = GL41.getInstance().GetFloati_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetFloati_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        GL41.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetFloati_v(int target, int index, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GL41.nglGetFloati_v(target, index, MemoryUtil.memAddress(data));
    }

    public static float glGetFloati(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.floatParam();
        GL41.nglGetFloati_v(target, index, __buffer.address(data));
        return __buffer.floatValue(data);
    }

    public static void nglGetDoublei_v(int target, int index, long data) {
        long __functionAddress = GL41.getInstance().GetDoublei_v;
        JNI.callIIPV(__functionAddress, target, index, data);
    }

    public static void glGetDoublei_v(int target, int index, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 8);
        }
        GL41.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static void glGetDoublei_v(int target, int index, DoubleBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        GL41.nglGetDoublei_v(target, index, MemoryUtil.memAddress(data));
    }

    public static double glGetDoublei(int target, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int data = __buffer.doubleParam();
        GL41.nglGetDoublei_v(target, index, __buffer.address(data));
        return __buffer.doubleValue(data);
    }
}

