/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class GL40 {
    public static final int GL_DRAW_INDIRECT_BUFFER = 36671;
    public static final int GL_DRAW_INDIRECT_BUFFER_BINDING = 36675;
    public static final int GL_GEOMETRY_SHADER_INVOCATIONS = 34943;
    public static final int GL_MAX_GEOMETRY_SHADER_INVOCATIONS = 36442;
    public static final int GL_MIN_FRAGMENT_INTERPOLATION_OFFSET = 36443;
    public static final int GL_MAX_FRAGMENT_INTERPOLATION_OFFSET = 36444;
    public static final int GL_FRAGMENT_INTERPOLATION_OFFSET_BITS = 36445;
    public static final int GL_DOUBLE_VEC2 = 36860;
    public static final int GL_DOUBLE_VEC3 = 36861;
    public static final int GL_DOUBLE_VEC4 = 36862;
    public static final int GL_DOUBLE_MAT2 = 36678;
    public static final int GL_DOUBLE_MAT3 = 36679;
    public static final int GL_DOUBLE_MAT4 = 36680;
    public static final int GL_DOUBLE_MAT2x3 = 36681;
    public static final int GL_DOUBLE_MAT2x4 = 36682;
    public static final int GL_DOUBLE_MAT3x2 = 36683;
    public static final int GL_DOUBLE_MAT3x4 = 36684;
    public static final int GL_DOUBLE_MAT4x2 = 36685;
    public static final int GL_DOUBLE_MAT4x3 = 36686;
    public static final int GL_SAMPLE_SHADING = 35894;
    public static final int GL_MIN_SAMPLE_SHADING_VALUE = 35895;
    public static final int GL_ACTIVE_SUBROUTINES = 36325;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORMS = 36326;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_LOCATIONS = 36423;
    public static final int GL_ACTIVE_SUBROUTINE_MAX_LENGTH = 36424;
    public static final int GL_ACTIVE_SUBROUTINE_UNIFORM_MAX_LENGTH = 36425;
    public static final int GL_MAX_SUBROUTINES = 36327;
    public static final int GL_MAX_SUBROUTINE_UNIFORM_LOCATIONS = 36328;
    public static final int GL_NUM_COMPATIBLE_SUBROUTINES = 36426;
    public static final int GL_COMPATIBLE_SUBROUTINES = 36427;
    public static final int GL_PATCHES = 14;
    public static final int GL_PATCH_VERTICES = 36466;
    public static final int GL_PATCH_DEFAULT_INNER_LEVEL = 36467;
    public static final int GL_PATCH_DEFAULT_OUTER_LEVEL = 36468;
    public static final int GL_TESS_CONTROL_OUTPUT_VERTICES = 36469;
    public static final int GL_TESS_GEN_MODE = 36470;
    public static final int GL_TESS_GEN_SPACING = 36471;
    public static final int GL_TESS_GEN_VERTEX_ORDER = 36472;
    public static final int GL_TESS_GEN_POINT_MODE = 36473;
    public static final int GL_ISOLINES = 36474;
    public static final int GL_FRACTIONAL_ODD = 36475;
    public static final int GL_FRACTIONAL_EVEN = 36476;
    public static final int GL_MAX_PATCH_VERTICES = 36477;
    public static final int GL_MAX_TESS_GEN_LEVEL = 36478;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_COMPONENTS = 36479;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_COMPONENTS = 36480;
    public static final int GL_MAX_TESS_CONTROL_TEXTURE_IMAGE_UNITS = 36481;
    public static final int GL_MAX_TESS_EVALUATION_TEXTURE_IMAGE_UNITS = 36482;
    public static final int GL_MAX_TESS_CONTROL_OUTPUT_COMPONENTS = 36483;
    public static final int GL_MAX_TESS_PATCH_COMPONENTS = 36484;
    public static final int GL_MAX_TESS_CONTROL_TOTAL_OUTPUT_COMPONENTS = 36485;
    public static final int GL_MAX_TESS_EVALUATION_OUTPUT_COMPONENTS = 36486;
    public static final int GL_MAX_TESS_CONTROL_UNIFORM_BLOCKS = 36489;
    public static final int GL_MAX_TESS_EVALUATION_UNIFORM_BLOCKS = 36490;
    public static final int GL_MAX_TESS_CONTROL_INPUT_COMPONENTS = 34924;
    public static final int GL_MAX_TESS_EVALUATION_INPUT_COMPONENTS = 34925;
    public static final int GL_MAX_COMBINED_TESS_CONTROL_UNIFORM_COMPONENTS = 36382;
    public static final int GL_MAX_COMBINED_TESS_EVALUATION_UNIFORM_COMPONENTS = 36383;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_CONTROL_SHADER = 34032;
    public static final int GL_UNIFORM_BLOCK_REFERENCED_BY_TESS_EVALUATION_SHADER = 34033;
    public static final int GL_TESS_EVALUATION_SHADER = 36487;
    public static final int GL_TESS_CONTROL_SHADER = 36488;
    public static final int GL_TEXTURE_CUBE_MAP_ARRAY = 36873;
    public static final int GL_TEXTURE_BINDING_CUBE_MAP_ARRAY = 36874;
    public static final int GL_PROXY_TEXTURE_CUBE_MAP_ARRAY = 36875;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY = 36876;
    public static final int GL_SAMPLER_CUBE_MAP_ARRAY_SHADOW = 36877;
    public static final int GL_INT_SAMPLER_CUBE_MAP_ARRAY = 36878;
    public static final int GL_UNSIGNED_INT_SAMPLER_CUBE_MAP_ARRAY = 36879;
    public static final int GL_MIN_PROGRAM_TEXTURE_GATHER_OFFSET = 36446;
    public static final int GL_MAX_PROGRAM_TEXTURE_GATHER_OFFSET = 36447;
    public static final int GL_TRANSFORM_FEEDBACK = 36386;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED = 36387;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE = 36388;
    public static final int GL_TRANSFORM_FEEDBACK_BINDING = 36389;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_BUFFERS = 36464;
    public static final int GL_MAX_VERTEX_STREAMS = 36465;
    public final long BlendEquationi;
    public final long BlendEquationSeparatei;
    public final long BlendFunci;
    public final long BlendFuncSeparatei;
    public final long DrawArraysIndirect;
    public final long DrawElementsIndirect;
    public final long Uniform1d;
    public final long Uniform2d;
    public final long Uniform3d;
    public final long Uniform4d;
    public final long Uniform1dv;
    public final long Uniform2dv;
    public final long Uniform3dv;
    public final long Uniform4dv;
    public final long UniformMatrix2dv;
    public final long UniformMatrix3dv;
    public final long UniformMatrix4dv;
    public final long UniformMatrix2x3dv;
    public final long UniformMatrix2x4dv;
    public final long UniformMatrix3x2dv;
    public final long UniformMatrix3x4dv;
    public final long UniformMatrix4x2dv;
    public final long UniformMatrix4x3dv;
    public final long GetUniformdv;
    public final long MinSampleShading;
    public final long GetSubroutineUniformLocation;
    public final long GetSubroutineIndex;
    public final long GetActiveSubroutineUniformiv;
    public final long GetActiveSubroutineUniformName;
    public final long GetActiveSubroutineName;
    public final long UniformSubroutinesuiv;
    public final long GetUniformSubroutineuiv;
    public final long GetProgramStageiv;
    public final long PatchParameteri;
    public final long PatchParameterfv;
    public final long BindTransformFeedback;
    public final long DeleteTransformFeedbacks;
    public final long GenTransformFeedbacks;
    public final long IsTransformFeedback;
    public final long PauseTransformFeedback;
    public final long ResumeTransformFeedback;
    public final long DrawTransformFeedback;
    public final long DrawTransformFeedbackStream;
    public final long BeginQueryIndexed;
    public final long EndQueryIndexed;
    public final long GetQueryIndexediv;

    protected GL40() {
        throw new UnsupportedOperationException();
    }

    public GL40(FunctionProvider provider) {
        this.BlendEquationi = provider.getFunctionAddress("glBlendEquationi");
        this.BlendEquationSeparatei = provider.getFunctionAddress("glBlendEquationSeparatei");
        this.BlendFunci = provider.getFunctionAddress("glBlendFunci");
        this.BlendFuncSeparatei = provider.getFunctionAddress("glBlendFuncSeparatei");
        this.DrawArraysIndirect = provider.getFunctionAddress("glDrawArraysIndirect");
        this.DrawElementsIndirect = provider.getFunctionAddress("glDrawElementsIndirect");
        this.Uniform1d = provider.getFunctionAddress("glUniform1d");
        this.Uniform2d = provider.getFunctionAddress("glUniform2d");
        this.Uniform3d = provider.getFunctionAddress("glUniform3d");
        this.Uniform4d = provider.getFunctionAddress("glUniform4d");
        this.Uniform1dv = provider.getFunctionAddress("glUniform1dv");
        this.Uniform2dv = provider.getFunctionAddress("glUniform2dv");
        this.Uniform3dv = provider.getFunctionAddress("glUniform3dv");
        this.Uniform4dv = provider.getFunctionAddress("glUniform4dv");
        this.UniformMatrix2dv = provider.getFunctionAddress("glUniformMatrix2dv");
        this.UniformMatrix3dv = provider.getFunctionAddress("glUniformMatrix3dv");
        this.UniformMatrix4dv = provider.getFunctionAddress("glUniformMatrix4dv");
        this.UniformMatrix2x3dv = provider.getFunctionAddress("glUniformMatrix2x3dv");
        this.UniformMatrix2x4dv = provider.getFunctionAddress("glUniformMatrix2x4dv");
        this.UniformMatrix3x2dv = provider.getFunctionAddress("glUniformMatrix3x2dv");
        this.UniformMatrix3x4dv = provider.getFunctionAddress("glUniformMatrix3x4dv");
        this.UniformMatrix4x2dv = provider.getFunctionAddress("glUniformMatrix4x2dv");
        this.UniformMatrix4x3dv = provider.getFunctionAddress("glUniformMatrix4x3dv");
        this.GetUniformdv = provider.getFunctionAddress("glGetUniformdv");
        this.MinSampleShading = provider.getFunctionAddress("glMinSampleShading");
        this.GetSubroutineUniformLocation = provider.getFunctionAddress("glGetSubroutineUniformLocation");
        this.GetSubroutineIndex = provider.getFunctionAddress("glGetSubroutineIndex");
        this.GetActiveSubroutineUniformiv = provider.getFunctionAddress("glGetActiveSubroutineUniformiv");
        this.GetActiveSubroutineUniformName = provider.getFunctionAddress("glGetActiveSubroutineUniformName");
        this.GetActiveSubroutineName = provider.getFunctionAddress("glGetActiveSubroutineName");
        this.UniformSubroutinesuiv = provider.getFunctionAddress("glUniformSubroutinesuiv");
        this.GetUniformSubroutineuiv = provider.getFunctionAddress("glGetUniformSubroutineuiv");
        this.GetProgramStageiv = provider.getFunctionAddress("glGetProgramStageiv");
        this.PatchParameteri = provider.getFunctionAddress("glPatchParameteri");
        this.PatchParameterfv = provider.getFunctionAddress("glPatchParameterfv");
        this.BindTransformFeedback = provider.getFunctionAddress("glBindTransformFeedback");
        this.DeleteTransformFeedbacks = provider.getFunctionAddress("glDeleteTransformFeedbacks");
        this.GenTransformFeedbacks = provider.getFunctionAddress("glGenTransformFeedbacks");
        this.IsTransformFeedback = provider.getFunctionAddress("glIsTransformFeedback");
        this.PauseTransformFeedback = provider.getFunctionAddress("glPauseTransformFeedback");
        this.ResumeTransformFeedback = provider.getFunctionAddress("glResumeTransformFeedback");
        this.DrawTransformFeedback = provider.getFunctionAddress("glDrawTransformFeedback");
        this.DrawTransformFeedbackStream = provider.getFunctionAddress("glDrawTransformFeedbackStream");
        this.BeginQueryIndexed = provider.getFunctionAddress("glBeginQueryIndexed");
        this.EndQueryIndexed = provider.getFunctionAddress("glEndQueryIndexed");
        this.GetQueryIndexediv = provider.getFunctionAddress("glGetQueryIndexediv");
    }

    public static GL40 getInstance() {
        return GL40.getInstance(GL.getCapabilities());
    }

    public static GL40 getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__GL40);
    }

    static GL40 create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("OpenGL40")) {
            return null;
        }
        GL40 funcs = new GL40(provider);
        boolean supported = Checks.checkFunctions(funcs.BlendEquationi, funcs.BlendEquationSeparatei, funcs.BlendFunci, funcs.BlendFuncSeparatei, funcs.DrawArraysIndirect, funcs.DrawElementsIndirect, funcs.Uniform1d, funcs.Uniform2d, funcs.Uniform3d, funcs.Uniform4d, funcs.Uniform1dv, funcs.Uniform2dv, funcs.Uniform3dv, funcs.Uniform4dv, funcs.UniformMatrix2dv, funcs.UniformMatrix3dv, funcs.UniformMatrix4dv, funcs.UniformMatrix2x3dv, funcs.UniformMatrix2x4dv, funcs.UniformMatrix3x2dv, funcs.UniformMatrix3x4dv, funcs.UniformMatrix4x2dv, funcs.UniformMatrix4x3dv, funcs.GetUniformdv, funcs.MinSampleShading, funcs.GetSubroutineUniformLocation, funcs.GetSubroutineIndex, funcs.GetActiveSubroutineUniformiv, funcs.GetActiveSubroutineUniformName, funcs.GetActiveSubroutineName, funcs.UniformSubroutinesuiv, funcs.GetUniformSubroutineuiv, funcs.GetProgramStageiv, funcs.PatchParameteri, funcs.PatchParameterfv, funcs.BindTransformFeedback, funcs.DeleteTransformFeedbacks, funcs.GenTransformFeedbacks, funcs.IsTransformFeedback, funcs.PauseTransformFeedback, funcs.ResumeTransformFeedback, funcs.DrawTransformFeedback, funcs.DrawTransformFeedbackStream, funcs.BeginQueryIndexed, funcs.EndQueryIndexed, funcs.GetQueryIndexediv);
        return GL.checkExtension("OpenGL40", funcs, supported);
    }

    public static void glBlendEquationi(int buf, int mode) {
        long __functionAddress = GL40.getInstance().BlendEquationi;
        JNI.callIIV(__functionAddress, buf, mode);
    }

    public static void glBlendEquationSeparatei(int buf, int modeRGB, int modeAlpha) {
        long __functionAddress = GL40.getInstance().BlendEquationSeparatei;
        JNI.callIIIV(__functionAddress, buf, modeRGB, modeAlpha);
    }

    public static void glBlendFunci(int buf, int sfactor, int dfactor) {
        long __functionAddress = GL40.getInstance().BlendFunci;
        JNI.callIIIV(__functionAddress, buf, sfactor, dfactor);
    }

    public static void glBlendFuncSeparatei(int buf, int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        long __functionAddress = GL40.getInstance().BlendFuncSeparatei;
        JNI.callIIIIIV(__functionAddress, buf, srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public static void nglDrawArraysIndirect(int mode, long indirect) {
        long __functionAddress = GL40.getInstance().DrawArraysIndirect;
        JNI.callIPV(__functionAddress, mode, indirect);
    }

    public static void glDrawArraysIndirect(int mode, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 16);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawArraysIndirect(int mode, long indirectOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL40.nglDrawArraysIndirect(mode, indirectOffset);
    }

    public static void glDrawArraysIndirect(int mode, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 4);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawArraysIndirect(mode, MemoryUtil.memAddress(indirect));
    }

    public static void nglDrawElementsIndirect(int mode, int type, long indirect) {
        long __functionAddress = GL40.getInstance().DrawElementsIndirect;
        JNI.callIIPV(__functionAddress, mode, type, indirect);
    }

    public static void glDrawElementsIndirect(int mode, int type, ByteBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 20);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glDrawElementsIndirect(int mode, int type, long indirectOffset) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(36675, true);
        }
        GL40.nglDrawElementsIndirect(mode, type, indirectOffset);
    }

    public static void glDrawElementsIndirect(int mode, int type, IntBuffer indirect) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indirect, 5);
            GLChecks.ensureBufferObject(36675, false);
        }
        GL40.nglDrawElementsIndirect(mode, type, MemoryUtil.memAddress(indirect));
    }

    public static void glUniform1d(int location, double x) {
        long __functionAddress = GL40.getInstance().Uniform1d;
        JNI.callIDV(__functionAddress, location, x);
    }

    public static void glUniform2d(int location, double x, double y) {
        long __functionAddress = GL40.getInstance().Uniform2d;
        JNI.callIDDV(__functionAddress, location, x, y);
    }

    public static void glUniform3d(int location, double x, double y, double z) {
        long __functionAddress = GL40.getInstance().Uniform3d;
        JNI.callIDDDV(__functionAddress, location, x, y, z);
    }

    public static void glUniform4d(int location, double x, double y, double z, double w) {
        long __functionAddress = GL40.getInstance().Uniform4d;
        JNI.callIDDDDV(__functionAddress, location, x, y, z, w);
    }

    public static void nglUniform1dv(int location, int count, long value) {
        long __functionAddress = GL40.getInstance().Uniform1dv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform1dv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3);
        }
        GL40.nglUniform1dv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform1dv(int location, DoubleBuffer value) {
        GL40.nglUniform1dv(location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglUniform2dv(int location, int count, long value) {
        long __functionAddress = GL40.getInstance().Uniform2dv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform2dv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 1 << 3);
        }
        GL40.nglUniform2dv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform2dv(int location, DoubleBuffer value) {
        GL40.nglUniform2dv(location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglUniform3dv(int location, int count, long value) {
        long __functionAddress = GL40.getInstance().Uniform3dv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform3dv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 3 << 3);
        }
        GL40.nglUniform3dv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform3dv(int location, DoubleBuffer value) {
        GL40.nglUniform3dv(location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglUniform4dv(int location, int count, long value) {
        long __functionAddress = GL40.getInstance().Uniform4dv;
        JNI.callIIPV(__functionAddress, location, count, value);
    }

    public static void glUniform4dv(int location, int count, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL40.nglUniform4dv(location, count, MemoryUtil.memAddress(value));
    }

    public static void glUniform4dv(int location, DoubleBuffer value) {
        GL40.nglUniform4dv(location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix2dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 2 << 3);
        }
        GL40.nglUniformMatrix2dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2dv(location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix3dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 9 << 3);
        }
        GL40.nglUniformMatrix3dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3dv(location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix4dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 4 << 3);
        }
        GL40.nglUniformMatrix4dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4dv(location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix2x3dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x3dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL40.nglUniformMatrix2x3dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2x3dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix2x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix2x4dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix2x4dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL40.nglUniformMatrix2x4dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix2x4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix2x4dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix3x2dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x2dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 6 << 3);
        }
        GL40.nglUniformMatrix3x2dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3x2dv(location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix3x4dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix3x4dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix3x4dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL40.nglUniformMatrix3x4dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix3x4dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix3x4dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x2dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix4x2dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x2dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count << 3 << 3);
        }
        GL40.nglUniformMatrix4x2dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x2dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4x2dv(location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglUniformMatrix4x3dv(int location, int count, boolean transpose, long value) {
        long __functionAddress = GL40.getInstance().UniformMatrix4x3dv;
        JNI.callIIZPV(__functionAddress, location, count, transpose, value);
    }

    public static void glUniformMatrix4x3dv(int location, int count, boolean transpose, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, count * 12 << 3);
        }
        GL40.nglUniformMatrix4x3dv(location, count, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUniformMatrix4x3dv(int location, boolean transpose, DoubleBuffer value) {
        GL40.nglUniformMatrix4x3dv(location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglGetUniformdv(int program, int location, long params) {
        long __functionAddress = GL40.getInstance().GetUniformdv;
        JNI.callIIPV(__functionAddress, program, location, params);
    }

    public static void glGetUniformdv(int program, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 8);
        }
        GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformdv(int program, int location, DoubleBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetUniformdv(program, location, MemoryUtil.memAddress(params));
    }

    public static double glGetUniformd(int program, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.doubleParam();
        GL40.nglGetUniformdv(program, location, __buffer.address(params));
        return __buffer.doubleValue(params);
    }

    public static void glMinSampleShading(float value) {
        long __functionAddress = GL40.getInstance().MinSampleShading;
        JNI.callFV(__functionAddress, value);
    }

    public static int nglGetSubroutineUniformLocation(int program, int shadertype, long name) {
        long __functionAddress = GL40.getInstance().GetSubroutineUniformLocation;
        return JNI.callIIPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineUniformLocation(program, shadertype, MemoryUtil.memAddress(name));
    }

    public static int glGetSubroutineUniformLocation(int program, int shadertype, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL40.nglGetSubroutineUniformLocation(program, shadertype, __buffer.address(nameEncoded));
    }

    public static int nglGetSubroutineIndex(int program, int shadertype, long name) {
        long __functionAddress = GL40.getInstance().GetSubroutineIndex;
        return JNI.callIIPI(__functionAddress, program, shadertype, name);
    }

    public static int glGetSubroutineIndex(int program, int shadertype, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return GL40.nglGetSubroutineIndex(program, shadertype, MemoryUtil.memAddress(name));
    }

    public static int glGetSubroutineIndex(int program, int shadertype, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return GL40.nglGetSubroutineIndex(program, shadertype, __buffer.address(nameEncoded));
    }

    public static void nglGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, long values) {
        long __functionAddress = GL40.getInstance().GetActiveSubroutineUniformiv;
        JNI.callIIIIPV(__functionAddress, program, shadertype, index, pname, values);
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    public static void glGetActiveSubroutineUniformiv(int program, int shadertype, int index, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, MemoryUtil.memAddress(values));
    }

    public static int glGetActiveSubroutineUniformi(int program, int shadertype, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        GL40.nglGetActiveSubroutineUniformiv(program, shadertype, index, pname, __buffer.address(values));
        return __buffer.intValue(values);
    }

    public static void nglGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL40.getInstance().GetActiveSubroutineUniformName;
        JNI.callIIIIPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufsize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineUniformName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index, int bufsize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveSubroutineUniformName(int program, int shadertype, int index) {
        int bufsize = GL40.glGetActiveSubroutineUniformi(program, shadertype, index, 35385);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        GL40.nglGetActiveSubroutineUniformName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, long length, long name) {
        long __functionAddress = GL40.getInstance().GetActiveSubroutineName;
        JNI.callIIIIPPV(__functionAddress, program, shadertype, index, bufsize, length, name);
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufsize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetActiveSubroutineName(int program, int shadertype, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        GL40.nglGetActiveSubroutineName(program, shadertype, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetActiveSubroutineName(int program, int shadertype, int index, int bufsize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetActiveSubroutineName(int program, int shadertype, int index) {
        int bufsize = GL40.glGetProgramStagei(program, shadertype, 36424);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufsize);
        GL40.nglGetActiveSubroutineName(program, shadertype, index, bufsize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglUniformSubroutinesuiv(int shadertype, int count, long indices) {
        long __functionAddress = GL40.getInstance().UniformSubroutinesuiv;
        JNI.callIIPV(__functionAddress, shadertype, count, indices);
    }

    public static void glUniformSubroutinesuiv(int shadertype, int count, ByteBuffer indices) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << 2);
        }
        GL40.nglUniformSubroutinesuiv(shadertype, count, MemoryUtil.memAddress(indices));
    }

    public static void glUniformSubroutinesuiv(int shadertype, IntBuffer indices) {
        GL40.nglUniformSubroutinesuiv(shadertype, indices.remaining(), MemoryUtil.memAddress(indices));
    }

    public static void glUniformSubroutinesui(int shadertype, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int indices = __buffer.intParam(index);
        GL40.nglUniformSubroutinesuiv(shadertype, 1, __buffer.address(indices));
    }

    public static void nglGetUniformSubroutineuiv(int shadertype, int location, long params) {
        long __functionAddress = GL40.getInstance().GetUniformSubroutineuiv;
        JNI.callIIPV(__functionAddress, shadertype, location, params);
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    public static void glGetUniformSubroutineuiv(int shadertype, int location, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetUniformSubroutineuiv(shadertype, location, MemoryUtil.memAddress(params));
    }

    public static int glGetUniformSubroutineui(int shadertype, int location) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL40.nglGetUniformSubroutineuiv(shadertype, location, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetProgramStageiv(int program, int shadertype, int pname, long values) {
        long __functionAddress = GL40.getInstance().GetProgramStageiv;
        JNI.callIIIPV(__functionAddress, program, shadertype, pname, values);
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    public static void glGetProgramStageiv(int program, int shadertype, int pname, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        GL40.nglGetProgramStageiv(program, shadertype, pname, MemoryUtil.memAddress(values));
    }

    public static int glGetProgramStagei(int program, int shadertype, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        GL40.nglGetProgramStageiv(program, shadertype, pname, __buffer.address(values));
        return __buffer.intValue(values);
    }

    public static void glPatchParameteri(int pname, int value) {
        long __functionAddress = GL40.getInstance().PatchParameteri;
        JNI.callIIV(__functionAddress, pname, value);
    }

    public static void nglPatchParameterfv(int pname, long values) {
        long __functionAddress = GL40.getInstance().PatchParameterfv;
        JNI.callIPV(__functionAddress, pname, values);
    }

    public static void glPatchParameterfv(int pname, ByteBuffer values) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)values, GL11.glGetInteger(36466) << 2);
        }
        GL40.nglPatchParameterfv(pname, MemoryUtil.memAddress(values));
    }

    public static void glPatchParameterfv(int pname, FloatBuffer values) {
        if (Checks.CHECKS && Checks.DEBUG) {
            Checks.checkBuffer((Buffer)values, GL11.glGetInteger(36466));
        }
        GL40.nglPatchParameterfv(pname, MemoryUtil.memAddress(values));
    }

    public static void glBindTransformFeedback(int target, int id) {
        long __functionAddress = GL40.getInstance().BindTransformFeedback;
        JNI.callIIV(__functionAddress, target, id);
    }

    public static void nglDeleteTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL40.getInstance().DeleteTransformFeedbacks;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glDeleteTransformFeedbacks(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL40.nglDeleteTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glDeleteTransformFeedbacks(IntBuffer ids) {
        GL40.nglDeleteTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static void glDeleteTransformFeedbacks(int id) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        GL40.nglDeleteTransformFeedbacks(1, __buffer.address(ids));
    }

    public static void nglGenTransformFeedbacks(int n, long ids) {
        long __functionAddress = GL40.getInstance().GenTransformFeedbacks;
        JNI.callIPV(__functionAddress, n, ids);
    }

    public static void glGenTransformFeedbacks(int n, ByteBuffer ids) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)ids, n << 2);
        }
        GL40.nglGenTransformFeedbacks(n, MemoryUtil.memAddress(ids));
    }

    public static void glGenTransformFeedbacks(IntBuffer ids) {
        GL40.nglGenTransformFeedbacks(ids.remaining(), MemoryUtil.memAddress(ids));
    }

    public static int glGenTransformFeedbacks() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam();
        GL40.nglGenTransformFeedbacks(1, __buffer.address(ids));
        return __buffer.intValue(ids);
    }

    public static boolean glIsTransformFeedback(int id) {
        long __functionAddress = GL40.getInstance().IsTransformFeedback;
        return JNI.callIZ(__functionAddress, id);
    }

    public static void glPauseTransformFeedback() {
        long __functionAddress = GL40.getInstance().PauseTransformFeedback;
        JNI.callV(__functionAddress);
    }

    public static void glResumeTransformFeedback() {
        long __functionAddress = GL40.getInstance().ResumeTransformFeedback;
        JNI.callV(__functionAddress);
    }

    public static void glDrawTransformFeedback(int mode, int id) {
        long __functionAddress = GL40.getInstance().DrawTransformFeedback;
        JNI.callIIV(__functionAddress, mode, id);
    }

    public static void glDrawTransformFeedbackStream(int mode, int id, int stream) {
        long __functionAddress = GL40.getInstance().DrawTransformFeedbackStream;
        JNI.callIIIV(__functionAddress, mode, id, stream);
    }

    public static void glBeginQueryIndexed(int target, int index, int id) {
        long __functionAddress = GL40.getInstance().BeginQueryIndexed;
        JNI.callIIIV(__functionAddress, target, index, id);
    }

    public static void glEndQueryIndexed(int target, int index) {
        long __functionAddress = GL40.getInstance().EndQueryIndexed;
        JNI.callIIV(__functionAddress, target, index);
    }

    public static void nglGetQueryIndexediv(int target, int index, int pname, long params) {
        long __functionAddress = GL40.getInstance().GetQueryIndexediv;
        JNI.callIIIPV(__functionAddress, target, index, pname, params);
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetQueryIndexediv(int target, int index, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        GL40.nglGetQueryIndexediv(target, index, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetQueryIndexedi(int target, int index, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        GL40.nglGetQueryIndexediv(target, index, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

