/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLUtil;
import org.lwjgl.opengl.OpenGLException;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;

public final class GL {
    private static final ThreadLocal<GLCapabilities> capsTL = new ThreadLocal();
    private static final APIUtil.APIVersion MAX_VERSION = Configuration.getAPIVersion(Configuration.MAXVERSION_OPENGL);
    private static FunctionProvider functionProvider;

    private GL() {
    }

    public static void create() {
        SharedLibrary GL2;
        switch (Platform.get()) {
            case LINUX: {
                GL2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "libGL.so.1", "libGL.so");
                break;
            }
            case MACOSX: {
                GL2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "/System/Library/Frameworks/OpenGL.framework");
                break;
            }
            case WINDOWS: {
                GL2 = Library.loadNative(Configuration.LIBRARY_NAME_OPENGL, "opengl32");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GL.create(GL2);
    }

    public static void create(String libName) {
        GL.create(Library.loadNative(libName));
    }

    private static void create(final SharedLibrary OPENGL) {
        try {
            abstract class FunctionProviderGL
            extends FunctionProvider.Default {
                final /* synthetic */ SharedLibrary val$OPENGL;

                FunctionProviderGL(SharedLibrary sharedLibrary) {
                    this.val$OPENGL = sharedLibrary;
                }

                abstract long getExtensionAddress(long var1);

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    long address = this.getExtensionAddress(__buffer.address());
                    if (address == 0L && (address = this.val$OPENGL.getFunctionAddress(functionName)) == 0L) {
                        APIUtil.apiLog("Failed to locate address for GL function " + functionName);
                    }
                    return address;
                }

                @Override
                protected void destroy() {
                    this.val$OPENGL.release();
                }
            }
            FunctionProviderGL functionProvider;
            switch (Platform.get()) {
                case WINDOWS: {
                    functionProvider = new FunctionProviderGL(){
                        private final long wglGetProcAddress;
                        {
                            super(sharedLibrary);
                            this.wglGetProcAddress = OPENGL.getFunctionAddress("wglGetProcAddress");
                        }

                        @Override
                        long getExtensionAddress(long name) {
                            return JNI.callPP(this.wglGetProcAddress, name);
                        }
                    };
                    break;
                }
                case LINUX: {
                    functionProvider = new FunctionProviderGL(){
                        private final long glXGetProcAddress;
                        private final long glXGetProcAddressARB;
                        {
                            super(sharedLibrary);
                            this.glXGetProcAddress = OPENGL.getFunctionAddress("glXGetProcAddress");
                            this.glXGetProcAddressARB = OPENGL.getFunctionAddress("glXGetProcAddressARB");
                        }

                        @Override
                        long getExtensionAddress(long name) {
                            if (this.glXGetProcAddress != 0L) {
                                return JNI.callPP(this.glXGetProcAddress, name);
                            }
                            if (this.glXGetProcAddressARB != 0L) {
                                return JNI.callPP(this.glXGetProcAddressARB, name);
                            }
                            return 0L;
                        }
                    };
                    break;
                }
                case MACOSX: {
                    functionProvider = new FunctionProviderGL(){
                        {
                            super(sharedLibrary);
                        }

                        @Override
                        long getExtensionAddress(long name) {
                            return 0L;
                        }
                    };
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            GL.create(functionProvider);
        }
        catch (RuntimeException e) {
            OPENGL.release();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GL.functionProvider != null) {
            throw new IllegalStateException("OpenGL has already been created.");
        }
        GL.functionProvider = functionProvider;
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProvider getFunctionProvider() {
        return functionProvider;
    }

    public static void setCapabilities(GLCapabilities caps) {
        capsTL.set(caps);
    }

    public static GLCapabilities getCapabilities() {
        GLCapabilities caps = capsTL.get();
        if (caps == null) {
            throw new IllegalStateException("No GLCapabilities instance has been set for the current thread.");
        }
        return caps;
    }

    public static GLCapabilities createCapabilities() {
        return GL.createCapabilities(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GLCapabilities createCapabilities(boolean forwardCompatible) {
        GLCapabilities gLCapabilities;
        GLCapabilities caps = null;
        try {
            int minorVersion;
            int majorVersion;
            long GetError = functionProvider.getFunctionAddress("glGetError");
            long GetString = functionProvider.getFunctionAddress("glGetString");
            long GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
            if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
                throw new IllegalStateException("Core OpenGL functions could not be found. Make sure that the OpenGL library has been loaded correctly.");
            }
            int errorCode = JNI.callI(GetError);
            if (errorCode != 0) {
                APIUtil.apiLog("An OpenGL context was in an error state before the creation of its capabilities instance. Error: " + GLUtil.getErrorString(errorCode));
            }
            APIBuffer __buffer = APIUtil.apiBuffer();
            __buffer.intParam(0, 0, 0);
            JNI.callIPV(GetIntegerv, 33307, __buffer.address());
            if (JNI.callI(GetError) == 0 && 3 <= (majorVersion = __buffer.intValue(0))) {
                JNI.callIPV(GetIntegerv, 33308, __buffer.address());
                minorVersion = __buffer.intValue(0);
            } else {
                long versionString = JNI.callIP(GetString, 7938);
                if (JNI.callI(GetError) != 0) {
                    throw new IllegalStateException("There is no OpenGL context current in the current thread.");
                }
                APIUtil.APIVersion version = APIUtil.apiParseVersion(MemoryUtil.memDecodeUTF8(versionString));
                majorVersion = version.major;
                minorVersion = version.minor;
            }
            if (majorVersion < 1 || majorVersion == 1 && minorVersion < 1) {
                throw new IllegalStateException("OpenGL 1.1 is required.");
            }
            int[] GL_VERSIONS = new int[]{5, 1, 3, 5};
            HashSet<String> supportedExtensions = new HashSet<String>(512);
            int maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
            if (MAX_VERSION != null) {
                maxMajor = Math.min(GL.MAX_VERSION.major, maxMajor);
            }
            for (int M = 1; M <= maxMajor; ++M) {
                int m;
                int maxMinor = GL_VERSIONS[M - 1];
                if (M == majorVersion) {
                    maxMinor = Math.min(minorVersion, maxMinor);
                }
                if (MAX_VERSION != null && M == GL.MAX_VERSION.major) {
                    maxMinor = Math.min(GL.MAX_VERSION.minor, maxMinor);
                }
                int n = m = M == 1 ? 1 : 0;
                while (m <= maxMinor) {
                    supportedExtensions.add(String.format("OpenGL%d%d", M, m));
                    ++m;
                }
            }
            if (majorVersion < 3) {
                String extensionsString = MemoryUtil.memDecodeASCII(Checks.checkPointer(JNI.callIP(GetString, 7939)));
                StringTokenizer tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            } else {
                JNI.callIPV(GetIntegerv, 33309, __buffer.address());
                int extensionCount = __buffer.intValue(0);
                long GetStringi = Checks.checkPointer(Checks.checkFunctionAddress(functionProvider.getFunctionAddress("glGetStringi")));
                for (int i = 0; i < extensionCount; ++i) {
                    supportedExtensions.add(MemoryUtil.memDecodeASCII(JNI.callIIP(GetStringi, 7939, i)));
                }
                JNI.callIPV(GetIntegerv, 33310, __buffer.address());
                if ((__buffer.intValue(0) & 1) != 0) {
                    forwardCompatible = true;
                } else if (3 < majorVersion || 1 <= minorVersion) {
                    if (3 < majorVersion || 2 <= minorVersion) {
                        JNI.callIPV(GetIntegerv, 37158, __buffer.address());
                        if ((__buffer.intValue(0) & 1) != 0) {
                            forwardCompatible = true;
                        }
                    } else {
                        forwardCompatible = !supportedExtensions.contains("GL_ARB_compatibility");
                    }
                }
            }
            switch (Platform.get()) {
                case WINDOWS: {
                    supportedExtensions.add("WGL");
                    GL.addWGLExtensions(supportedExtensions);
                    break;
                }
                case LINUX: {
                    supportedExtensions.add("GLX");
                    GL.addGLXExtensions(supportedExtensions);
                    break;
                }
                case MACOSX: {
                    supportedExtensions.add("CGL");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            gLCapabilities = caps = new GLCapabilities(GL.getFunctionProvider(), supportedExtensions, forwardCompatible);
        }
        catch (Throwable throwable) {
            GL.setCapabilities(caps);
            throw throwable;
        }
        GL.setCapabilities(caps);
        return gLCapabilities;
    }

    private static void addWGLExtensions(Set<String> supportedExtensions) {
        String wglExtensions;
        long wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringARB");
        if (wglGetExtensionsString != 0L) {
            long dc = JNI.callP(functionProvider.getFunctionAddress("wglGetCurrentDC"));
            if (dc == 0L) {
                throw new IllegalStateException("Failed to retrieve the device context of the current thread.");
            }
            wglExtensions = MemoryUtil.memDecodeASCII(JNI.callPP(wglGetExtensionsString, dc));
        } else {
            wglGetExtensionsString = functionProvider.getFunctionAddress("wglGetExtensionsStringEXT");
            if (wglGetExtensionsString == 0L) {
                return;
            }
            wglExtensions = MemoryUtil.memDecodeASCII(JNI.callP(wglGetExtensionsString));
        }
        StringTokenizer tokenizer = new StringTokenizer(wglExtensions);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    private static void addGLXExtensions(Set<String> supportedExtensions) {
        long glXGetCurrentDisplay = GL.getFunctionProvider().getFunctionAddress("glXGetCurrentDisplay");
        if (glXGetCurrentDisplay == 0L) {
            throw new OpenGLException("Failed to retrieve glXGetCurrentDisplay function address.");
        }
        long display = JNI.callP(glXGetCurrentDisplay);
        APIBuffer __buffer = APIUtil.apiBuffer();
        long glXQueryVersion = functionProvider.getFunctionAddress("glXQueryVersion");
        if (JNI.callPPPI(glXQueryVersion, display, __buffer.address(), __buffer.address(4)) == 0) {
            throw new OpenGLException("GLX is not available.");
        }
        int majorVersion = __buffer.intValue(0);
        int minorVersion = __buffer.intValue(4);
        if (majorVersion != 1) {
            throw new OpenGLException("Invalid GLX major version: " + majorVersion);
        }
        int[][] GLX_VERSIONS = new int[][]{{1, 2, 3, 4}};
        for (int major = 1; major <= GLX_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = GLX_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("GLX" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        long glXQueryExtensionsString = functionProvider.getFunctionAddress("glXQueryExtensionsString");
        if (glXQueryExtensionsString == 0L) {
            return;
        }
        String glxExtensions = MemoryUtil.memDecodeASCII(JNI.callPIP(glXQueryExtensionsString, display, 0));
        StringTokenizer tokenizer = new StringTokenizer(glxExtensions);
        while (tokenizer.hasMoreTokens()) {
            supportedExtensions.add(tokenizer.nextToken());
        }
    }

    static long getFunctionAddress(FunctionProvider provider, String functionName, boolean fc) {
        return fc ? 0L : provider.getFunctionAddress(functionName);
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        APIUtil.apiLog("[GL] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        if (!((Boolean)Configuration.EXPLICIT_INIT_OPENGL.get()).booleanValue()) {
            GL.create();
        }
    }
}

