/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTTransformFeedback {
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_EXT = 35982;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_START_EXT = 35972;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_EXT = 35973;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_EXT = 35983;
    public static final int GL_INTERLEAVED_ATTRIBS_EXT = 35980;
    public static final int GL_SEPARATE_ATTRIBS_EXT = 35981;
    public static final int GL_PRIMITIVES_GENERATED_EXT = 35975;
    public static final int GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_EXT = 35976;
    public static final int GL_RASTERIZER_DISCARD_EXT = 35977;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_EXT = 35978;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_EXT = 35979;
    public static final int GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_EXT = 35968;
    public static final int GL_TRANSFORM_FEEDBACK_VARYINGS_EXT = 35971;
    public static final int GL_TRANSFORM_FEEDBACK_BUFFER_MODE_EXT = 35967;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING_MAX_LENGTH_EXT = 35958;
    public final long BindBufferRangeEXT;
    public final long BindBufferOffsetEXT;
    public final long BindBufferBaseEXT;
    public final long BeginTransformFeedbackEXT;
    public final long EndTransformFeedbackEXT;
    public final long TransformFeedbackVaryingsEXT;
    public final long GetTransformFeedbackVaryingEXT;
    public final long GetIntegerIndexedvEXT;
    public final long GetBooleanIndexedvEXT;

    protected EXTTransformFeedback() {
        throw new UnsupportedOperationException();
    }

    public EXTTransformFeedback(FunctionProvider provider) {
        this.BindBufferRangeEXT = provider.getFunctionAddress("glBindBufferRangeEXT");
        this.BindBufferOffsetEXT = provider.getFunctionAddress("glBindBufferOffsetEXT");
        this.BindBufferBaseEXT = provider.getFunctionAddress("glBindBufferBaseEXT");
        this.BeginTransformFeedbackEXT = provider.getFunctionAddress("glBeginTransformFeedbackEXT");
        this.EndTransformFeedbackEXT = provider.getFunctionAddress("glEndTransformFeedbackEXT");
        this.TransformFeedbackVaryingsEXT = provider.getFunctionAddress("glTransformFeedbackVaryingsEXT");
        this.GetTransformFeedbackVaryingEXT = provider.getFunctionAddress("glGetTransformFeedbackVaryingEXT");
        this.GetIntegerIndexedvEXT = provider.getFunctionAddress("glGetIntegerIndexedvEXT");
        this.GetBooleanIndexedvEXT = provider.getFunctionAddress("glGetBooleanIndexedvEXT");
    }

    public static EXTTransformFeedback getInstance() {
        return EXTTransformFeedback.getInstance(GL.getCapabilities());
    }

    public static EXTTransformFeedback getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTTransformFeedback);
    }

    static EXTTransformFeedback create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_transform_feedback")) {
            return null;
        }
        EXTTransformFeedback funcs = new EXTTransformFeedback(provider);
        boolean supported = Checks.checkFunctions(funcs.BindBufferRangeEXT, funcs.BindBufferOffsetEXT, funcs.BindBufferBaseEXT, funcs.BeginTransformFeedbackEXT, funcs.EndTransformFeedbackEXT, funcs.TransformFeedbackVaryingsEXT, funcs.GetTransformFeedbackVaryingEXT, funcs.GetIntegerIndexedvEXT, funcs.GetBooleanIndexedvEXT);
        return GL.checkExtension("GL_EXT_transform_feedback", funcs, supported);
    }

    public static void glBindBufferRangeEXT(int target, int index, int buffer, long offset, long size) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferRangeEXT;
        JNI.callIIIPPV(__functionAddress, target, index, buffer, offset, size);
    }

    public static void glBindBufferOffsetEXT(int target, int index, int buffer, long offset) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferOffsetEXT;
        JNI.callIIIPV(__functionAddress, target, index, buffer, offset);
    }

    public static void glBindBufferBaseEXT(int target, int index, int buffer) {
        long __functionAddress = EXTTransformFeedback.getInstance().BindBufferBaseEXT;
        JNI.callIIIV(__functionAddress, target, index, buffer);
    }

    public static void glBeginTransformFeedbackEXT(int primitiveMode) {
        long __functionAddress = EXTTransformFeedback.getInstance().BeginTransformFeedbackEXT;
        JNI.callIV(__functionAddress, primitiveMode);
    }

    public static void glEndTransformFeedbackEXT() {
        long __functionAddress = EXTTransformFeedback.getInstance().EndTransformFeedbackEXT;
        JNI.callV(__functionAddress);
    }

    public static void nglTransformFeedbackVaryingsEXT(int program, int count, long varyings, int bufferMode) {
        long __functionAddress = EXTTransformFeedback.getInstance().TransformFeedbackVaryingsEXT;
        JNI.callIIPIV(__functionAddress, program, count, varyings, bufferMode);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, int count, ByteBuffer varyings, int bufferMode) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)varyings, count << Pointer.POINTER_SHIFT);
        }
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, count, MemoryUtil.memAddress(varyings), bufferMode);
    }

    public static void glTransformFeedbackVaryingsEXT(int program, PointerBuffer varyings, int bufferMode) {
        EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, varyings.remaining(), MemoryUtil.memAddress(varyings), bufferMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryingsEXT(int program, CharSequence[] varyings, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int varyingsAddress = __buffer.pointerArrayParamASCII(varyings);
        try {
            EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, varyings.length, __buffer.address(varyingsAddress), bufferMode);
        }
        finally {
            __buffer.pointerArrayFree(varyingsAddress, varyings.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glTransformFeedbackVaryingsEXT(int program, CharSequence varying, int bufferMode) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int varyingsAddress = __buffer.pointerArrayParamASCII(varying);
        try {
            EXTTransformFeedback.nglTransformFeedbackVaryingsEXT(program, 1, __buffer.address(varyingsAddress), bufferMode);
        }
        finally {
            __buffer.pointerArrayFree(varyingsAddress, 1);
        }
    }

    public static void nglGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, long length, long size, long type, long name) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetTransformFeedbackVaryingEXT;
        JNI.callIIIPPPPV(__functionAddress, program, index, bufSize, length, size, type, name);
    }

    public static void glGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, ByteBuffer length, ByteBuffer size, ByteBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
            Checks.checkBuffer((Buffer)size, 4);
            Checks.checkBuffer((Buffer)type, 4);
        }
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static void glGetTransformFeedbackVaryingEXT(int program, int index, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        if (Checks.CHECKS) {
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 1);
            }
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), MemoryUtil.memAddress(name));
    }

    public static String glGetTransformFeedbackVaryingEXT(int program, int index, int bufSize, IntBuffer size, IntBuffer type) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetTransformFeedbackVaryingEXT(int program, int index, IntBuffer size, IntBuffer type) {
        int bufSize;
        int n = bufSize = GL.getCapabilities().OpenGL20 ? GL20.glGetProgrami(program, 35958) : ARBShaderObjects.glGetObjectParameteriARB(program, 35958);
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)size, 1);
            Checks.checkBuffer((Buffer)type, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        EXTTransformFeedback.nglGetTransformFeedbackVaryingEXT(program, index, bufSize, __buffer.address(length), MemoryUtil.memAddress(size), MemoryUtil.memAddress(type), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetIntegerIndexedvEXT(int param, int index, long values) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetIntegerIndexedvEXT;
        JNI.callIIPV(__functionAddress, param, index, values);
    }

    public static void glGetIntegerIndexedvEXT(int param, int index, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 4);
        }
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static void glGetIntegerIndexedvEXT(int param, int index, IntBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static int glGetIntegerIndexedEXT(int param, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.intParam();
        EXTTransformFeedback.nglGetIntegerIndexedvEXT(param, index, __buffer.address(values));
        return __buffer.intValue(values);
    }

    public static void nglGetBooleanIndexedvEXT(int param, int index, long values) {
        long __functionAddress = EXTTransformFeedback.getInstance().GetBooleanIndexedvEXT;
        JNI.callIIPV(__functionAddress, param, index, values);
    }

    public static void glGetBooleanIndexedvEXT(int param, int index, ByteBuffer values) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)values, 1);
        }
        EXTTransformFeedback.nglGetBooleanIndexedvEXT(param, index, MemoryUtil.memAddress(values));
    }

    public static boolean glGetBooleanIndexedEXT(int param, int index) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int values = __buffer.booleanParam();
        EXTTransformFeedback.nglGetBooleanIndexedvEXT(param, index, __buffer.address(values));
        return __buffer.booleanValue(values);
    }
}

