/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_ACTIVE_PROGRAM_EXT = 35725;
    public final long UseShaderProgramEXT;
    public final long ActiveProgramEXT;
    public final long CreateShaderProgramEXT;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    public EXTSeparateShaderObjects(FunctionProvider provider) {
        this.UseShaderProgramEXT = provider.getFunctionAddress("glUseShaderProgramEXT");
        this.ActiveProgramEXT = provider.getFunctionAddress("glActiveProgramEXT");
        this.CreateShaderProgramEXT = provider.getFunctionAddress("glCreateShaderProgramEXT");
    }

    public static EXTSeparateShaderObjects getInstance() {
        return EXTSeparateShaderObjects.getInstance(GL.getCapabilities());
    }

    public static EXTSeparateShaderObjects getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTSeparateShaderObjects);
    }

    static EXTSeparateShaderObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_separate_shader_objects")) {
            return null;
        }
        EXTSeparateShaderObjects funcs = new EXTSeparateShaderObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.UseShaderProgramEXT, funcs.ActiveProgramEXT, funcs.CreateShaderProgramEXT);
        return GL.checkExtension("GL_EXT_separate_shader_objects", funcs, supported);
    }

    public static void glUseShaderProgramEXT(int type, int program) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().UseShaderProgramEXT;
        JNI.callIIV(__functionAddress, type, program);
    }

    public static void glActiveProgramEXT(int program) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().ActiveProgramEXT;
        JNI.callIV(__functionAddress, program);
    }

    public static int nglCreateShaderProgramEXT(int type, long string) {
        long __functionAddress = EXTSeparateShaderObjects.getInstance().CreateShaderProgramEXT;
        return JNI.callIPI(__functionAddress, type, string);
    }

    public static int glCreateShaderProgramEXT(int type, ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1(string);
        }
        return EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, MemoryUtil.memAddress(string));
    }

    public static int glCreateShaderProgramEXT(int type, CharSequence string) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int stringEncoded = __buffer.stringParamUTF8(string, true);
        return EXTSeparateShaderObjects.nglCreateShaderProgramEXT(type, __buffer.address(stringEncoded));
    }
}

