/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class EXTGPUProgramParameters {
    public final long ProgramEnvParameters4fvEXT;
    public final long ProgramLocalParameters4fvEXT;

    protected EXTGPUProgramParameters() {
        throw new UnsupportedOperationException();
    }

    public EXTGPUProgramParameters(FunctionProvider provider) {
        this.ProgramEnvParameters4fvEXT = provider.getFunctionAddress("glProgramEnvParameters4fvEXT");
        this.ProgramLocalParameters4fvEXT = provider.getFunctionAddress("glProgramLocalParameters4fvEXT");
    }

    public static EXTGPUProgramParameters getInstance() {
        return EXTGPUProgramParameters.getInstance(GL.getCapabilities());
    }

    public static EXTGPUProgramParameters getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTGPUProgramParameters);
    }

    static EXTGPUProgramParameters create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_EXT_gpu_program_parameters")) {
            return null;
        }
        EXTGPUProgramParameters funcs = new EXTGPUProgramParameters(provider);
        boolean supported = Checks.checkFunctions(funcs.ProgramEnvParameters4fvEXT, funcs.ProgramLocalParameters4fvEXT);
        return GL.checkExtension("GL_EXT_gpu_program_parameters", funcs, supported);
    }

    public static void nglProgramEnvParameters4fvEXT(int target, int index, int count, long params) {
        long __functionAddress = EXTGPUProgramParameters.getInstance().ProgramEnvParameters4fvEXT;
        JNI.callIIIPV(__functionAddress, target, index, count, params);
    }

    public static void glProgramEnvParameters4fvEXT(int target, int index, int count, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, count << 2 << 2);
        }
        EXTGPUProgramParameters.nglProgramEnvParameters4fvEXT(target, index, count, MemoryUtil.memAddress(params));
    }

    public static void glProgramEnvParameters4fvEXT(int target, int index, FloatBuffer params) {
        EXTGPUProgramParameters.nglProgramEnvParameters4fvEXT(target, index, params.remaining() >> 2, MemoryUtil.memAddress(params));
    }

    public static void nglProgramLocalParameters4fvEXT(int target, int index, int count, long params) {
        long __functionAddress = EXTGPUProgramParameters.getInstance().ProgramLocalParameters4fvEXT;
        JNI.callIIIPV(__functionAddress, target, index, count, params);
    }

    public static void glProgramLocalParameters4fvEXT(int target, int index, int count, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, count << 2 << 2);
        }
        EXTGPUProgramParameters.nglProgramLocalParameters4fvEXT(target, index, count, MemoryUtil.memAddress(params));
    }

    public static void glProgramLocalParameters4fvEXT(int target, int index, FloatBuffer params) {
        EXTGPUProgramParameters.nglProgramLocalParameters4fvEXT(target, index, params.remaining() >> 2, MemoryUtil.memAddress(params));
    }
}

