/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class ARBTextureStorage {
    public static final int GL_TEXTURE_IMMUTABLE_FORMAT = 37167;
    public final long TexStorage1D;
    public final long TexStorage2D;
    public final long TexStorage3D;
    public final long TextureStorage1DEXT;
    public final long TextureStorage2DEXT;
    public final long TextureStorage3DEXT;

    protected ARBTextureStorage() {
        throw new UnsupportedOperationException();
    }

    public ARBTextureStorage(FunctionProvider provider) {
        this.TexStorage1D = provider.getFunctionAddress("glTexStorage1D");
        this.TexStorage2D = provider.getFunctionAddress("glTexStorage2D");
        this.TexStorage3D = provider.getFunctionAddress("glTexStorage3D");
        this.TextureStorage1DEXT = provider.getFunctionAddress("glTextureStorage1DEXT");
        this.TextureStorage2DEXT = provider.getFunctionAddress("glTextureStorage2DEXT");
        this.TextureStorage3DEXT = provider.getFunctionAddress("glTextureStorage3DEXT");
    }

    public static ARBTextureStorage getInstance() {
        return ARBTextureStorage.getInstance(GL.getCapabilities());
    }

    public static ARBTextureStorage getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBTextureStorage);
    }

    static ARBTextureStorage create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_texture_storage")) {
            return null;
        }
        ARBTextureStorage funcs = new ARBTextureStorage(provider);
        boolean supported = Checks.checkFunctions(funcs.TexStorage1D, funcs.TexStorage2D, funcs.TexStorage3D, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage1DEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage2DEXT : -1L, ext.contains("GL_EXT_direct_state_access") ? funcs.TextureStorage3DEXT : -1L);
        return GL.checkExtension("GL_ARB_texture_storage", funcs, supported);
    }

    public static void glTexStorage1D(int target, int levels, int internalformat, int width) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage1D;
        JNI.callIIIIV(__functionAddress, target, levels, internalformat, width);
    }

    public static void glTexStorage2D(int target, int levels, int internalformat, int width, int height) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage2D;
        JNI.callIIIIIV(__functionAddress, target, levels, internalformat, width, height);
    }

    public static void glTexStorage3D(int target, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = ARBTextureStorage.getInstance().TexStorage3D;
        JNI.callIIIIIIV(__functionAddress, target, levels, internalformat, width, height, depth);
    }

    public static void glTextureStorage1DEXT(int texture, int target, int levels, int internalformat, int width) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage1DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIV(__functionAddress, texture, target, levels, internalformat, width);
    }

    public static void glTextureStorage2DEXT(int texture, int target, int levels, int internalformat, int width, int height) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage2DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIV(__functionAddress, texture, target, levels, internalformat, width, height);
    }

    public static void glTextureStorage3DEXT(int texture, int target, int levels, int internalformat, int width, int height, int depth) {
        long __functionAddress = ARBTextureStorage.getInstance().TextureStorage3DEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callIIIIIIIV(__functionAddress, texture, target, levels, internalformat, width, height, depth);
    }
}

