/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBSamplerObjects {
    public static final int GL_SAMPLER_BINDING = 35097;
    public final long GenSamplers;
    public final long DeleteSamplers;
    public final long IsSampler;
    public final long BindSampler;
    public final long SamplerParameteri;
    public final long SamplerParameterf;
    public final long SamplerParameteriv;
    public final long SamplerParameterfv;
    public final long SamplerParameterIiv;
    public final long SamplerParameterIuiv;
    public final long GetSamplerParameteriv;
    public final long GetSamplerParameterfv;
    public final long GetSamplerParameterIiv;
    public final long GetSamplerParameterIuiv;

    protected ARBSamplerObjects() {
        throw new UnsupportedOperationException();
    }

    public ARBSamplerObjects(FunctionProvider provider) {
        this.GenSamplers = provider.getFunctionAddress("glGenSamplers");
        this.DeleteSamplers = provider.getFunctionAddress("glDeleteSamplers");
        this.IsSampler = provider.getFunctionAddress("glIsSampler");
        this.BindSampler = provider.getFunctionAddress("glBindSampler");
        this.SamplerParameteri = provider.getFunctionAddress("glSamplerParameteri");
        this.SamplerParameterf = provider.getFunctionAddress("glSamplerParameterf");
        this.SamplerParameteriv = provider.getFunctionAddress("glSamplerParameteriv");
        this.SamplerParameterfv = provider.getFunctionAddress("glSamplerParameterfv");
        this.SamplerParameterIiv = provider.getFunctionAddress("glSamplerParameterIiv");
        this.SamplerParameterIuiv = provider.getFunctionAddress("glSamplerParameterIuiv");
        this.GetSamplerParameteriv = provider.getFunctionAddress("glGetSamplerParameteriv");
        this.GetSamplerParameterfv = provider.getFunctionAddress("glGetSamplerParameterfv");
        this.GetSamplerParameterIiv = provider.getFunctionAddress("glGetSamplerParameterIiv");
        this.GetSamplerParameterIuiv = provider.getFunctionAddress("glGetSamplerParameterIuiv");
    }

    public static ARBSamplerObjects getInstance() {
        return ARBSamplerObjects.getInstance(GL.getCapabilities());
    }

    public static ARBSamplerObjects getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBSamplerObjects);
    }

    static ARBSamplerObjects create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_sampler_objects")) {
            return null;
        }
        ARBSamplerObjects funcs = new ARBSamplerObjects(provider);
        boolean supported = Checks.checkFunctions(funcs.GenSamplers, funcs.DeleteSamplers, funcs.IsSampler, funcs.BindSampler, funcs.SamplerParameteri, funcs.SamplerParameterf, funcs.SamplerParameteriv, funcs.SamplerParameterfv, funcs.SamplerParameterIiv, funcs.SamplerParameterIuiv, funcs.GetSamplerParameteriv, funcs.GetSamplerParameterfv, funcs.GetSamplerParameterIiv, funcs.GetSamplerParameterIuiv);
        return GL.checkExtension("GL_ARB_sampler_objects", funcs, supported);
    }

    public static void nglGenSamplers(int count, long samplers) {
        long __functionAddress = ARBSamplerObjects.getInstance().GenSamplers;
        JNI.callIPV(__functionAddress, count, samplers);
    }

    public static void glGenSamplers(int count, ByteBuffer samplers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        ARBSamplerObjects.nglGenSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glGenSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglGenSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static int glGenSamplers() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam();
        ARBSamplerObjects.nglGenSamplers(1, __buffer.address(samplers));
        return __buffer.intValue(samplers);
    }

    public static void nglDeleteSamplers(int count, long samplers) {
        long __functionAddress = ARBSamplerObjects.getInstance().DeleteSamplers;
        JNI.callIPV(__functionAddress, count, samplers);
    }

    public static void glDeleteSamplers(int count, ByteBuffer samplers) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)samplers, count << 2);
        }
        ARBSamplerObjects.nglDeleteSamplers(count, MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(IntBuffer samplers) {
        ARBSamplerObjects.nglDeleteSamplers(samplers.remaining(), MemoryUtil.memAddress(samplers));
    }

    public static void glDeleteSamplers(int sampler) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int samplers = __buffer.intParam(sampler);
        ARBSamplerObjects.nglDeleteSamplers(1, __buffer.address(samplers));
    }

    public static boolean glIsSampler(int sampler) {
        long __functionAddress = ARBSamplerObjects.getInstance().IsSampler;
        return JNI.callIZ(__functionAddress, sampler);
    }

    public static void glBindSampler(int unit, int sampler) {
        long __functionAddress = ARBSamplerObjects.getInstance().BindSampler;
        JNI.callIIV(__functionAddress, unit, sampler);
    }

    public static void glSamplerParameteri(int sampler, int pname, int param) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameteri;
        JNI.callIIIV(__functionAddress, sampler, pname, param);
    }

    public static void glSamplerParameterf(int sampler, int pname, float param) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterf;
        JNI.callIIFV(__functionAddress, sampler, pname, param);
    }

    public static void nglSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameteriv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameteriv(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterfv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterfv(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        ARBSamplerObjects.nglSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterIiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIiv(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().SamplerParameterIuiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, ByteBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        ARBSamplerObjects.nglSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void nglGetSamplerParameteriv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameteriv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameteriv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameteri(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameteriv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterfv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterfv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterfv(int sampler, int pname, FloatBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static float glGetSamplerParameterf(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.floatParam();
        ARBSamplerObjects.nglGetSamplerParameterfv(sampler, pname, __buffer.address(params));
        return __buffer.floatValue(params);
    }

    public static void nglGetSamplerParameterIiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterIiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterIiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIi(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameterIiv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static void nglGetSamplerParameterIuiv(int sampler, int pname, long params) {
        long __functionAddress = ARBSamplerObjects.getInstance().GetSamplerParameterIuiv;
        JNI.callIIPV(__functionAddress, sampler, pname, params);
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetSamplerParameterIuiv(int sampler, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetSamplerParameterIui(int sampler, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBSamplerObjects.nglGetSamplerParameterIuiv(sampler, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }
}

