/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBProgramInterfaceQuery {
    public static final int GL_UNIFORM = 37601;
    public static final int GL_UNIFORM_BLOCK = 37602;
    public static final int GL_PROGRAM_INPUT = 37603;
    public static final int GL_PROGRAM_OUTPUT = 37604;
    public static final int GL_BUFFER_VARIABLE = 37605;
    public static final int GL_SHADER_STORAGE_BLOCK = 37606;
    public static final int GL_VERTEX_SUBROUTINE = 37608;
    public static final int GL_TESS_CONTROL_SUBROUTINE = 37609;
    public static final int GL_TESS_EVALUATION_SUBROUTINE = 37610;
    public static final int GL_GEOMETRY_SUBROUTINE = 37611;
    public static final int GL_FRAGMENT_SUBROUTINE = 37612;
    public static final int GL_COMPUTE_SUBROUTINE = 37613;
    public static final int GL_VERTEX_SUBROUTINE_UNIFORM = 37614;
    public static final int GL_TESS_CONTROL_SUBROUTINE_UNIFORM = 37615;
    public static final int GL_TESS_EVALUATION_SUBROUTINE_UNIFORM = 37616;
    public static final int GL_GEOMETRY_SUBROUTINE_UNIFORM = 37617;
    public static final int GL_FRAGMENT_SUBROUTINE_UNIFORM = 37618;
    public static final int GL_COMPUTE_SUBROUTINE_UNIFORM = 37619;
    public static final int GL_TRANSFORM_FEEDBACK_VARYING = 37620;
    public static final int GL_ACTIVE_RESOURCES = 37621;
    public static final int GL_MAX_NAME_LENGTH = 37622;
    public static final int GL_MAX_NUM_ACTIVE_VARIABLES = 37623;
    public static final int GL_MAX_NUM_COMPATIBLE_SUBROUTINES = 37624;
    public static final int GL_NAME_LENGTH = 37625;
    public static final int GL_TYPE = 37626;
    public static final int GL_ARRAY_SIZE = 37627;
    public static final int GL_OFFSET = 37628;
    public static final int GL_BLOCK_INDEX = 37629;
    public static final int GL_ARRAY_STRIDE = 37630;
    public static final int GL_MATRIX_STRIDE = 37631;
    public static final int GL_IS_ROW_MAJOR = 37632;
    public static final int GL_ATOMIC_COUNTER_BUFFER_INDEX = 37633;
    public static final int GL_BUFFER_BINDING = 37634;
    public static final int GL_BUFFER_DATA_SIZE = 37635;
    public static final int GL_NUM_ACTIVE_VARIABLES = 37636;
    public static final int GL_ACTIVE_VARIABLES = 37637;
    public static final int GL_REFERENCED_BY_VERTEX_SHADER = 37638;
    public static final int GL_REFERENCED_BY_TESS_CONTROL_SHADER = 37639;
    public static final int GL_REFERENCED_BY_TESS_EVALUATION_SHADER = 37640;
    public static final int GL_REFERENCED_BY_GEOMETRY_SHADER = 37641;
    public static final int GL_REFERENCED_BY_FRAGMENT_SHADER = 37642;
    public static final int GL_REFERENCED_BY_COMPUTE_SHADER = 37643;
    public static final int GL_TOP_LEVEL_ARRAY_SIZE = 37644;
    public static final int GL_TOP_LEVEL_ARRAY_STRIDE = 37645;
    public static final int GL_LOCATION = 37646;
    public static final int GL_LOCATION_INDEX = 37647;
    public static final int GL_IS_PER_PATCH = 37607;
    public final long GetProgramInterfaceiv;
    public final long GetProgramResourceIndex;
    public final long GetProgramResourceName;
    public final long GetProgramResourceiv;
    public final long GetProgramResourceLocation;
    public final long GetProgramResourceLocationIndex;

    protected ARBProgramInterfaceQuery() {
        throw new UnsupportedOperationException();
    }

    public ARBProgramInterfaceQuery(FunctionProvider provider) {
        this.GetProgramInterfaceiv = provider.getFunctionAddress("glGetProgramInterfaceiv");
        this.GetProgramResourceIndex = provider.getFunctionAddress("glGetProgramResourceIndex");
        this.GetProgramResourceName = provider.getFunctionAddress("glGetProgramResourceName");
        this.GetProgramResourceiv = provider.getFunctionAddress("glGetProgramResourceiv");
        this.GetProgramResourceLocation = provider.getFunctionAddress("glGetProgramResourceLocation");
        this.GetProgramResourceLocationIndex = provider.getFunctionAddress("glGetProgramResourceLocationIndex");
    }

    public static ARBProgramInterfaceQuery getInstance() {
        return ARBProgramInterfaceQuery.getInstance(GL.getCapabilities());
    }

    public static ARBProgramInterfaceQuery getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBProgramInterfaceQuery);
    }

    static ARBProgramInterfaceQuery create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_program_interface_query")) {
            return null;
        }
        ARBProgramInterfaceQuery funcs = new ARBProgramInterfaceQuery(provider);
        boolean supported = Checks.checkFunctions(funcs.GetProgramInterfaceiv, funcs.GetProgramResourceIndex, funcs.GetProgramResourceName, funcs.GetProgramResourceiv, funcs.GetProgramResourceLocation, funcs.GetProgramResourceLocationIndex);
        return GL.checkExtension("GL_ARB_program_interface_query", funcs, supported);
    }

    public static void nglGetProgramInterfaceiv(int program, int programInterface, int pname, long params) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramInterfaceiv;
        JNI.callIIIPV(__functionAddress, program, programInterface, pname, params);
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 4);
        }
        ARBProgramInterfaceQuery.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static void glGetProgramInterfaceiv(int program, int programInterface, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        ARBProgramInterfaceQuery.nglGetProgramInterfaceiv(program, programInterface, pname, MemoryUtil.memAddress(params));
    }

    public static int glGetProgramInterfacei(int program, int programInterface, int pname) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int params = __buffer.intParam();
        ARBProgramInterfaceQuery.nglGetProgramInterfaceiv(program, programInterface, pname, __buffer.address(params));
        return __buffer.intValue(params);
    }

    public static int nglGetProgramResourceIndex(int program, int programInterface, long name) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramResourceIndex;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBProgramInterfaceQuery.nglGetProgramResourceIndex(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceIndex(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamUTF8(name, true);
        return ARBProgramInterfaceQuery.nglGetProgramResourceIndex(program, programInterface, __buffer.address(nameEncoded));
    }

    public static void nglGetProgramResourceName(int program, int programInterface, int index, int bufSize, long length, long name) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramResourceName;
        JNI.callIIIIPPV(__functionAddress, program, programInterface, index, bufSize, length, name);
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, int bufSize, ByteBuffer length, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)name, bufSize);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBProgramInterfaceQuery.nglGetProgramResourceName(program, programInterface, index, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static void glGetProgramResourceName(int program, int programInterface, int index, IntBuffer length, ByteBuffer name) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBProgramInterfaceQuery.nglGetProgramResourceName(program, programInterface, index, name.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(name));
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        ARBProgramInterfaceQuery.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static String glGetProgramResourceName(int program, int programInterface, int index) {
        int bufSize = ARBProgramInterfaceQuery.glGetProgramInterfacei(program, programInterface, 37622);
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        int name = __buffer.bufferParam(bufSize);
        ARBProgramInterfaceQuery.nglGetProgramResourceName(program, programInterface, index, bufSize, __buffer.address(length), __buffer.address(name));
        return MemoryUtil.memDecodeASCII(__buffer.buffer(), __buffer.intValue(length), name);
    }

    public static void nglGetProgramResourceiv(int program, int programInterface, int index, int propCount, long props, int bufSize, long length, long params) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramResourceiv;
        JNI.callIIIIPIPPV(__functionAddress, program, programInterface, index, propCount, props, bufSize, length, params);
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, int propCount, ByteBuffer props, int bufSize, ByteBuffer length, ByteBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)props, propCount << 2);
            Checks.checkBuffer((Buffer)params, bufSize << 2);
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        ARBProgramInterfaceQuery.nglGetProgramResourceiv(program, programInterface, index, propCount, MemoryUtil.memAddress(props), bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static void glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, IntBuffer length, IntBuffer params) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        ARBProgramInterfaceQuery.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), params.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(params));
    }

    public static IntBuffer glGetProgramResourceiv(int program, int programInterface, int index, IntBuffer props, int bufSize) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int length = __buffer.intParam();
        IntBuffer params = BufferUtils.createIntBuffer(bufSize);
        ARBProgramInterfaceQuery.nglGetProgramResourceiv(program, programInterface, index, props.remaining(), MemoryUtil.memAddress(props), bufSize, __buffer.address(length), MemoryUtil.memAddress(params));
        params.limit(__buffer.intValue(length));
        return params.slice();
    }

    public static int nglGetProgramResourceLocation(int program, int programInterface, long name) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramResourceLocation;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBProgramInterfaceQuery.nglGetProgramResourceLocation(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocation(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return ARBProgramInterfaceQuery.nglGetProgramResourceLocation(program, programInterface, __buffer.address(nameEncoded));
    }

    public static int nglGetProgramResourceLocationIndex(int program, int programInterface, long name) {
        long __functionAddress = ARBProgramInterfaceQuery.getInstance().GetProgramResourceLocationIndex;
        return JNI.callIIPI(__functionAddress, program, programInterface, name);
    }

    public static int glGetProgramResourceLocationIndex(int program, int programInterface, ByteBuffer name) {
        if (Checks.CHECKS) {
            Checks.checkNT1(name);
        }
        return ARBProgramInterfaceQuery.nglGetProgramResourceLocationIndex(program, programInterface, MemoryUtil.memAddress(name));
    }

    public static int glGetProgramResourceLocationIndex(int program, int programInterface, CharSequence name) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int nameEncoded = __buffer.stringParamASCII(name, true);
        return ARBProgramInterfaceQuery.nglGetProgramResourceLocationIndex(program, programInterface, __buffer.address(nameEncoded));
    }
}

