/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class ARBDrawInstanced {
    public final long DrawArraysInstancedARB;
    public final long DrawElementsInstancedARB;

    protected ARBDrawInstanced() {
        throw new UnsupportedOperationException();
    }

    public ARBDrawInstanced(FunctionProvider provider) {
        this.DrawArraysInstancedARB = provider.getFunctionAddress("glDrawArraysInstancedARB");
        this.DrawElementsInstancedARB = provider.getFunctionAddress("glDrawElementsInstancedARB");
    }

    public static ARBDrawInstanced getInstance() {
        return ARBDrawInstanced.getInstance(GL.getCapabilities());
    }

    public static ARBDrawInstanced getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBDrawInstanced);
    }

    static ARBDrawInstanced create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_draw_instanced")) {
            return null;
        }
        ARBDrawInstanced funcs = new ARBDrawInstanced(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawArraysInstancedARB, funcs.DrawElementsInstancedARB);
        return GL.checkExtension("GL_ARB_draw_instanced", funcs, supported);
    }

    public static void glDrawArraysInstancedARB(int mode, int first, int count, int primcount) {
        long __functionAddress = ARBDrawInstanced.getInstance().DrawArraysInstancedARB;
        JNI.callIIIIV(__functionAddress, mode, first, count, primcount);
    }

    public static void nglDrawElementsInstancedARB(int mode, int count, int type, long indices, int primcount) {
        long __functionAddress = ARBDrawInstanced.getInstance().DrawElementsInstancedARB;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, int count, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, count, type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, int count, int type, long indicesOffset, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, count, type, indicesOffset, primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, int type, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, ByteBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, ShortBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount);
    }

    public static void glDrawElementsInstancedARB(int mode, IntBuffer indices, int primcount) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawInstanced.nglDrawElementsInstancedARB(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount);
    }
}

