/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import java.util.Set;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLChecks;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class ARBDrawElementsBaseVertex {
    public final long DrawElementsBaseVertex;
    public final long DrawRangeElementsBaseVertex;
    public final long DrawElementsInstancedBaseVertex;
    public final long MultiDrawElementsBaseVertex;

    protected ARBDrawElementsBaseVertex() {
        throw new UnsupportedOperationException();
    }

    public ARBDrawElementsBaseVertex(FunctionProvider provider) {
        this.DrawElementsBaseVertex = provider.getFunctionAddress("glDrawElementsBaseVertex");
        this.DrawRangeElementsBaseVertex = provider.getFunctionAddress("glDrawRangeElementsBaseVertex");
        this.DrawElementsInstancedBaseVertex = provider.getFunctionAddress("glDrawElementsInstancedBaseVertex");
        this.MultiDrawElementsBaseVertex = provider.getFunctionAddress("glMultiDrawElementsBaseVertex");
    }

    public static ARBDrawElementsBaseVertex getInstance() {
        return ARBDrawElementsBaseVertex.getInstance(GL.getCapabilities());
    }

    public static ARBDrawElementsBaseVertex getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__ARBDrawElementsBaseVertex);
    }

    static ARBDrawElementsBaseVertex create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_ARB_draw_elements_base_vertex")) {
            return null;
        }
        ARBDrawElementsBaseVertex funcs = new ARBDrawElementsBaseVertex(provider);
        boolean supported = Checks.checkFunctions(funcs.DrawElementsBaseVertex, funcs.DrawRangeElementsBaseVertex, funcs.DrawElementsInstancedBaseVertex, funcs.MultiDrawElementsBaseVertex);
        return GL.checkExtension("GL_ARB_draw_elements_base_vertex", funcs, supported);
    }

    public static void nglDrawElementsBaseVertex(int mode, int count, int type, long indices, int basevertex) {
        long __functionAddress = ARBDrawElementsBaseVertex.getInstance().DrawElementsBaseVertex;
        JNI.callIIIPIV(__functionAddress, mode, count, type, indices, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, count, type, indicesOffset, basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawElementsBaseVertex(int mode, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indices, int basevertex) {
        long __functionAddress = ARBDrawElementsBaseVertex.getInstance().DrawRangeElementsBaseVertex;
        JNI.callIIIIIPIV(__functionAddress, mode, start, end, count, type, indices, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int count, int type, long indicesOffset, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, count, type, indicesOffset, basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, int type, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ByteBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5121, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, ShortBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5123, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void glDrawRangeElementsBaseVertex(int mode, int start, int end, IntBuffer indices, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawRangeElementsBaseVertex(mode, start, end, indices.remaining(), 5125, MemoryUtil.memAddress(indices), basevertex);
    }

    public static void nglDrawElementsInstancedBaseVertex(int mode, int count, int type, long indices, int primcount, int basevertex) {
        long __functionAddress = ARBDrawElementsBaseVertex.getInstance().DrawElementsInstancedBaseVertex;
        JNI.callIIIPIIV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, ByteBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)indices, count << GLChecks.typeToByteShift(type));
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, count, type, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int count, int type, long indicesOffset, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, true);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, count, type, indicesOffset, primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, int type, ByteBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, indices.remaining() >> GLChecks.typeToByteShift(type), type, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ByteBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5121, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, ShortBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5123, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void glDrawElementsInstancedBaseVertex(int mode, IntBuffer indices, int primcount, int basevertex) {
        if (Checks.CHECKS) {
            GLChecks.ensureBufferObject(34965, false);
        }
        ARBDrawElementsBaseVertex.nglDrawElementsInstancedBaseVertex(mode, indices.remaining(), 5125, MemoryUtil.memAddress(indices), primcount, basevertex);
    }

    public static void nglMultiDrawElementsBaseVertex(int mode, long count, int type, long indices, int primcount, long basevertex) {
        long __functionAddress = ARBDrawElementsBaseVertex.getInstance().MultiDrawElementsBaseVertex;
        JNI.callIPIPIPV(__functionAddress, mode, count, type, indices, primcount, basevertex);
    }

    public static void glMultiDrawElementsBaseVertex(int mode, ByteBuffer count, int type, ByteBuffer indices, int primcount, ByteBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)count, primcount << 2);
            Checks.checkBuffer((Buffer)indices, primcount << Pointer.POINTER_SHIFT);
            Checks.checkBuffer((Buffer)basevertex, primcount << 2);
        }
        ARBDrawElementsBaseVertex.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), primcount, MemoryUtil.memAddress(basevertex));
    }

    public static void glMultiDrawElementsBaseVertex(int mode, IntBuffer count, int type, PointerBuffer indices, IntBuffer basevertex) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(indices, count.remaining());
            Checks.checkBuffer((Buffer)basevertex, count.remaining());
        }
        ARBDrawElementsBaseVertex.nglMultiDrawElementsBaseVertex(mode, MemoryUtil.memAddress(count), type, MemoryUtil.memAddress(indices), count.remaining(), MemoryUtil.memAddress(basevertex));
    }
}

