/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class AMDPerformanceMonitor {
    public static final int GL_COUNTER_TYPE_AMD = 35776;
    public static final int GL_COUNTER_RANGE_AMD = 35777;
    public static final int GL_UNSIGNED_INT64_AMD = 35778;
    public static final int GL_PERCENTAGE_AMD = 35779;
    public static final int GL_PERFMON_RESULT_AVAILABLE_AMD = 35780;
    public static final int GL_PERFMON_RESULT_SIZE_AMD = 35781;
    public static final int GL_PERFMON_RESULT_AMD = 35782;
    public final long GetPerfMonitorGroupsAMD;
    public final long GetPerfMonitorCountersAMD;
    public final long GetPerfMonitorGroupStringAMD;
    public final long GetPerfMonitorCounterStringAMD;
    public final long GetPerfMonitorCounterInfoAMD;
    public final long GenPerfMonitorsAMD;
    public final long DeletePerfMonitorsAMD;
    public final long SelectPerfMonitorCountersAMD;
    public final long BeginPerfMonitorAMD;
    public final long EndPerfMonitorAMD;
    public final long GetPerfMonitorCounterDataAMD;

    protected AMDPerformanceMonitor() {
        throw new UnsupportedOperationException();
    }

    public AMDPerformanceMonitor(FunctionProvider provider) {
        this.GetPerfMonitorGroupsAMD = provider.getFunctionAddress("glGetPerfMonitorGroupsAMD");
        this.GetPerfMonitorCountersAMD = provider.getFunctionAddress("glGetPerfMonitorCountersAMD");
        this.GetPerfMonitorGroupStringAMD = provider.getFunctionAddress("glGetPerfMonitorGroupStringAMD");
        this.GetPerfMonitorCounterStringAMD = provider.getFunctionAddress("glGetPerfMonitorCounterStringAMD");
        this.GetPerfMonitorCounterInfoAMD = provider.getFunctionAddress("glGetPerfMonitorCounterInfoAMD");
        this.GenPerfMonitorsAMD = provider.getFunctionAddress("glGenPerfMonitorsAMD");
        this.DeletePerfMonitorsAMD = provider.getFunctionAddress("glDeletePerfMonitorsAMD");
        this.SelectPerfMonitorCountersAMD = provider.getFunctionAddress("glSelectPerfMonitorCountersAMD");
        this.BeginPerfMonitorAMD = provider.getFunctionAddress("glBeginPerfMonitorAMD");
        this.EndPerfMonitorAMD = provider.getFunctionAddress("glEndPerfMonitorAMD");
        this.GetPerfMonitorCounterDataAMD = provider.getFunctionAddress("glGetPerfMonitorCounterDataAMD");
    }

    public static AMDPerformanceMonitor getInstance() {
        return AMDPerformanceMonitor.getInstance(GL.getCapabilities());
    }

    public static AMDPerformanceMonitor getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDPerformanceMonitor);
    }

    static AMDPerformanceMonitor create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_performance_monitor")) {
            return null;
        }
        AMDPerformanceMonitor funcs = new AMDPerformanceMonitor(provider);
        boolean supported = Checks.checkFunctions(funcs.GetPerfMonitorGroupsAMD, funcs.GetPerfMonitorCountersAMD, funcs.GetPerfMonitorGroupStringAMD, funcs.GetPerfMonitorCounterStringAMD, funcs.GetPerfMonitorCounterInfoAMD, funcs.GenPerfMonitorsAMD, funcs.DeletePerfMonitorsAMD, funcs.SelectPerfMonitorCountersAMD, funcs.BeginPerfMonitorAMD, funcs.EndPerfMonitorAMD, funcs.GetPerfMonitorCounterDataAMD);
        return GL.checkExtension("GL_AMD_performance_monitor", funcs, supported);
    }

    public static void nglGetPerfMonitorGroupsAMD(long numGroups, int groupsSize, long groups) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorGroupsAMD;
        JNI.callPIPV(__functionAddress, numGroups, groupsSize, groups);
    }

    public static void glGetPerfMonitorGroupsAMD(ByteBuffer numGroups, int groupsSize, ByteBuffer groups) {
        if (Checks.CHECKS) {
            if (numGroups != null) {
                Checks.checkBuffer((Buffer)numGroups, 4);
            }
            if (groups != null) {
                Checks.checkBuffer((Buffer)groups, groupsSize << 2);
            }
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.memAddressSafe(numGroups), groupsSize, MemoryUtil.memAddressSafe(groups));
    }

    public static void glGetPerfMonitorGroupsAMD(IntBuffer numGroups, IntBuffer groups) {
        if (Checks.CHECKS && numGroups != null) {
            Checks.checkBuffer((Buffer)numGroups, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupsAMD(MemoryUtil.memAddressSafe(numGroups), groups == null ? 0 : groups.remaining(), MemoryUtil.memAddressSafe(groups));
    }

    public static void nglGetPerfMonitorCountersAMD(int group, long numCounters, long maxActiveCounters, int counterSize, long counters) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorCountersAMD;
        JNI.callIPPIPV(__functionAddress, group, numCounters, maxActiveCounters, counterSize, counters);
    }

    public static void glGetPerfMonitorCountersAMD(int group, ByteBuffer numCounters, ByteBuffer maxActiveCounters, int counterSize, ByteBuffer counters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)numCounters, 4);
            Checks.checkBuffer((Buffer)maxActiveCounters, 4);
            Checks.checkBuffer((Buffer)counters, counterSize << 2);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.memAddress(numCounters), MemoryUtil.memAddress(maxActiveCounters), counterSize, MemoryUtil.memAddress(counters));
    }

    public static void glGetPerfMonitorCountersAMD(int group, IntBuffer numCounters, IntBuffer maxActiveCounters, IntBuffer counters) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)numCounters, 1);
            Checks.checkBuffer((Buffer)maxActiveCounters, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCountersAMD(group, MemoryUtil.memAddress(numCounters), MemoryUtil.memAddress(maxActiveCounters), counters.remaining(), MemoryUtil.memAddress(counters));
    }

    public static void nglGetPerfMonitorGroupStringAMD(int group, int bufSize, long length, long groupString) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorGroupStringAMD;
        JNI.callIIPPV(__functionAddress, group, bufSize, length, groupString);
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, int bufSize, ByteBuffer length, ByteBuffer groupString) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)groupString, bufSize);
            Checks.checkBuffer((Buffer)length, 4);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(groupString));
    }

    public static void glGetPerfMonitorGroupStringAMD(int group, IntBuffer length, ByteBuffer groupString) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorGroupStringAMD(group, groupString.remaining(), MemoryUtil.memAddress(length), MemoryUtil.memAddress(groupString));
    }

    public static void nglGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize, long length, long counterString) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorCounterStringAMD;
        JNI.callIIIPPV(__functionAddress, group, counter, bufSize, length, counterString);
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, int bufSize, ByteBuffer length, ByteBuffer counterString) {
        if (Checks.CHECKS) {
            if (counterString != null) {
                Checks.checkBuffer((Buffer)counterString, bufSize);
            }
            if (length != null) {
                Checks.checkBuffer((Buffer)length, 4);
            }
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, bufSize, MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(counterString));
    }

    public static void glGetPerfMonitorCounterStringAMD(int group, int counter, IntBuffer length, ByteBuffer counterString) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterStringAMD(group, counter, counterString == null ? 0 : counterString.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(counterString));
    }

    public static void nglGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, long data) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorCounterInfoAMD;
        JNI.callIIIPV(__functionAddress, group, counter, pname, data);
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, ByteBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 4);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, IntBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void glGetPerfMonitorCounterInfoAMD(int group, int counter, int pname, FloatBuffer data) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterInfoAMD(group, counter, pname, MemoryUtil.memAddress(data));
    }

    public static void nglGenPerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GenPerfMonitorsAMD;
        JNI.callIPV(__functionAddress, n, monitors);
    }

    public static void glGenPerfMonitorsAMD(int n, ByteBuffer monitors) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)monitors, n << 2);
        }
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(n, MemoryUtil.memAddress(monitors));
    }

    public static void glGenPerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress(monitors));
    }

    public static int glGenPerfMonitorsAMD() {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int monitors = __buffer.intParam();
        AMDPerformanceMonitor.nglGenPerfMonitorsAMD(1, __buffer.address(monitors));
        return __buffer.intValue(monitors);
    }

    public static void nglDeletePerfMonitorsAMD(int n, long monitors) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().DeletePerfMonitorsAMD;
        JNI.callIPV(__functionAddress, n, monitors);
    }

    public static void glDeletePerfMonitorsAMD(int n, ByteBuffer monitors) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)monitors, n << 2);
        }
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(n, MemoryUtil.memAddress(monitors));
    }

    public static void glDeletePerfMonitorsAMD(IntBuffer monitors) {
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(monitors.remaining(), MemoryUtil.memAddress(monitors));
    }

    public static void glDeletePerfMonitorsAMD(int monitor) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int monitors = __buffer.intParam(monitor);
        AMDPerformanceMonitor.nglDeletePerfMonitorsAMD(1, __buffer.address(monitors));
    }

    public static void nglSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int numCounters, long counterList) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().SelectPerfMonitorCountersAMD;
        JNI.callIZIIPV(__functionAddress, monitor, enable, group, numCounters, counterList);
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, int numCounters, ByteBuffer counterList) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)counterList, numCounters << 2);
        }
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, numCounters, MemoryUtil.memAddress(counterList));
    }

    public static void glSelectPerfMonitorCountersAMD(int monitor, boolean enable, int group, IntBuffer counterList) {
        AMDPerformanceMonitor.nglSelectPerfMonitorCountersAMD(monitor, enable, group, counterList.remaining(), MemoryUtil.memAddress(counterList));
    }

    public static void glBeginPerfMonitorAMD(int monitor) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().BeginPerfMonitorAMD;
        JNI.callIV(__functionAddress, monitor);
    }

    public static void glEndPerfMonitorAMD(int monitor) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().EndPerfMonitorAMD;
        JNI.callIV(__functionAddress, monitor);
    }

    public static void nglGetPerfMonitorCounterDataAMD(int monitor, int pname, int dataSize, long data, long bytesWritten) {
        long __functionAddress = AMDPerformanceMonitor.getInstance().GetPerfMonitorCounterDataAMD;
        JNI.callIIIPPV(__functionAddress, monitor, pname, dataSize, data, bytesWritten);
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, int dataSize, ByteBuffer data, ByteBuffer bytesWritten) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)data, dataSize << 2);
            if (bytesWritten != null) {
                Checks.checkBuffer((Buffer)bytesWritten, 4);
            }
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, dataSize, MemoryUtil.memAddress(data), MemoryUtil.memAddressSafe(bytesWritten));
    }

    public static void glGetPerfMonitorCounterDataAMD(int monitor, int pname, IntBuffer data, IntBuffer bytesWritten) {
        if (Checks.CHECKS && bytesWritten != null) {
            Checks.checkBuffer((Buffer)bytesWritten, 1);
        }
        AMDPerformanceMonitor.nglGetPerfMonitorCounterDataAMD(monitor, pname, data.remaining(), MemoryUtil.memAddress(data), MemoryUtil.memAddressSafe(bytesWritten));
    }
}

