/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Set;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.GLDebugMessageAMDCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class AMDDebugOutput {
    public static final int GL_MAX_DEBUG_MESSAGE_LENGTH_AMD = 37187;
    public static final int GL_MAX_DEBUG_LOGGED_MESSAGES_AMD = 37188;
    public static final int GL_DEBUG_LOGGED_MESSAGES_AMD = 37189;
    public static final int GL_DEBUG_SEVERITY_HIGH_AMD = 37190;
    public static final int GL_DEBUG_SEVERITY_MEDIUM_AMD = 37191;
    public static final int GL_DEBUG_SEVERITY_LOW_AMD = 37192;
    public static final int GL_DEBUG_CATEGORY_API_ERROR_AMD = 37193;
    public static final int GL_DEBUG_CATEGORY_WINDOW_SYSTEM_AMD = 37194;
    public static final int GL_DEBUG_CATEGORY_DEPRECATION_AMD = 37195;
    public static final int GL_DEBUG_CATEGORY_UNDEFINED_BEHAVIOR_AMD = 37196;
    public static final int GL_DEBUG_CATEGORY_PERFORMANCE_AMD = 37197;
    public static final int GL_DEBUG_CATEGORY_SHADER_COMPILER_AMD = 37198;
    public static final int GL_DEBUG_CATEGORY_APPLICATION_AMD = 37199;
    public static final int GL_DEBUG_CATEGORY_OTHER_AMD = 37200;
    public final long DebugMessageEnableAMD;
    public final long DebugMessageInsertAMD;
    public final long DebugMessageCallbackAMD;
    public final long GetDebugMessageLogAMD;

    protected AMDDebugOutput() {
        throw new UnsupportedOperationException();
    }

    public AMDDebugOutput(FunctionProvider provider) {
        this.DebugMessageEnableAMD = provider.getFunctionAddress("glDebugMessageEnableAMD");
        this.DebugMessageInsertAMD = provider.getFunctionAddress("glDebugMessageInsertAMD");
        this.DebugMessageCallbackAMD = provider.getFunctionAddress("glDebugMessageCallbackAMD");
        this.GetDebugMessageLogAMD = provider.getFunctionAddress("glGetDebugMessageLogAMD");
    }

    public static AMDDebugOutput getInstance() {
        return AMDDebugOutput.getInstance(GL.getCapabilities());
    }

    public static AMDDebugOutput getInstance(GLCapabilities caps) {
        return Checks.checkFunctionality(caps.__AMDDebugOutput);
    }

    static AMDDebugOutput create(Set<String> ext, FunctionProvider provider) {
        if (!ext.contains("GL_AMD_debug_output")) {
            return null;
        }
        AMDDebugOutput funcs = new AMDDebugOutput(provider);
        boolean supported = Checks.checkFunctions(funcs.DebugMessageEnableAMD, funcs.DebugMessageInsertAMD, funcs.DebugMessageCallbackAMD, funcs.GetDebugMessageLogAMD);
        return GL.checkExtension("GL_AMD_debug_output", funcs, supported);
    }

    public static void nglDebugMessageEnableAMD(int category, int severity, int count, long ids, boolean enabled) {
        long __functionAddress = AMDDebugOutput.getInstance().DebugMessageEnableAMD;
        JNI.callIIIPZV(__functionAddress, category, severity, count, ids, enabled);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, int count, ByteBuffer ids, boolean enabled) {
        if (Checks.CHECKS && ids != null) {
            Checks.checkBuffer((Buffer)ids, count << 2);
        }
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, count, MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, IntBuffer ids, boolean enabled) {
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, ids == null ? 0 : ids.remaining(), MemoryUtil.memAddressSafe(ids), enabled);
    }

    public static void glDebugMessageEnableAMD(int category, int severity, int id, boolean enabled) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int ids = __buffer.intParam(id);
        AMDDebugOutput.nglDebugMessageEnableAMD(category, severity, 1, __buffer.address(ids), enabled);
    }

    public static void nglDebugMessageInsertAMD(int category, int severity, int id, int length, long buf) {
        long __functionAddress = AMDDebugOutput.getInstance().DebugMessageInsertAMD;
        JNI.callIIIIPV(__functionAddress, category, severity, id, length, buf);
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, int length, ByteBuffer buf) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)buf, length);
        }
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, length, MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, ByteBuffer buf) {
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, buf.remaining(), MemoryUtil.memAddress(buf));
    }

    public static void glDebugMessageInsertAMD(int category, int severity, int id, CharSequence buf) {
        APIBuffer __buffer = APIUtil.apiBuffer();
        int bufEncoded = __buffer.stringParamUTF8(buf, false);
        int bufEncodedLen = __buffer.getOffset() - bufEncoded;
        AMDDebugOutput.nglDebugMessageInsertAMD(category, severity, id, bufEncodedLen, __buffer.address(bufEncoded));
    }

    public static void glDebugMessageCallbackAMD(GLDebugMessageAMDCallback callback, long userParam) {
        long __functionAddress = AMDDebugOutput.getInstance().DebugMessageCallbackAMD;
        JNI.callPPV(__functionAddress, callback == null ? 0L : callback.address(), userParam);
    }

    public static int nglGetDebugMessageLogAMD(int count, int bufsize, long categories, long severities, long ids, long lengths, long messageLog) {
        long __functionAddress = AMDDebugOutput.getInstance().GetDebugMessageLogAMD;
        return JNI.callIIPPPPPI(__functionAddress, count, bufsize, categories, severities, ids, lengths, messageLog);
    }

    public static int glGetDebugMessageLogAMD(int count, int bufsize, ByteBuffer categories, ByteBuffer severities, ByteBuffer ids, ByteBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (messageLog != null) {
                Checks.checkBuffer((Buffer)messageLog, bufsize);
            }
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count << 2);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count << 2);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count << 2);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count << 2);
            }
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, bufsize, MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }

    public static int glGetDebugMessageLogAMD(int count, IntBuffer categories, IntBuffer severities, IntBuffer ids, IntBuffer lengths, ByteBuffer messageLog) {
        if (Checks.CHECKS) {
            if (categories != null) {
                Checks.checkBuffer((Buffer)categories, count);
            }
            if (severities != null) {
                Checks.checkBuffer((Buffer)severities, count);
            }
            if (ids != null) {
                Checks.checkBuffer((Buffer)ids, count);
            }
            if (lengths != null) {
                Checks.checkBuffer((Buffer)lengths, count);
            }
        }
        return AMDDebugOutput.nglGetDebugMessageLogAMD(count, messageLog == null ? 0 : messageLog.remaining(), MemoryUtil.memAddressSafe(categories), MemoryUtil.memAddressSafe(severities), MemoryUtil.memAddressSafe(ids), MemoryUtil.memAddressSafe(lengths), MemoryUtil.memAddressSafe(messageLog));
    }
}

