/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CLBufferRegion
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int ORIGIN;
    public static final int SIZE;

    CLBufferRegion(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public CLBufferRegion(long struct) {
        this(struct, null);
    }

    public CLBufferRegion(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long origin() {
        return CLBufferRegion.norigin(this.address());
    }

    public long size() {
        return CLBufferRegion.nsize(this.address());
    }

    public CLBufferRegion origin(long value) {
        CLBufferRegion.norigin(this.address(), value);
        return this;
    }

    public CLBufferRegion size(long value) {
        CLBufferRegion.nsize(this.address(), value);
        return this;
    }

    public CLBufferRegion set(long origin, long size) {
        this.origin(origin);
        this.size(size);
        return this;
    }

    public CLBufferRegion nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public CLBufferRegion set(CLBufferRegion src) {
        return this.nset(src.address());
    }

    public CLBufferRegion set(ByteBuffer struct) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((java.nio.Buffer)struct, SIZEOF);
        }
        return this.nset(MemoryUtil.memAddress(struct));
    }

    public static CLBufferRegion malloc() {
        return new CLBufferRegion(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static CLBufferRegion calloc() {
        return new CLBufferRegion(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static CLBufferRegion create() {
        return new CLBufferRegion(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static long norigin(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)ORIGIN);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)SIZE);
    }

    public static void norigin(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)ORIGIN, value);
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)SIZE, value);
    }

    static {
        Struct.Layout layout = CLBufferRegion.__struct(CLBufferRegion.__member(Pointer.POINTER_SIZE), CLBufferRegion.__member(Pointer.POINTER_SIZE));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        ORIGIN = layout.offsetof(0);
        SIZE = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<CLBufferRegion, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected CLBufferRegion newInstance(long address) {
            return new CLBufferRegion(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long origin() {
            return CLBufferRegion.norigin(this.address());
        }

        public long size() {
            return CLBufferRegion.nsize(this.address());
        }

        public Buffer origin(long value) {
            CLBufferRegion.norigin(this.address(), value);
            return this;
        }

        public Buffer size(long value) {
            CLBufferRegion.nsize(this.address(), value);
            return this;
        }
    }
}

