/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class CL21 {
    public static final int CL_VERSION_2_1 = 1;
    public static final int CL_PLATFORM_HOST_TIMER_RESOLUTION = 2309;
    public static final int CL_DEVICE_IL_VERSION = 4187;
    public static final int CL_DEVICE_MAX_NUM_SUB_GROUPS = 4188;
    public static final int CL_DEVICE_SUB_GROUP_INDEPENDENT_FORWARD_PROGRESS = 4189;
    public static final int CL_QUEUE_DEVICE_DEFAULT = 4245;
    public static final int CL_UNORM_INT_101010_2 = 4320;
    public static final int CL_PROGRAM_IL = 4457;
    public static final int CL_KERNEL_MAX_NUM_SUB_GROUPS = 4537;
    public static final int CL_KERNEL_COMPILE_NUM_SUB_GROUPS = 4538;
    public static final int CL_KERNEL_MAX_SUB_GROUP_SIZE_FOR_NDRANGE = 8243;
    public static final int CL_KERNEL_SUB_GROUP_COUNT_FOR_NDRANGE = 8244;
    public static final int CL_KERNEL_LOCAL_SIZE_FOR_SUB_GROUP_COUNT = 4536;
    public final long SetDefaultDeviceCommandQueue;
    public final long GetDeviceAndHostTimer;
    public final long GetHostTimer;
    public final long CreateProgramWithIL;
    public final long CloneKernel;
    public final long GetKernelSubGroupInfo;
    public final long EnqueueSVMMigrateMem;

    protected CL21() {
        throw new UnsupportedOperationException();
    }

    public CL21(FunctionProvider provider) {
        this.SetDefaultDeviceCommandQueue = provider.getFunctionAddress("clSetDefaultDeviceCommandQueue");
        this.GetDeviceAndHostTimer = provider.getFunctionAddress("clGetDeviceAndHostTimer");
        this.GetHostTimer = provider.getFunctionAddress("clGetHostTimer");
        this.CreateProgramWithIL = provider.getFunctionAddress("clCreateProgramWithIL");
        this.CloneKernel = provider.getFunctionAddress("clCloneKernel");
        this.GetKernelSubGroupInfo = provider.getFunctionAddress("clGetKernelSubGroupInfo");
        this.EnqueueSVMMigrateMem = provider.getFunctionAddress("clEnqueueSVMMigrateMem");
    }

    public static CL21 getInstance() {
        return CL21.getInstance(CL.getICD());
    }

    public static CL21 getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__CL21);
    }

    static CL21 create(FunctionProvider provider) {
        CL21 funcs = new CL21(provider);
        boolean supported = Checks.checkFunctions(funcs.SetDefaultDeviceCommandQueue, funcs.GetDeviceAndHostTimer, funcs.GetHostTimer, funcs.CreateProgramWithIL, funcs.CloneKernel, funcs.GetKernelSubGroupInfo, funcs.EnqueueSVMMigrateMem);
        return supported ? funcs : null;
    }

    public static int clSetDefaultDeviceCommandQueue(long context, long device, long command_queue) {
        long __functionAddress = CL21.getInstance().SetDefaultDeviceCommandQueue;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
            Checks.checkPointer(device);
            Checks.checkPointer(command_queue);
        }
        return JNI.callPPPI(__functionAddress, context, device, command_queue);
    }

    public static int nclGetDeviceAndHostTimer(long device, long device_timestamp, long host_timestamp) {
        long __functionAddress = CL21.getInstance().GetDeviceAndHostTimer;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPPPI(__functionAddress, device, device_timestamp, host_timestamp);
    }

    public static int clGetDeviceAndHostTimer(long device, ByteBuffer device_timestamp, ByteBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)device_timestamp, 8);
            Checks.checkBuffer((Buffer)host_timestamp, 8);
        }
        return CL21.nclGetDeviceAndHostTimer(device, MemoryUtil.memAddress(device_timestamp), MemoryUtil.memAddress(host_timestamp));
    }

    public static int clGetDeviceAndHostTimer(long device, LongBuffer device_timestamp, LongBuffer host_timestamp) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)device_timestamp, 1);
            Checks.checkBuffer((Buffer)host_timestamp, 1);
        }
        return CL21.nclGetDeviceAndHostTimer(device, MemoryUtil.memAddress(device_timestamp), MemoryUtil.memAddress(host_timestamp));
    }

    public static int nclGetHostTimer(long device, long host_timestamp) {
        long __functionAddress = CL21.getInstance().GetHostTimer;
        if (Checks.CHECKS) {
            Checks.checkPointer(device);
        }
        return JNI.callPPI(__functionAddress, device, host_timestamp);
    }

    public static int clGetHostTimer(long device, ByteBuffer host_timestamp) {
        return CL21.nclGetHostTimer(device, MemoryUtil.memAddress(host_timestamp));
    }

    public static int clGetHostTimer(long device, LongBuffer host_timestamp) {
        return CL21.nclGetHostTimer(device, MemoryUtil.memAddress(host_timestamp));
    }

    public static long nclCreateProgramWithIL(long context, long il, long length, long errcode_ret) {
        long __functionAddress = CL21.getInstance().CreateProgramWithIL;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPPPPP(__functionAddress, context, il, length, errcode_ret);
    }

    public static long clCreateProgramWithIL(long context, ByteBuffer il, long length, ByteBuffer errcode_ret) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)il, length);
            if (errcode_ret != null) {
                Checks.checkBuffer((Buffer)errcode_ret, 4);
            }
        }
        return CL21.nclCreateProgramWithIL(context, MemoryUtil.memAddress(il), length, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateProgramWithIL(long context, ByteBuffer il, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL21.nclCreateProgramWithIL(context, MemoryUtil.memAddress(il), il.remaining(), MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCloneKernel(long source_kernel, long errcode_ret) {
        long __functionAddress = CL21.getInstance().CloneKernel;
        if (Checks.CHECKS) {
            Checks.checkPointer(source_kernel);
        }
        return JNI.callPPP(__functionAddress, source_kernel, errcode_ret);
    }

    public static long clCloneKernel(long source_kernel, ByteBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL21.nclCloneKernel(source_kernel, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCloneKernel(long source_kernel, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL21.nclCloneKernel(source_kernel, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, long input_value, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL21.getInstance().GetKernelSubGroupInfo;
        if (Checks.CHECKS) {
            Checks.checkPointer(kernel);
        }
        return JNI.callPPIPPPPPI(__functionAddress, kernel, device, param_name, input_value_size, input_value, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, ByteBuffer input_value, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, MemoryUtil.memAddressSafe(input_value), param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, ByteBuffer input_value, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, MemoryUtil.memAddressSafe(input_value), param_value == null ? 0L : (long)param_value.remaining(), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetKernelSubGroupInfo(long kernel, long device, int param_name, long input_value_size, ByteBuffer input_value, PointerBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL21.nclGetKernelSubGroupInfo(kernel, device, param_name, input_value_size, MemoryUtil.memAddressSafe(input_value), param_value == null ? 0 : param_value.remaining() << Pointer.POINTER_SHIFT, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueSVMMigrateMem(long command_queue, int num_svm_pointers, long svm_pointers, long sizes, long flags, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL21.getInstance().EnqueueSVMMigrateMem;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPPJIPPI(__functionAddress, command_queue, num_svm_pointers, svm_pointers, sizes, flags, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueSVMMigrateMem(long command_queue, int num_svm_pointers, ByteBuffer svm_pointers, ByteBuffer sizes, long flags, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)svm_pointers, num_svm_pointers << Pointer.POINTER_SHIFT);
            if (sizes != null) {
                Checks.checkBuffer((Buffer)sizes, num_svm_pointers << Pointer.POINTER_SHIFT);
            }
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL21.nclEnqueueSVMMigrateMem(command_queue, num_svm_pointers, MemoryUtil.memAddress(svm_pointers), MemoryUtil.memAddressSafe(sizes), flags, num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueSVMMigrateMem(long command_queue, PointerBuffer svm_pointers, PointerBuffer sizes, long flags, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS) {
            if (sizes != null) {
                Checks.checkBuffer(sizes, svm_pointers.remaining());
            }
            if (event != null) {
                Checks.checkBuffer(event, 1);
            }
        }
        return CL21.nclEnqueueSVMMigrateMem(command_queue, svm_pointers.remaining(), MemoryUtil.memAddress(svm_pointers), MemoryUtil.memAddressSafe(sizes), flags, event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

