/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opencl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL;
import org.lwjgl.opencl.CLCapabilities;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class CL10GL {
    public static final int CL_INVALID_GL_OBJECT = -60;
    public static final int CL_INVALID_MIP_LEVEL = -62;
    public static final int CL_GL_OBJECT_BUFFER = 8192;
    public static final int CL_GL_OBJECT_TEXTURE2D = 8193;
    public static final int CL_GL_OBJECT_TEXTURE3D = 8194;
    public static final int CL_GL_OBJECT_RENDERBUFFER = 8195;
    public static final int CL_GL_TEXTURE_TARGET = 8196;
    public static final int CL_GL_MIPMAP_LEVEL = 8197;
    public final long CreateFromGLBuffer;
    public final long CreateFromGLTexture2D;
    public final long CreateFromGLTexture3D;
    public final long CreateFromGLRenderbuffer;
    public final long GetGLObjectInfo;
    public final long GetGLTextureInfo;
    public final long EnqueueAcquireGLObjects;
    public final long EnqueueReleaseGLObjects;

    protected CL10GL() {
        throw new UnsupportedOperationException();
    }

    public CL10GL(FunctionProvider provider) {
        this.CreateFromGLBuffer = provider.getFunctionAddress("clCreateFromGLBuffer");
        this.CreateFromGLTexture2D = provider.getFunctionAddress("clCreateFromGLTexture2D");
        this.CreateFromGLTexture3D = provider.getFunctionAddress("clCreateFromGLTexture3D");
        this.CreateFromGLRenderbuffer = provider.getFunctionAddress("clCreateFromGLRenderbuffer");
        this.GetGLObjectInfo = provider.getFunctionAddress("clGetGLObjectInfo");
        this.GetGLTextureInfo = provider.getFunctionAddress("clGetGLTextureInfo");
        this.EnqueueAcquireGLObjects = provider.getFunctionAddress("clEnqueueAcquireGLObjects");
        this.EnqueueReleaseGLObjects = provider.getFunctionAddress("clEnqueueReleaseGLObjects");
    }

    public static CL10GL getInstance() {
        return CL10GL.getInstance(CL.getICD());
    }

    public static CL10GL getInstance(CLCapabilities caps) {
        return Checks.checkFunctionality(caps.__CL10GL);
    }

    static CL10GL create(FunctionProvider provider) {
        CL10GL funcs = new CL10GL(provider);
        boolean supported = Checks.checkFunctions(funcs.CreateFromGLBuffer, funcs.CreateFromGLTexture2D, funcs.CreateFromGLTexture3D, funcs.CreateFromGLRenderbuffer, funcs.GetGLObjectInfo, funcs.GetGLTextureInfo, funcs.EnqueueAcquireGLObjects, funcs.EnqueueReleaseGLObjects);
        return supported ? funcs : null;
    }

    public static long nclCreateFromGLBuffer(long context, long flags, int bufobj, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLBuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPJIPP(__functionAddress, context, flags, bufobj, errcode_ret);
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, ByteBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLBuffer(long context, long flags, int bufobj, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLBuffer(context, flags, bufobj, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLTexture2D;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPJIIIPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, ByteBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLTexture2D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture2D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLTexture3D;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPJIIIPP(__functionAddress, context, flags, texture_target, miplevel, texture, errcode_ret);
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, ByteBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLTexture3D(long context, long flags, int texture_target, int miplevel, int texture, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLTexture3D(context, flags, texture_target, miplevel, texture, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long nclCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, long errcode_ret) {
        long __functionAddress = CL10GL.getInstance().CreateFromGLRenderbuffer;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.callPJIPP(__functionAddress, context, flags, renderbuffer, errcode_ret);
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, ByteBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 4);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static long clCreateFromGLRenderbuffer(long context, long flags, int renderbuffer, IntBuffer errcode_ret) {
        if (Checks.CHECKS && errcode_ret != null) {
            Checks.checkBuffer((Buffer)errcode_ret, 1);
        }
        return CL10GL.nclCreateFromGLRenderbuffer(context, flags, renderbuffer, MemoryUtil.memAddressSafe(errcode_ret));
    }

    public static int nclGetGLObjectInfo(long memobj, long gl_object_type, long gl_object_name) {
        long __functionAddress = CL10GL.getInstance().GetGLObjectInfo;
        if (Checks.CHECKS) {
            Checks.checkPointer(memobj);
        }
        return JNI.callPPPI(__functionAddress, memobj, gl_object_type, gl_object_name);
    }

    public static int clGetGLObjectInfo(long memobj, ByteBuffer gl_object_type, ByteBuffer gl_object_name) {
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static int clGetGLObjectInfo(long memobj, IntBuffer gl_object_type, IntBuffer gl_object_name) {
        return CL10GL.nclGetGLObjectInfo(memobj, MemoryUtil.memAddressSafe(gl_object_type), MemoryUtil.memAddressSafe(gl_object_name));
    }

    public static int nclGetGLTextureInfo(long memobj, int param_name, long param_value_size, long param_value, long param_value_size_ret) {
        long __functionAddress = CL10GL.getInstance().GetGLTextureInfo;
        if (Checks.CHECKS) {
            Checks.checkPointer(memobj);
        }
        return JNI.callPIPPPI(__functionAddress, memobj, param_name, param_value_size, param_value, param_value_size_ret);
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, long param_value_size, ByteBuffer param_value, ByteBuffer param_value_size_ret) {
        if (Checks.CHECKS) {
            if (param_value != null) {
                Checks.checkBuffer((Buffer)param_value, param_value_size);
            }
            if (param_value_size_ret != null) {
                Checks.checkBuffer((Buffer)param_value_size_ret, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value_size, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, ByteBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value == null ? 0L : (long)param_value.remaining(), MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int clGetGLTextureInfo(long memobj, int param_name, IntBuffer param_value, PointerBuffer param_value_size_ret) {
        if (Checks.CHECKS && param_value_size_ret != null) {
            Checks.checkBuffer(param_value_size_ret, 1);
        }
        return CL10GL.nclGetGLTextureInfo(memobj, param_name, param_value == null ? 0 : param_value.remaining() << 2, MemoryUtil.memAddressSafe(param_value), MemoryUtil.memAddressSafe(param_value_size_ret));
    }

    public static int nclEnqueueAcquireGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10GL.getInstance().EnqueueAcquireGLObjects;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPIPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueAcquireGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int mem_objects = __buffer.pointerParam(mem_object);
        return CL10GL.nclEnqueueAcquireGLObjects(command_queue, 1, __buffer.address(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int nclEnqueueReleaseGLObjects(long command_queue, int num_objects, long mem_objects, int num_events_in_wait_list, long event_wait_list, long event) {
        long __functionAddress = CL10GL.getInstance().EnqueueReleaseGLObjects;
        if (Checks.CHECKS) {
            Checks.checkPointer(command_queue);
        }
        return JNI.callPIPIPPI(__functionAddress, command_queue, num_objects, mem_objects, num_events_in_wait_list, event_wait_list, event);
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, int num_objects, ByteBuffer mem_objects, int num_events_in_wait_list, ByteBuffer event_wait_list, ByteBuffer event) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)mem_objects, num_objects << Pointer.POINTER_SHIFT);
            if (event_wait_list != null) {
                Checks.checkBuffer((Buffer)event_wait_list, num_events_in_wait_list << Pointer.POINTER_SHIFT);
            }
            if (event != null) {
                Checks.checkBuffer((Buffer)event, 1 << Pointer.POINTER_SHIFT);
            }
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, num_objects, MemoryUtil.memAddress(mem_objects), num_events_in_wait_list, MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, PointerBuffer mem_objects, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, mem_objects.remaining(), MemoryUtil.memAddress(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }

    public static int clEnqueueReleaseGLObjects(long command_queue, long mem_object, PointerBuffer event_wait_list, PointerBuffer event) {
        if (Checks.CHECKS && event != null) {
            Checks.checkBuffer(event, 1);
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        int mem_objects = __buffer.pointerParam(mem_object);
        return CL10GL.nclEnqueueReleaseGLObjects(command_queue, 1, __buffer.address(mem_objects), event_wait_list == null ? 0 : event_wait_list.remaining(), MemoryUtil.memAddressSafe(event_wait_list), MemoryUtil.memAddressSafe(event));
    }
}

