/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.util.Set;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;

public class EXTThreadLocalContext {
    public final long SetThreadContext;
    public final long GetThreadContext;

    protected EXTThreadLocalContext() {
        throw new UnsupportedOperationException();
    }

    public EXTThreadLocalContext(FunctionProviderLocal provider, long device) {
        this.SetThreadContext = provider.getFunctionAddress(device, "alcSetThreadContext");
        this.GetThreadContext = provider.getFunctionAddress(device, "alcGetThreadContext");
    }

    public static EXTThreadLocalContext getInstance() {
        return EXTThreadLocalContext.getInstance(ALC.getCapabilities());
    }

    public static EXTThreadLocalContext getInstance(ALCCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTThreadLocalContext);
    }

    static EXTThreadLocalContext create(Set<String> ext, FunctionProviderLocal provider, long device) {
        if (!ext.contains("ALC_EXT_thread_local_context")) {
            return null;
        }
        EXTThreadLocalContext funcs = new EXTThreadLocalContext(provider, device);
        boolean supported = Checks.checkFunctions(funcs.SetThreadContext, funcs.GetThreadContext);
        return ALC.checkExtension("ALC_EXT_thread_local_context", funcs, supported);
    }

    public static boolean alcSetThreadContext(long context) {
        long __functionAddress = EXTThreadLocalContext.getInstance().SetThreadContext;
        if (Checks.CHECKS) {
            Checks.checkPointer(context);
        }
        return JNI.invokePZ(__functionAddress, context);
    }

    public static long alcGetThreadContext() {
        long __functionAddress = EXTThreadLocalContext.getInstance().GetThreadContext;
        return JNI.invokeP(__functionAddress);
    }
}

