/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.openal;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import org.lwjgl.openal.ALContext;
import org.lwjgl.openal.ALDevice;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProviderLocal;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public final class ALC {
    private static FunctionProviderLocal functionProvider;

    private ALC() {
    }

    public static void create() {
        String libName;
        switch (Platform.get()) {
            case WINDOWS: {
                libName = "OpenAL";
                break;
            }
            case LINUX: {
                libName = "openal";
                break;
            }
            case MACOSX: {
                libName = "openal";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        ALC.create(Configuration.LIBRARY_NAME_OPENAL.get(Pointer.BITS64 ? libName : libName + "32"));
    }

    public static void create(String libName) {
        final SharedLibrary OPENAL = Library.loadNative(libName);
        try {
            FunctionProviderLocal.Default functionProvider = new FunctionProviderLocal.Default(){
                private final long alcGetProcAddress = this.getFunctionAddress("alcGetProcAddress");
                {
                    if (this.alcGetProcAddress == 0L) {
                        OPENAL.release();
                        throw new RuntimeException("A core ALC function is missing. Make sure that OpenAL has been loaded.");
                    }
                }

                @Override
                public long getFunctionAddress(CharSequence functionName) {
                    long address = OPENAL.getFunctionAddress(functionName);
                    if (address == 0L) {
                        APIUtil.apiLog("Failed to locate address for ALC function " + functionName);
                    }
                    return address;
                }

                @Override
                public long getFunctionAddress(long handle, CharSequence functionName) {
                    APIBuffer __buffer = APIUtil.apiBuffer();
                    __buffer.stringParamASCII(functionName, true);
                    long address = JNI.invokePPP(this.alcGetProcAddress, handle, __buffer.address());
                    if (address == 0L) {
                        APIUtil.apiLog("Failed to locate address for ALC extension function " + functionName);
                    }
                    return address;
                }

                @Override
                protected void destroy() {
                    OPENAL.release();
                }
            };
            ALC.create(functionProvider);
        }
        catch (RuntimeException e) {
            OPENAL.release();
            throw e;
        }
    }

    public static void create(FunctionProviderLocal functionProvider) {
        if (ALC.functionProvider != null) {
            throw new IllegalStateException("ALC has already been created.");
        }
        ALC.functionProvider = functionProvider;
        AL.init();
    }

    public static void destroy() {
        if (functionProvider == null) {
            return;
        }
        AL.destroy();
        functionProvider.release();
        functionProvider = null;
    }

    public static FunctionProviderLocal getFunctionProvider() {
        return functionProvider;
    }

    public static ALCCapabilities getCapabilities() {
        ALContext context = AL.getCurrentContext();
        if (context != null) {
            return context.getDevice().getCapabilities();
        }
        return ALDevice.getLastDevice().getCapabilities();
    }

    public static List<String> getStringList(long deviceHandle, int token) {
        long __result = ALC10.nalcGetString(deviceHandle, token);
        if (__result == 0L) {
            return null;
        }
        ByteBuffer buffer = MemoryUtil.memByteBuffer(__result, Integer.MAX_VALUE);
        ArrayList<String> strings = new ArrayList<String>();
        int offset = 0;
        while (true) {
            if (buffer.get() != 0) {
                continue;
            }
            int limit = buffer.position() - 1;
            if (limit == offset) break;
            buffer.position(offset);
            buffer.limit(limit);
            strings.add(MemoryUtil.memDecodeUTF8(buffer));
            buffer.limit(Integer.MAX_VALUE);
            offset = limit + 1;
            buffer.position(offset);
        }
        return strings;
    }

    static ALCCapabilities createCapabilities(long device) {
        long GetIntegerv = functionProvider.getFunctionAddress("alcGetIntegerv");
        long GetString = functionProvider.getFunctionAddress("alcGetString");
        long IsExtensionPresent = functionProvider.getFunctionAddress("alcIsExtensionPresent");
        if (GetIntegerv == 0L || GetString == 0L || IsExtensionPresent == 0L) {
            throw new IllegalStateException("Core ALC functions could not be found. Make sure that OpenAL has been loaded.");
        }
        APIBuffer __buffer = APIUtil.apiBuffer();
        JNI.invokePIIPV(GetIntegerv, device, 4096, 1, __buffer.address());
        JNI.invokePIIPV(GetIntegerv, device, 4097, 1, __buffer.address(4));
        int majorVersion = __buffer.intValue(0);
        int minorVersion = __buffer.intValue(4);
        int[][] ALC_VERSIONS = new int[][]{{0, 1}};
        HashSet<String> supportedExtensions = new HashSet<String>(16);
        for (int major = 1; major <= ALC_VERSIONS.length; ++major) {
            int[] minors;
            for (int minor : minors = ALC_VERSIONS[major - 1]) {
                if (major >= majorVersion && (major != majorVersion || minor > minorVersion)) continue;
                supportedExtensions.add("OpenALC" + Integer.toString(major) + Integer.toString(minor));
            }
        }
        String extensionsString = MemoryUtil.memDecodeUTF8(Checks.checkPointer(JNI.invokePIP(GetString, device, 4102)));
        StringTokenizer tokenizer = new StringTokenizer(extensionsString);
        while (tokenizer.hasMoreTokens()) {
            String extName = tokenizer.nextToken();
            __buffer.reset().stringParamASCII(extName, true);
            if (!JNI.invokePPZ(IsExtensionPresent, device, __buffer.address())) continue;
            supportedExtensions.add(extName);
        }
        return new ALCCapabilities(ALC.getFunctionProvider(), device, supportedExtensions);
    }

    static <T> T checkExtension(String extension, T functions, boolean supported) {
        if (supported) {
            return functions;
        }
        APIUtil.apiLog("[ALC] " + extension + " was reported as available but an entry point is missing.");
        return null;
    }

    static {
        if (!((Boolean)Configuration.EXPLICIT_INIT_OPENAL.get()).booleanValue()) {
            ALC.create();
        }
    }
}

