/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class GLFWVidMode
extends Struct {
    public static final int SIZEOF;
    public static final int __ALIGNMENT;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int REDBITS;
    public static final int GREENBITS;
    public static final int BLUEBITS;
    public static final int REFRESHRATE;

    GLFWVidMode(long address, ByteBuffer container) {
        super(address, container, SIZEOF);
    }

    public GLFWVidMode(long struct) {
        this(struct, null);
    }

    public GLFWVidMode(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), container);
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return GLFWVidMode.nwidth(this.address());
    }

    public int height() {
        return GLFWVidMode.nheight(this.address());
    }

    public int redBits() {
        return GLFWVidMode.nredBits(this.address());
    }

    public int greenBits() {
        return GLFWVidMode.ngreenBits(this.address());
    }

    public int blueBits() {
        return GLFWVidMode.nblueBits(this.address());
    }

    public int refreshRate() {
        return GLFWVidMode.nrefreshRate(this.address());
    }

    public static GLFWVidMode malloc() {
        return new GLFWVidMode(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static GLFWVidMode calloc() {
        return new GLFWVidMode(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static GLFWVidMode create() {
        return new GLFWVidMode(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static Buffer mallocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memAlloc(capacity * SIZEOF));
    }

    public static Buffer callocBuffer(int capacity) {
        return new Buffer(MemoryUtil.memCalloc(capacity, SIZEOF));
    }

    public static Buffer createBuffer(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF), SIZEOF);
    }

    public static Buffer createBuffer(long address, int capacity) {
        return address == 0L ? null : new Buffer(MemoryUtil.memByteBuffer(address, capacity * SIZEOF), SIZEOF);
    }

    public static int nwidth(long struct) {
        return MemoryUtil.memGetInt(struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return MemoryUtil.memGetInt(struct + (long)HEIGHT);
    }

    public static int nredBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REDBITS);
    }

    public static int ngreenBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)GREENBITS);
    }

    public static int nblueBits(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BLUEBITS);
    }

    public static int nrefreshRate(long struct) {
        return MemoryUtil.memGetInt(struct + (long)REFRESHRATE);
    }

    static {
        Struct.Layout layout = GLFWVidMode.__struct(GLFWVidMode.__member(4), GLFWVidMode.__member(4), GLFWVidMode.__member(4), GLFWVidMode.__member(4), GLFWVidMode.__member(4), GLFWVidMode.__member(4));
        SIZEOF = layout.getSize();
        __ALIGNMENT = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        REDBITS = layout.offsetof(2);
        GREENBITS = layout.offsetof(3);
        BLUEBITS = layout.offsetof(4);
        REFRESHRATE = layout.offsetof(5);
    }

    public static final class Buffer
    extends StructBuffer<GLFWVidMode, Buffer> {
        public Buffer(ByteBuffer container) {
            this(container.slice(), SIZEOF);
        }

        Buffer(ByteBuffer container, int SIZEOF) {
            super(container, SIZEOF);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(ByteBuffer buffer) {
            return new Buffer(buffer);
        }

        @Override
        protected GLFWVidMode newInstance(long address) {
            return new GLFWVidMode(address, this.container);
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int width() {
            return GLFWVidMode.nwidth(this.address());
        }

        public int height() {
            return GLFWVidMode.nheight(this.address());
        }

        public int redBits() {
            return GLFWVidMode.nredBits(this.address());
        }

        public int greenBits() {
            return GLFWVidMode.ngreenBits(this.address());
        }

        public int blueBits() {
            return GLFWVidMode.nblueBits(this.address());
        }

        public int refreshRate() {
            return GLFWVidMode.nrefreshRate(this.address());
        }
    }
}

