/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWWindowSizeCallback;
import org.lwjgl.system.APIBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.libffi.Closure;

public final class Callbacks {
    private Callbacks() {
    }

    public static void glfwReleaseCallbacks(long window) {
        long[] callbacks;
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        GLFW glfw = GLFW.getInstance();
        for (long callback : callbacks = new long[]{JNI.invokePPP(glfw.SetWindowPosCallback, window, 0L), JNI.invokePPP(glfw.SetWindowSizeCallback, window, 0L), JNI.invokePPP(glfw.SetWindowCloseCallback, window, 0L), JNI.invokePPP(glfw.SetWindowRefreshCallback, window, 0L), JNI.invokePPP(glfw.SetWindowFocusCallback, window, 0L), JNI.invokePPP(glfw.SetWindowIconifyCallback, window, 0L), JNI.invokePPP(glfw.SetFramebufferSizeCallback, window, 0L), JNI.invokePPP(glfw.SetKeyCallback, window, 0L), JNI.invokePPP(glfw.SetCharCallback, window, 0L), JNI.invokePPP(glfw.SetCharModsCallback, window, 0L), JNI.invokePPP(glfw.SetMouseButtonCallback, window, 0L), JNI.invokePPP(glfw.SetCursorPosCallback, window, 0L), JNI.invokePPP(glfw.SetCursorEnterCallback, window, 0L), JNI.invokePPP(glfw.SetScrollCallback, window, 0L), JNI.invokePPP(glfw.SetDropCallback, window, 0L)}) {
            if (callback == 0L) continue;
            Closure.release(callback);
        }
    }

    public static void glfwInvoke(long window, GLFWWindowSizeCallback windowsizefun, GLFWFramebufferSizeCallback framebuffersizefun) {
        if (Checks.CHECKS) {
            Checks.checkPointer(window);
        }
        APIBuffer buffer = APIUtil.apiBuffer();
        if (framebuffersizefun != null) {
            GLFW.nglfwGetFramebufferSize(window, buffer.address() + 0L, buffer.address() + 4L);
            framebuffersizefun.invoke(window, buffer.intValue(0), buffer.intValue(4));
        }
        if (windowsizefun != null) {
            GLFW.nglfwGetWindowSize(window, buffer.address() + 0L, buffer.address() + 4L);
            windowsizefun.invoke(window, buffer.intValue(0), buffer.intValue(4));
        }
    }
}

