/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;

public class KHRStream {
    public static final long EGL_NO_STREAM_KHR = 0L;
    public static final int EGL_CONSUMER_LATENCY_USEC_KHR = 12816;
    public static final int EGL_PRODUCER_FRAME_KHR = 12818;
    public static final int EGL_CONSUMER_FRAME_KHR = 12819;
    public static final int EGL_STREAM_STATE_KHR = 12820;
    public static final int EGL_STREAM_STATE_CREATED_KHR = 12821;
    public static final int EGL_STREAM_STATE_CONNECTING_KHR = 12822;
    public static final int EGL_STREAM_STATE_EMPTY_KHR = 12823;
    public static final int EGL_STREAM_STATE_NEW_FRAME_AVAILABLE_KHR = 12824;
    public static final int EGL_STREAM_STATE_OLD_FRAME_AVAILABLE_KHR = 12825;
    public static final int EGL_STREAM_STATE_DISCONNECTED_KHR = 12826;
    public static final int EGL_BAD_STREAM_KHR = 12827;
    public static final int EGL_BAD_STATE_KHR = 12828;
    public final long CreateStreamKHR;
    public final long DestroyStreamKHR;
    public final long StreamAttribKHR;
    public final long QueryStreamKHR;
    public final long QueryStreamu64KHR;

    protected KHRStream() {
        throw new UnsupportedOperationException();
    }

    public KHRStream(FunctionProvider provider) {
        this.CreateStreamKHR = provider.getFunctionAddress("eglCreateStreamKHR");
        this.DestroyStreamKHR = provider.getFunctionAddress("eglDestroyStreamKHR");
        this.StreamAttribKHR = provider.getFunctionAddress("eglStreamAttribKHR");
        this.QueryStreamKHR = provider.getFunctionAddress("eglQueryStreamKHR");
        this.QueryStreamu64KHR = provider.getFunctionAddress("eglQueryStreamu64KHR");
    }

    public static KHRStream getInstance() {
        return KHRStream.getInstance(EGL.getCapabilities());
    }

    public static KHRStream getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__KHRStream);
    }

    public static long neglCreateStreamKHR(long dpy, long attrib_list) {
        long __functionAddress = KHRStream.getInstance().CreateStreamKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPP(__functionAddress, dpy, attrib_list);
    }

    public static long eglCreateStreamKHR(long dpy, ByteBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT4(attrib_list, 12344);
        }
        return KHRStream.neglCreateStreamKHR(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static long eglCreateStreamKHR(long dpy, IntBuffer attrib_list) {
        if (Checks.CHECKS && attrib_list != null) {
            Checks.checkNT(attrib_list, 12344);
        }
        return KHRStream.neglCreateStreamKHR(dpy, MemoryUtil.memAddressSafe(attrib_list));
    }

    public static boolean eglDestroyStreamKHR(long dpy, long stream) {
        long __functionAddress = KHRStream.getInstance().DestroyStreamKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPZ(__functionAddress, dpy, stream);
    }

    public static boolean eglStreamAttribKHR(long dpy, long stream, int attribute, int value) {
        long __functionAddress = KHRStream.getInstance().StreamAttribKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPIIZ(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean neglQueryStreamKHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = KHRStream.getInstance().QueryStreamKHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean eglQueryStreamKHR(long dpy, long stream, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 4);
        }
        return KHRStream.neglQueryStreamKHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryStreamKHR(long dpy, long stream, int attribute, IntBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRStream.neglQueryStreamKHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean neglQueryStreamu64KHR(long dpy, long stream, int attribute, long value) {
        long __functionAddress = KHRStream.getInstance().QueryStreamu64KHR;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(stream);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, stream, attribute, value);
    }

    public static boolean eglQueryStreamu64KHR(long dpy, long stream, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 8);
        }
        return KHRStream.neglQueryStreamu64KHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryStreamu64KHR(long dpy, long stream, int attribute, LongBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1);
        }
        return KHRStream.neglQueryStreamu64KHR(dpy, stream, attribute, MemoryUtil.memAddress(value));
    }
}

