/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Pointer;

public class EXTOutputBase {
    public static final int EGL_BAD_OUTPUT_LAYER_EXT = 12845;
    public static final int EGL_BAD_OUTPUT_PORT_EXT = 12846;
    public static final int EGL_SWAP_INTERVAL_EXT = 12847;
    public static final long EGL_NO_OUTPUT_LAYER_EXT = 0L;
    public static final long EGL_NO_OUTPUT_PORT_EXT = 0L;
    public final long GetOutputLayersEXT;
    public final long GetOutputPortsEXT;
    public final long OutputLayerAttribEXT;
    public final long QueryOutputLayerAttribEXT;
    public final long QueryOutputLayerStringEXT;
    public final long OutputPortAttribEXT;
    public final long QueryOutputPortAttribEXT;
    public final long QueryOutputPortStringEXT;

    protected EXTOutputBase() {
        throw new UnsupportedOperationException();
    }

    public EXTOutputBase(FunctionProvider provider) {
        this.GetOutputLayersEXT = provider.getFunctionAddress("eglGetOutputLayersEXT");
        this.GetOutputPortsEXT = provider.getFunctionAddress("eglGetOutputPortsEXT");
        this.OutputLayerAttribEXT = provider.getFunctionAddress("eglOutputLayerAttribEXT");
        this.QueryOutputLayerAttribEXT = provider.getFunctionAddress("eglQueryOutputLayerAttribEXT");
        this.QueryOutputLayerStringEXT = provider.getFunctionAddress("eglQueryOutputLayerStringEXT");
        this.OutputPortAttribEXT = provider.getFunctionAddress("eglOutputPortAttribEXT");
        this.QueryOutputPortAttribEXT = provider.getFunctionAddress("eglQueryOutputPortAttribEXT");
        this.QueryOutputPortStringEXT = provider.getFunctionAddress("eglQueryOutputPortStringEXT");
    }

    public static EXTOutputBase getInstance() {
        return EXTOutputBase.getInstance(EGL.getCapabilities());
    }

    public static EXTOutputBase getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EXTOutputBase);
    }

    public static boolean neglGetOutputLayersEXT(long dpy, long attrib_list, long layers, int max_layers, long num_layers) {
        long __functionAddress = EXTOutputBase.getInstance().GetOutputLayersEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPIPZ(__functionAddress, dpy, attrib_list, layers, max_layers, num_layers);
    }

    public static boolean eglGetOutputLayersEXT(long dpy, ByteBuffer attrib_list, ByteBuffer layers, int max_layers, ByteBuffer num_layers) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNTP(attrib_list, 12344L);
            }
            if (layers != null) {
                Checks.checkBuffer((Buffer)layers, max_layers << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)num_layers, 4);
        }
        return EXTOutputBase.neglGetOutputLayersEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), max_layers, MemoryUtil.memAddress(num_layers));
    }

    public static boolean eglGetOutputLayersEXT(long dpy, PointerBuffer attrib_list, PointerBuffer layers, IntBuffer num_layers) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer((Buffer)num_layers, 1);
        }
        return EXTOutputBase.neglGetOutputLayersEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(layers), layers == null ? 0 : layers.remaining(), MemoryUtil.memAddress(num_layers));
    }

    public static boolean neglGetOutputPortsEXT(long dpy, long attrib_list, long ports, int max_ports, long num_ports) {
        long __functionAddress = EXTOutputBase.getInstance().GetOutputPortsEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPPPIPZ(__functionAddress, dpy, attrib_list, ports, max_ports, num_ports);
    }

    public static boolean eglGetOutputPortsEXT(long dpy, ByteBuffer attrib_list, ByteBuffer ports, int max_ports, ByteBuffer num_ports) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNTP(attrib_list, 12344L);
            }
            if (ports != null) {
                Checks.checkBuffer((Buffer)ports, max_ports << Pointer.POINTER_SHIFT);
            }
            Checks.checkBuffer((Buffer)num_ports, 4);
        }
        return EXTOutputBase.neglGetOutputPortsEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), max_ports, MemoryUtil.memAddress(num_ports));
    }

    public static boolean eglGetOutputPortsEXT(long dpy, PointerBuffer attrib_list, PointerBuffer ports, IntBuffer num_ports) {
        if (Checks.CHECKS) {
            if (attrib_list != null) {
                Checks.checkNT(attrib_list, 12344L);
            }
            Checks.checkBuffer((Buffer)num_ports, 1);
        }
        return EXTOutputBase.neglGetOutputPortsEXT(dpy, MemoryUtil.memAddressSafe(attrib_list), MemoryUtil.memAddressSafe(ports), ports == null ? 0 : ports.remaining(), MemoryUtil.memAddress(num_ports));
    }

    public static boolean eglOutputLayerAttribEXT(long dpy, long layer, int attribute, long value) {
        long __functionAddress = EXTOutputBase.getInstance().OutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, layer, attribute, value);
    }

    public static boolean neglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, long value) {
        long __functionAddress = EXTOutputBase.getInstance().QueryOutputLayerAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, layer, attribute, value);
    }

    public static boolean eglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return EXTOutputBase.neglQueryOutputLayerAttribEXT(dpy, layer, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryOutputLayerAttribEXT(long dpy, long layer, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTOutputBase.neglQueryOutputLayerAttribEXT(dpy, layer, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryOutputLayerStringEXT(long dpy, long layer, int name) {
        long __functionAddress = EXTOutputBase.getInstance().QueryOutputLayerStringEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(layer);
        }
        return JNI.callPPIP(__functionAddress, dpy, layer, name);
    }

    public static String eglQueryOutputLayerStringEXT(long dpy, long layer, int name) {
        long __result = EXTOutputBase.neglQueryOutputLayerStringEXT(dpy, layer, name);
        return MemoryUtil.memDecodeASCII(__result);
    }

    public static boolean eglOutputPortAttribEXT(long dpy, long port, int attribute, long value) {
        long __functionAddress = EXTOutputBase.getInstance().OutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, port, attribute, value);
    }

    public static boolean neglQueryOutputPortAttribEXT(long dpy, long port, int attribute, long value) {
        long __functionAddress = EXTOutputBase.getInstance().QueryOutputPortAttribEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPIPZ(__functionAddress, dpy, port, attribute, value);
    }

    public static boolean eglQueryOutputPortAttribEXT(long dpy, long port, int attribute, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)value, 1 << Pointer.POINTER_SHIFT);
        }
        return EXTOutputBase.neglQueryOutputPortAttribEXT(dpy, port, attribute, MemoryUtil.memAddress(value));
    }

    public static boolean eglQueryOutputPortAttribEXT(long dpy, long port, int attribute, PointerBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkBuffer(value, 1);
        }
        return EXTOutputBase.neglQueryOutputPortAttribEXT(dpy, port, attribute, MemoryUtil.memAddress(value));
    }

    public static long neglQueryOutputPortStringEXT(long dpy, long port, int name) {
        long __functionAddress = EXTOutputBase.getInstance().QueryOutputPortStringEXT;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(port);
        }
        return JNI.callPPIP(__functionAddress, dpy, port, name);
    }

    public static String eglQueryOutputPortStringEXT(long dpy, long port, int name) {
        long __result = EXTOutputBase.neglQueryOutputPortStringEXT(dpy, port, name);
        return MemoryUtil.memDecodeASCII(__result);
    }
}

