/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.egl;

import org.lwjgl.egl.EGL;
import org.lwjgl.egl.EGLCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;

public class EGL11 {
    public static final int EGL_BACK_BUFFER = 12420;
    public static final int EGL_BIND_TO_TEXTURE_RGB = 12345;
    public static final int EGL_BIND_TO_TEXTURE_RGBA = 12346;
    public static final int EGL_CONTEXT_LOST = 12302;
    public static final int EGL_MIN_SWAP_INTERVAL = 12347;
    public static final int EGL_MAX_SWAP_INTERVAL = 12348;
    public static final int EGL_MIPMAP_TEXTURE = 12418;
    public static final int EGL_MIPMAP_LEVEL = 12419;
    public static final int EGL_NO_TEXTURE = 12380;
    public static final int EGL_TEXTURE_2D = 12383;
    public static final int EGL_TEXTURE_FORMAT = 12416;
    public static final int EGL_TEXTURE_RGB = 12381;
    public static final int EGL_TEXTURE_RGBA = 12382;
    public static final int EGL_TEXTURE_TARGET = 12417;
    public final long BindTexImage;
    public final long ReleaseTexImage;
    public final long SurfaceAttrib;
    public final long SwapInterval;

    protected EGL11() {
        throw new UnsupportedOperationException();
    }

    public EGL11(FunctionProvider provider) {
        this.BindTexImage = provider.getFunctionAddress("eglBindTexImage");
        this.ReleaseTexImage = provider.getFunctionAddress("eglReleaseTexImage");
        this.SurfaceAttrib = provider.getFunctionAddress("eglSurfaceAttrib");
        this.SwapInterval = provider.getFunctionAddress("eglSwapInterval");
    }

    public static EGL11 getInstance() {
        return EGL11.getInstance(EGL.getCapabilities());
    }

    public static EGL11 getInstance(EGLCapabilities caps) {
        return Checks.checkFunctionality(caps.__EGL11);
    }

    public static boolean eglBindTexImage(long dpy, long surface, int buffer) {
        long __functionAddress = EGL11.getInstance().BindTexImage;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIZ(__functionAddress, dpy, surface, buffer);
    }

    public static boolean eglReleaseTexImage(long dpy, long surface, int buffer) {
        long __functionAddress = EGL11.getInstance().ReleaseTexImage;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIZ(__functionAddress, dpy, surface, buffer);
    }

    public static boolean eglSurfaceAttrib(long dpy, long surface, int attribute, int value) {
        long __functionAddress = EGL11.getInstance().SurfaceAttrib;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
            Checks.checkPointer(surface);
        }
        return JNI.callPPIIZ(__functionAddress, dpy, surface, attribute, value);
    }

    public static boolean eglSwapInterval(long dpy, int interval) {
        long __functionAddress = EGL11.getInstance().SwapInterval;
        if (Checks.CHECKS) {
            Checks.checkPointer(dpy);
        }
        return JNI.callPIZ(__functionAddress, dpy, interval);
    }
}

