/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkAttachmentDescription;
import org.lwjgl.vulkan.VkSubpassDependency;
import org.lwjgl.vulkan.VkSubpassDescription;

public class VkRenderPassCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int ATTACHMENTCOUNT;
    public static final int PATTACHMENTS;
    public static final int SUBPASSCOUNT;
    public static final int PSUBPASSES;
    public static final int DEPENDENCYCOUNT;
    public static final int PDEPENDENCIES;

    VkRenderPassCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkRenderPassCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkRenderPassCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkRenderPassCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkRenderPassCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkRenderPassCreateInfo.nflags(this.address());
    }

    public int attachmentCount() {
        return VkRenderPassCreateInfo.nattachmentCount(this.address());
    }

    public VkAttachmentDescription.Buffer pAttachments() {
        return VkRenderPassCreateInfo.npAttachments(this.address());
    }

    public int subpassCount() {
        return VkRenderPassCreateInfo.nsubpassCount(this.address());
    }

    public VkSubpassDescription.Buffer pSubpasses() {
        return VkRenderPassCreateInfo.npSubpasses(this.address());
    }

    public int dependencyCount() {
        return VkRenderPassCreateInfo.ndependencyCount(this.address());
    }

    public VkSubpassDependency.Buffer pDependencies() {
        return VkRenderPassCreateInfo.npDependencies(this.address());
    }

    public VkRenderPassCreateInfo sType(int value) {
        VkRenderPassCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pNext(long value) {
        VkRenderPassCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo flags(int value) {
        VkRenderPassCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pAttachments(VkAttachmentDescription.Buffer value) {
        VkRenderPassCreateInfo.npAttachments(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pSubpasses(VkSubpassDescription.Buffer value) {
        VkRenderPassCreateInfo.npSubpasses(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo pDependencies(VkSubpassDependency.Buffer value) {
        VkRenderPassCreateInfo.npDependencies(this.address(), value);
        return this;
    }

    public VkRenderPassCreateInfo set(int sType, long pNext, int flags, VkAttachmentDescription.Buffer pAttachments, VkSubpassDescription.Buffer pSubpasses, VkSubpassDependency.Buffer pDependencies) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pAttachments(pAttachments);
        this.pSubpasses(pSubpasses);
        this.pDependencies(pDependencies);
        return this;
    }

    public VkRenderPassCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkRenderPassCreateInfo set(VkRenderPassCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkRenderPassCreateInfo malloc() {
        return VkRenderPassCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkRenderPassCreateInfo calloc() {
        return VkRenderPassCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkRenderPassCreateInfo create() {
        return new VkRenderPassCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkRenderPassCreateInfo create(long address) {
        return address == 0L ? null : new VkRenderPassCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkRenderPassCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkRenderPassCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkRenderPassCreateInfo mallocStack() {
        return VkRenderPassCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo callocStack() {
        return VkRenderPassCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkRenderPassCreateInfo mallocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkRenderPassCreateInfo callocStack(MemoryStack stack) {
        return VkRenderPassCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkRenderPassCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkRenderPassCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkRenderPassCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nattachmentCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)ATTACHMENTCOUNT);
    }

    public static VkAttachmentDescription.Buffer npAttachments(long struct) {
        return VkAttachmentDescription.create(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS), VkRenderPassCreateInfo.nattachmentCount(struct));
    }

    public static int nsubpassCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASSCOUNT);
    }

    public static VkSubpassDescription.Buffer npSubpasses(long struct) {
        return VkSubpassDescription.create(MemoryUtil.memGetAddress(struct + (long)PSUBPASSES), VkRenderPassCreateInfo.nsubpassCount(struct));
    }

    public static int ndependencyCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)DEPENDENCYCOUNT);
    }

    public static VkSubpassDependency.Buffer npDependencies(long struct) {
        return VkSubpassDependency.create(MemoryUtil.memGetAddress(struct + (long)PDEPENDENCIES), VkRenderPassCreateInfo.ndependencyCount(struct));
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nattachmentCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)ATTACHMENTCOUNT, value);
    }

    public static void npAttachments(long struct, VkAttachmentDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PATTACHMENTS, VkRenderPassCreateInfo.addressSafe(value));
        VkRenderPassCreateInfo.nattachmentCount(struct, value == null ? 0 : value.remaining());
    }

    public static void nsubpassCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASSCOUNT, value);
    }

    public static void npSubpasses(long struct, VkSubpassDescription.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSUBPASSES, value.address());
        VkRenderPassCreateInfo.nsubpassCount(struct, value.remaining());
    }

    public static void ndependencyCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)DEPENDENCYCOUNT, value);
    }

    public static void npDependencies(long struct, VkSubpassDependency.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPENDENCIES, VkRenderPassCreateInfo.addressSafe(value));
        VkRenderPassCreateInfo.ndependencyCount(struct, value == null ? 0 : value.remaining());
    }

    public static void validate(long struct) {
        if (VkRenderPassCreateInfo.nattachmentCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PATTACHMENTS));
        }
        int subpassCount = VkRenderPassCreateInfo.nsubpassCount(struct);
        long pSubpasses = MemoryUtil.memGetAddress(struct + (long)PSUBPASSES);
        Checks.checkPointer(pSubpasses);
        VkSubpassDescription.validate(pSubpasses, subpassCount);
        if (VkRenderPassCreateInfo.ndependencyCount(struct) != 0) {
            Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PDEPENDENCIES));
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkRenderPassCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkRenderPassCreateInfo.__struct(VkRenderPassCreateInfo.__member(4), VkRenderPassCreateInfo.__member(POINTER_SIZE), VkRenderPassCreateInfo.__member(4), VkRenderPassCreateInfo.__member(4), VkRenderPassCreateInfo.__member(POINTER_SIZE), VkRenderPassCreateInfo.__member(4), VkRenderPassCreateInfo.__member(POINTER_SIZE), VkRenderPassCreateInfo.__member(4), VkRenderPassCreateInfo.__member(POINTER_SIZE));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        ATTACHMENTCOUNT = layout.offsetof(3);
        PATTACHMENTS = layout.offsetof(4);
        SUBPASSCOUNT = layout.offsetof(5);
        PSUBPASSES = layout.offsetof(6);
        DEPENDENCYCOUNT = layout.offsetof(7);
        PDEPENDENCIES = layout.offsetof(8);
    }

    public static final class Buffer
    extends StructBuffer<VkRenderPassCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkRenderPassCreateInfo newInstance(long address) {
            return new VkRenderPassCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkRenderPassCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkRenderPassCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkRenderPassCreateInfo.nflags(this.address());
        }

        public int attachmentCount() {
            return VkRenderPassCreateInfo.nattachmentCount(this.address());
        }

        public VkAttachmentDescription.Buffer pAttachments() {
            return VkRenderPassCreateInfo.npAttachments(this.address());
        }

        public int subpassCount() {
            return VkRenderPassCreateInfo.nsubpassCount(this.address());
        }

        public VkSubpassDescription.Buffer pSubpasses() {
            return VkRenderPassCreateInfo.npSubpasses(this.address());
        }

        public int dependencyCount() {
            return VkRenderPassCreateInfo.ndependencyCount(this.address());
        }

        public VkSubpassDependency.Buffer pDependencies() {
            return VkRenderPassCreateInfo.npDependencies(this.address());
        }

        public Buffer sType(int value) {
            VkRenderPassCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkRenderPassCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkRenderPassCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pAttachments(VkAttachmentDescription.Buffer value) {
            VkRenderPassCreateInfo.npAttachments(this.address(), value);
            return this;
        }

        public Buffer pSubpasses(VkSubpassDescription.Buffer value) {
            VkRenderPassCreateInfo.npSubpasses(this.address(), value);
            return this;
        }

        public Buffer pDependencies(VkSubpassDependency.Buffer value) {
            VkRenderPassCreateInfo.npDependencies(this.address(), value);
            return this;
        }
    }
}

