/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkPipelineColorBlendStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineDepthStencilStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineDynamicStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineInputAssemblyStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineMultisampleStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineRasterizationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineShaderStageCreateInfo;
import org.lwjgl.vulkan.VkPipelineTessellationStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineVertexInputStateCreateInfo;
import org.lwjgl.vulkan.VkPipelineViewportStateCreateInfo;

public class VkGraphicsPipelineCreateInfo
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int FLAGS;
    public static final int STAGECOUNT;
    public static final int PSTAGES;
    public static final int PVERTEXINPUTSTATE;
    public static final int PINPUTASSEMBLYSTATE;
    public static final int PTESSELLATIONSTATE;
    public static final int PVIEWPORTSTATE;
    public static final int PRASTERIZATIONSTATE;
    public static final int PMULTISAMPLESTATE;
    public static final int PDEPTHSTENCILSTATE;
    public static final int PCOLORBLENDSTATE;
    public static final int PDYNAMICSTATE;
    public static final int LAYOUT;
    public static final int RENDERPASS;
    public static final int SUBPASS;
    public static final int BASEPIPELINEHANDLE;
    public static final int BASEPIPELINEINDEX;

    VkGraphicsPipelineCreateInfo(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkGraphicsPipelineCreateInfo(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkGraphicsPipelineCreateInfo.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public int sType() {
        return VkGraphicsPipelineCreateInfo.nsType(this.address());
    }

    public long pNext() {
        return VkGraphicsPipelineCreateInfo.npNext(this.address());
    }

    public int flags() {
        return VkGraphicsPipelineCreateInfo.nflags(this.address());
    }

    public int stageCount() {
        return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
    }

    public VkPipelineShaderStageCreateInfo.Buffer pStages() {
        return VkGraphicsPipelineCreateInfo.npStages(this.address());
    }

    public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
        return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
    }

    public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
        return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
    }

    public VkPipelineTessellationStateCreateInfo pTessellationState() {
        return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
    }

    public VkPipelineViewportStateCreateInfo pViewportState() {
        return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
    }

    public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
        return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
    }

    public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
        return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
    }

    public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
        return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
    }

    public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
        return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
    }

    public VkPipelineDynamicStateCreateInfo pDynamicState() {
        return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
    }

    public long layout() {
        return VkGraphicsPipelineCreateInfo.nlayout(this.address());
    }

    public long renderPass() {
        return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
    }

    public int subpass() {
        return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
    }

    public long basePipelineHandle() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
    }

    public int basePipelineIndex() {
        return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
    }

    public VkGraphicsPipelineCreateInfo sType(int value) {
        VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pNext(long value) {
        VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo flags(int value) {
        VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pStages(VkPipelineShaderStageCreateInfo.Buffer value) {
        VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pVertexInputState(VkPipelineVertexInputStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pInputAssemblyState(VkPipelineInputAssemblyStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pTessellationState(VkPipelineTessellationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pViewportState(VkPipelineViewportStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pRasterizationState(VkPipelineRasterizationStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pMultisampleState(VkPipelineMultisampleStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDepthStencilState(VkPipelineDepthStencilStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pColorBlendState(VkPipelineColorBlendStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo pDynamicState(VkPipelineDynamicStateCreateInfo value) {
        VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo layout(long value) {
        VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo renderPass(long value) {
        VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo subpass(int value) {
        VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineHandle(long value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo basePipelineIndex(int value) {
        VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(int sType, long pNext, int flags, VkPipelineShaderStageCreateInfo.Buffer pStages, VkPipelineVertexInputStateCreateInfo pVertexInputState, VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState, VkPipelineTessellationStateCreateInfo pTessellationState, VkPipelineViewportStateCreateInfo pViewportState, VkPipelineRasterizationStateCreateInfo pRasterizationState, VkPipelineMultisampleStateCreateInfo pMultisampleState, VkPipelineDepthStencilStateCreateInfo pDepthStencilState, VkPipelineColorBlendStateCreateInfo pColorBlendState, VkPipelineDynamicStateCreateInfo pDynamicState, long layout, long renderPass, int subpass, long basePipelineHandle, int basePipelineIndex) {
        this.sType(sType);
        this.pNext(pNext);
        this.flags(flags);
        this.pStages(pStages);
        this.pVertexInputState(pVertexInputState);
        this.pInputAssemblyState(pInputAssemblyState);
        this.pTessellationState(pTessellationState);
        this.pViewportState(pViewportState);
        this.pRasterizationState(pRasterizationState);
        this.pMultisampleState(pMultisampleState);
        this.pDepthStencilState(pDepthStencilState);
        this.pColorBlendState(pColorBlendState);
        this.pDynamicState(pDynamicState);
        this.layout(layout);
        this.renderPass(renderPass);
        this.subpass(subpass);
        this.basePipelineHandle(basePipelineHandle);
        this.basePipelineIndex(basePipelineIndex);
        return this;
    }

    public VkGraphicsPipelineCreateInfo nset(long struct) {
        MemoryUtil.memCopy(struct, this.address(), SIZEOF);
        return this;
    }

    public VkGraphicsPipelineCreateInfo set(VkGraphicsPipelineCreateInfo src) {
        return this.nset(src.address());
    }

    public static VkGraphicsPipelineCreateInfo malloc() {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo calloc() {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo create() {
        return new VkGraphicsPipelineCreateInfo(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo create(long address) {
        return address == 0L ? null : new VkGraphicsPipelineCreateInfo(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkGraphicsPipelineCreateInfo.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkGraphicsPipelineCreateInfo mallocStack() {
        return VkGraphicsPipelineCreateInfo.mallocStack(MemoryStack.stackGet());
    }

    public static VkGraphicsPipelineCreateInfo callocStack() {
        return VkGraphicsPipelineCreateInfo.callocStack(MemoryStack.stackGet());
    }

    public static VkGraphicsPipelineCreateInfo mallocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkGraphicsPipelineCreateInfo callocStack(MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkGraphicsPipelineCreateInfo.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkGraphicsPipelineCreateInfo.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nsType(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress(struct + (long)PNEXT);
    }

    public static int nflags(long struct) {
        return MemoryUtil.memGetInt(struct + (long)FLAGS);
    }

    public static int nstageCount(long struct) {
        return MemoryUtil.memGetInt(struct + (long)STAGECOUNT);
    }

    public static VkPipelineShaderStageCreateInfo.Buffer npStages(long struct) {
        return VkPipelineShaderStageCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PSTAGES), VkGraphicsPipelineCreateInfo.nstageCount(struct));
    }

    public static VkPipelineVertexInputStateCreateInfo npVertexInputState(long struct) {
        return VkPipelineVertexInputStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE));
    }

    public static VkPipelineInputAssemblyStateCreateInfo npInputAssemblyState(long struct) {
        return VkPipelineInputAssemblyStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PINPUTASSEMBLYSTATE));
    }

    public static VkPipelineTessellationStateCreateInfo npTessellationState(long struct) {
        return VkPipelineTessellationStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PTESSELLATIONSTATE));
    }

    public static VkPipelineViewportStateCreateInfo npViewportState(long struct) {
        return VkPipelineViewportStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PVIEWPORTSTATE));
    }

    public static VkPipelineRasterizationStateCreateInfo npRasterizationState(long struct) {
        return VkPipelineRasterizationStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PRASTERIZATIONSTATE));
    }

    public static VkPipelineMultisampleStateCreateInfo npMultisampleState(long struct) {
        return VkPipelineMultisampleStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PMULTISAMPLESTATE));
    }

    public static VkPipelineDepthStencilStateCreateInfo npDepthStencilState(long struct) {
        return VkPipelineDepthStencilStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PDEPTHSTENCILSTATE));
    }

    public static VkPipelineColorBlendStateCreateInfo npColorBlendState(long struct) {
        return VkPipelineColorBlendStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PCOLORBLENDSTATE));
    }

    public static VkPipelineDynamicStateCreateInfo npDynamicState(long struct) {
        return VkPipelineDynamicStateCreateInfo.create(MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE));
    }

    public static long nlayout(long struct) {
        return MemoryUtil.memGetLong(struct + (long)LAYOUT);
    }

    public static long nrenderPass(long struct) {
        return MemoryUtil.memGetLong(struct + (long)RENDERPASS);
    }

    public static int nsubpass(long struct) {
        return MemoryUtil.memGetInt(struct + (long)SUBPASS);
    }

    public static long nbasePipelineHandle(long struct) {
        return MemoryUtil.memGetLong(struct + (long)BASEPIPELINEHANDLE);
    }

    public static int nbasePipelineIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)BASEPIPELINEINDEX);
    }

    public static void nsType(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress(struct + (long)PNEXT, value);
    }

    public static void nflags(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)FLAGS, value);
    }

    public static void nstageCount(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)STAGECOUNT, value);
    }

    public static void npStages(long struct, VkPipelineShaderStageCreateInfo.Buffer value) {
        MemoryUtil.memPutAddress(struct + (long)PSTAGES, value.address());
        VkGraphicsPipelineCreateInfo.nstageCount(struct, value.remaining());
    }

    public static void npVertexInputState(long struct, VkPipelineVertexInputStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVERTEXINPUTSTATE, value.address());
    }

    public static void npInputAssemblyState(long struct, VkPipelineInputAssemblyStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PINPUTASSEMBLYSTATE, value.address());
    }

    public static void npTessellationState(long struct, VkPipelineTessellationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PTESSELLATIONSTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void npViewportState(long struct, VkPipelineViewportStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PVIEWPORTSTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void npRasterizationState(long struct, VkPipelineRasterizationStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PRASTERIZATIONSTATE, value.address());
    }

    public static void npMultisampleState(long struct, VkPipelineMultisampleStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PMULTISAMPLESTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void npDepthStencilState(long struct, VkPipelineDepthStencilStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDEPTHSTENCILSTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void npColorBlendState(long struct, VkPipelineColorBlendStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PCOLORBLENDSTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void npDynamicState(long struct, VkPipelineDynamicStateCreateInfo value) {
        MemoryUtil.memPutAddress(struct + (long)PDYNAMICSTATE, VkGraphicsPipelineCreateInfo.addressSafe(value));
    }

    public static void nlayout(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)LAYOUT, value);
    }

    public static void nrenderPass(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)RENDERPASS, value);
    }

    public static void nsubpass(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)SUBPASS, value);
    }

    public static void nbasePipelineHandle(long struct, long value) {
        MemoryUtil.memPutLong(struct + (long)BASEPIPELINEHANDLE, value);
    }

    public static void nbasePipelineIndex(long struct, int value) {
        MemoryUtil.memPutInt(struct + (long)BASEPIPELINEINDEX, value);
    }

    public static void validate(long struct) {
        long pDynamicState;
        int stageCount = VkGraphicsPipelineCreateInfo.nstageCount(struct);
        long pStages = MemoryUtil.memGetAddress(struct + (long)PSTAGES);
        Checks.checkPointer(pStages);
        VkPipelineShaderStageCreateInfo.validate(pStages, stageCount);
        long pVertexInputState = MemoryUtil.memGetAddress(struct + (long)PVERTEXINPUTSTATE);
        Checks.checkPointer(pVertexInputState);
        VkPipelineVertexInputStateCreateInfo.validate(pVertexInputState);
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PINPUTASSEMBLYSTATE));
        Checks.checkPointer(MemoryUtil.memGetAddress(struct + (long)PRASTERIZATIONSTATE));
        long pColorBlendState = MemoryUtil.memGetAddress(struct + (long)PCOLORBLENDSTATE);
        if (pColorBlendState != 0L) {
            VkPipelineColorBlendStateCreateInfo.validate(pColorBlendState);
        }
        if ((pDynamicState = MemoryUtil.memGetAddress(struct + (long)PDYNAMICSTATE)) != 0L) {
            VkPipelineDynamicStateCreateInfo.validate(pDynamicState);
        }
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            VkGraphicsPipelineCreateInfo.validate(array + (long)(i * SIZEOF));
        }
    }

    static {
        Struct.Layout layout = VkGraphicsPipelineCreateInfo.__struct(VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(POINTER_SIZE), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4), VkGraphicsPipelineCreateInfo.__member(8), VkGraphicsPipelineCreateInfo.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        FLAGS = layout.offsetof(2);
        STAGECOUNT = layout.offsetof(3);
        PSTAGES = layout.offsetof(4);
        PVERTEXINPUTSTATE = layout.offsetof(5);
        PINPUTASSEMBLYSTATE = layout.offsetof(6);
        PTESSELLATIONSTATE = layout.offsetof(7);
        PVIEWPORTSTATE = layout.offsetof(8);
        PRASTERIZATIONSTATE = layout.offsetof(9);
        PMULTISAMPLESTATE = layout.offsetof(10);
        PDEPTHSTENCILSTATE = layout.offsetof(11);
        PCOLORBLENDSTATE = layout.offsetof(12);
        PDYNAMICSTATE = layout.offsetof(13);
        LAYOUT = layout.offsetof(14);
        RENDERPASS = layout.offsetof(15);
        SUBPASS = layout.offsetof(16);
        BASEPIPELINEHANDLE = layout.offsetof(17);
        BASEPIPELINEINDEX = layout.offsetof(18);
    }

    public static final class Buffer
    extends StructBuffer<VkGraphicsPipelineCreateInfo, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkGraphicsPipelineCreateInfo newInstance(long address) {
            return new VkGraphicsPipelineCreateInfo(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public int sType() {
            return VkGraphicsPipelineCreateInfo.nsType(this.address());
        }

        public long pNext() {
            return VkGraphicsPipelineCreateInfo.npNext(this.address());
        }

        public int flags() {
            return VkGraphicsPipelineCreateInfo.nflags(this.address());
        }

        public int stageCount() {
            return VkGraphicsPipelineCreateInfo.nstageCount(this.address());
        }

        public VkPipelineShaderStageCreateInfo.Buffer pStages() {
            return VkGraphicsPipelineCreateInfo.npStages(this.address());
        }

        public VkPipelineVertexInputStateCreateInfo pVertexInputState() {
            return VkGraphicsPipelineCreateInfo.npVertexInputState(this.address());
        }

        public VkPipelineInputAssemblyStateCreateInfo pInputAssemblyState() {
            return VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address());
        }

        public VkPipelineTessellationStateCreateInfo pTessellationState() {
            return VkGraphicsPipelineCreateInfo.npTessellationState(this.address());
        }

        public VkPipelineViewportStateCreateInfo pViewportState() {
            return VkGraphicsPipelineCreateInfo.npViewportState(this.address());
        }

        public VkPipelineRasterizationStateCreateInfo pRasterizationState() {
            return VkGraphicsPipelineCreateInfo.npRasterizationState(this.address());
        }

        public VkPipelineMultisampleStateCreateInfo pMultisampleState() {
            return VkGraphicsPipelineCreateInfo.npMultisampleState(this.address());
        }

        public VkPipelineDepthStencilStateCreateInfo pDepthStencilState() {
            return VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address());
        }

        public VkPipelineColorBlendStateCreateInfo pColorBlendState() {
            return VkGraphicsPipelineCreateInfo.npColorBlendState(this.address());
        }

        public VkPipelineDynamicStateCreateInfo pDynamicState() {
            return VkGraphicsPipelineCreateInfo.npDynamicState(this.address());
        }

        public long layout() {
            return VkGraphicsPipelineCreateInfo.nlayout(this.address());
        }

        public long renderPass() {
            return VkGraphicsPipelineCreateInfo.nrenderPass(this.address());
        }

        public int subpass() {
            return VkGraphicsPipelineCreateInfo.nsubpass(this.address());
        }

        public long basePipelineHandle() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address());
        }

        public int basePipelineIndex() {
            return VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address());
        }

        public Buffer sType(int value) {
            VkGraphicsPipelineCreateInfo.nsType(this.address(), value);
            return this;
        }

        public Buffer pNext(long value) {
            VkGraphicsPipelineCreateInfo.npNext(this.address(), value);
            return this;
        }

        public Buffer flags(int value) {
            VkGraphicsPipelineCreateInfo.nflags(this.address(), value);
            return this;
        }

        public Buffer pStages(VkPipelineShaderStageCreateInfo.Buffer value) {
            VkGraphicsPipelineCreateInfo.npStages(this.address(), value);
            return this;
        }

        public Buffer pVertexInputState(VkPipelineVertexInputStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npVertexInputState(this.address(), value);
            return this;
        }

        public Buffer pInputAssemblyState(VkPipelineInputAssemblyStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npInputAssemblyState(this.address(), value);
            return this;
        }

        public Buffer pTessellationState(VkPipelineTessellationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npTessellationState(this.address(), value);
            return this;
        }

        public Buffer pViewportState(VkPipelineViewportStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npViewportState(this.address(), value);
            return this;
        }

        public Buffer pRasterizationState(VkPipelineRasterizationStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npRasterizationState(this.address(), value);
            return this;
        }

        public Buffer pMultisampleState(VkPipelineMultisampleStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npMultisampleState(this.address(), value);
            return this;
        }

        public Buffer pDepthStencilState(VkPipelineDepthStencilStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDepthStencilState(this.address(), value);
            return this;
        }

        public Buffer pColorBlendState(VkPipelineColorBlendStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npColorBlendState(this.address(), value);
            return this;
        }

        public Buffer pDynamicState(VkPipelineDynamicStateCreateInfo value) {
            VkGraphicsPipelineCreateInfo.npDynamicState(this.address(), value);
            return this;
        }

        public Buffer layout(long value) {
            VkGraphicsPipelineCreateInfo.nlayout(this.address(), value);
            return this;
        }

        public Buffer renderPass(long value) {
            VkGraphicsPipelineCreateInfo.nrenderPass(this.address(), value);
            return this;
        }

        public Buffer subpass(int value) {
            VkGraphicsPipelineCreateInfo.nsubpass(this.address(), value);
            return this;
        }

        public Buffer basePipelineHandle(long value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineHandle(this.address(), value);
            return this;
        }

        public Buffer basePipelineIndex(int value) {
            VkGraphicsPipelineCreateInfo.nbasePipelineIndex(this.address(), value);
            return this;
        }
    }
}

