/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDisplayPlanePropertiesKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURRENTDISPLAY;
    public static final int CURRENTSTACKINDEX;

    VkDisplayPlanePropertiesKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayPlanePropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayPlanePropertiesKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long currentDisplay() {
        return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
    }

    public int currentStackIndex() {
        return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
    }

    public static VkDisplayPlanePropertiesKHR malloc() {
        return VkDisplayPlanePropertiesKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR calloc() {
        return VkDisplayPlanePropertiesKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR create() {
        return new VkDisplayPlanePropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR create(long address) {
        return address == 0L ? null : new VkDisplayPlanePropertiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayPlanePropertiesKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayPlanePropertiesKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDisplayPlanePropertiesKHR mallocStack() {
        return VkDisplayPlanePropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPlanePropertiesKHR callocStack() {
        return VkDisplayPlanePropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayPlanePropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayPlanePropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayPlanePropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayPlanePropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ncurrentDisplay(long struct) {
        return MemoryUtil.memGetLong(struct + (long)CURRENTDISPLAY);
    }

    public static int ncurrentStackIndex(long struct) {
        return MemoryUtil.memGetInt(struct + (long)CURRENTSTACKINDEX);
    }

    static {
        Struct.Layout layout = VkDisplayPlanePropertiesKHR.__struct(VkDisplayPlanePropertiesKHR.__member(8), VkDisplayPlanePropertiesKHR.__member(4));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURRENTDISPLAY = layout.offsetof(0);
        CURRENTSTACKINDEX = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkDisplayPlanePropertiesKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayPlanePropertiesKHR newInstance(long address) {
            return new VkDisplayPlanePropertiesKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long currentDisplay() {
            return VkDisplayPlanePropertiesKHR.ncurrentDisplay(this.address());
        }

        public int currentStackIndex() {
            return VkDisplayPlanePropertiesKHR.ncurrentStackIndex(this.address());
        }
    }
}

