/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkDisplayModeParametersKHR;

public class VkDisplayModePropertiesKHR
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int DISPLAYMODE;
    public static final int PARAMETERS;

    VkDisplayModePropertiesKHR(long address, ByteBuffer container) {
        super(address, container);
    }

    public VkDisplayModePropertiesKHR(ByteBuffer container) {
        this(MemoryUtil.memAddress(container), VkDisplayModePropertiesKHR.checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    public long displayMode() {
        return VkDisplayModePropertiesKHR.ndisplayMode(this.address());
    }

    public VkDisplayModeParametersKHR parameters() {
        return VkDisplayModePropertiesKHR.nparameters(this.address());
    }

    public static VkDisplayModePropertiesKHR malloc() {
        return VkDisplayModePropertiesKHR.create(MemoryUtil.nmemAlloc(SIZEOF));
    }

    public static VkDisplayModePropertiesKHR calloc() {
        return VkDisplayModePropertiesKHR.create(MemoryUtil.nmemCalloc(1L, SIZEOF));
    }

    public static VkDisplayModePropertiesKHR create() {
        return new VkDisplayModePropertiesKHR(BufferUtils.createByteBuffer(SIZEOF));
    }

    public static VkDisplayModePropertiesKHR create(long address) {
        return address == 0L ? null : new VkDisplayModePropertiesKHR(address, null);
    }

    public static Buffer malloc(int capacity) {
        return VkDisplayModePropertiesKHR.create(MemoryUtil.nmemAlloc(capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return VkDisplayModePropertiesKHR.create(MemoryUtil.nmemCalloc(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(BufferUtils.createByteBuffer(capacity * SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, null, -1, 0, capacity, capacity);
    }

    public static VkDisplayModePropertiesKHR mallocStack() {
        return VkDisplayModePropertiesKHR.mallocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModePropertiesKHR callocStack() {
        return VkDisplayModePropertiesKHR.callocStack(MemoryStack.stackGet());
    }

    public static VkDisplayModePropertiesKHR mallocStack(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDisplayModePropertiesKHR callocStack(MemoryStack stack) {
        return VkDisplayModePropertiesKHR.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return VkDisplayModePropertiesKHR.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return VkDisplayModePropertiesKHR.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDisplayModePropertiesKHR.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long ndisplayMode(long struct) {
        return MemoryUtil.memGetLong(struct + (long)DISPLAYMODE);
    }

    public static VkDisplayModeParametersKHR nparameters(long struct) {
        return VkDisplayModeParametersKHR.create(struct + (long)PARAMETERS);
    }

    static {
        Struct.Layout layout = VkDisplayModePropertiesKHR.__struct(VkDisplayModePropertiesKHR.__member(8), VkDisplayModePropertiesKHR.__member(VkDisplayModeParametersKHR.SIZEOF, VkDisplayModeParametersKHR.ALIGNOF));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        DISPLAYMODE = layout.offsetof(0);
        PARAMETERS = layout.offsetof(1);
    }

    public static final class Buffer
    extends StructBuffer<VkDisplayModePropertiesKHR, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        Buffer(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected Buffer newBufferInstance(long address, ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        @Override
        protected VkDisplayModePropertiesKHR newInstance(long address) {
            return new VkDisplayModePropertiesKHR(address, this.getContainer());
        }

        @Override
        protected int sizeof() {
            return SIZEOF;
        }

        public long displayMode() {
            return VkDisplayModePropertiesKHR.ndisplayMode(this.address());
        }

        public VkDisplayModeParametersKHR parameters() {
            return VkDisplayModePropertiesKHR.nparameters(this.address());
        }
    }
}

