/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class QCOMDriverControl {
    protected QCOMDriverControl() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glGetDriverControlsQCOM, caps.glGetDriverControlStringQCOM, caps.glEnableDriverControlQCOM, caps.glDisableDriverControlQCOM);
    }

    public static void nglGetDriverControlsQCOM(long num, int size, long driverControls) {
        long __functionAddress = GLES.getCapabilities().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, num, size, driverControls);
    }

    public static void glGetDriverControlsQCOM(IntBuffer num, IntBuffer driverControls) {
        if (Checks.CHECKS && num != null) {
            Checks.checkBuffer((Buffer)num, 1);
        }
        QCOMDriverControl.nglGetDriverControlsQCOM(MemoryUtil.memAddressSafe(num), driverControls == null ? 0 : driverControls.remaining(), MemoryUtil.memAddressSafe(driverControls));
    }

    public static void nglGetDriverControlStringQCOM(int driverControl, int bufSize, long length, long driverControlString) {
        long __functionAddress = GLES.getCapabilities().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, driverControl, bufSize, length, driverControlString);
    }

    public static void glGetDriverControlStringQCOM(int driverControl, IntBuffer length, ByteBuffer driverControlString) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, driverControlString == null ? 0 : driverControlString.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddressSafe(driverControlString));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetDriverControlStringQCOM(int driverControl, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer length = stack.ints(0);
            ByteBuffer driverControlString = stack.malloc(bufSize);
            QCOMDriverControl.nglGetDriverControlStringQCOM(driverControl, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(driverControlString));
            String string = MemoryUtil.memASCII(driverControlString, length.get(0));
            return string;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void glEnableDriverControlQCOM(int driverControl) {
        long __functionAddress = GLES.getCapabilities().glEnableDriverControlQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, driverControl);
    }

    public static void glDisableDriverControlQCOM(int driverControl) {
        long __functionAddress = GLES.getCapabilities().glDisableDriverControlQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, driverControl);
    }

    public static void glGetDriverControlsQCOM(int[] num, int[] driverControls) {
        long __functionAddress = GLES.getCapabilities().glGetDriverControlsQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (num != null) {
                Checks.checkBuffer(num, 1);
            }
        }
        JNI.callPPV(__functionAddress, num, driverControls == null ? 0 : driverControls.length, driverControls);
    }

    public static void glGetDriverControlStringQCOM(int driverControl, int[] length, ByteBuffer driverControlString) {
        long __functionAddress = GLES.getCapabilities().glGetDriverControlStringQCOM;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, driverControl, driverControlString == null ? 0 : driverControlString.remaining(), length, MemoryUtil.memAddressSafe(driverControlString));
    }
}

