/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengles;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengles.GLES;
import org.lwjgl.opengles.GLESCapabilities;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class EXTSeparateShaderObjects {
    public static final int GL_VERTEX_SHADER_BIT_EXT = 1;
    public static final int GL_FRAGMENT_SHADER_BIT_EXT = 2;
    public static final int GL_ALL_SHADER_BITS_EXT = -1;
    public static final int GL_PROGRAM_SEPARABLE_EXT = 33368;
    public static final int GL_ACTIVE_PROGRAM_EXT = 33369;
    public static final int GL_PROGRAM_PIPELINE_BINDING_EXT = 33370;

    protected EXTSeparateShaderObjects() {
        throw new UnsupportedOperationException();
    }

    static boolean isAvailable(GLESCapabilities caps) {
        return Checks.checkFunctions(caps.glActiveShaderProgramEXT, caps.glBindProgramPipelineEXT, caps.glCreateShaderProgramvEXT, caps.glDeleteProgramPipelinesEXT, caps.glGenProgramPipelinesEXT, caps.glGetProgramPipelineInfoLogEXT, caps.glGetProgramPipelineivEXT, caps.glIsProgramPipelineEXT, caps.glProgramParameteriEXT, caps.glProgramUniform1fEXT, caps.glProgramUniform1fvEXT, caps.glProgramUniform1iEXT, caps.glProgramUniform1ivEXT, caps.glProgramUniform2fEXT, caps.glProgramUniform2fvEXT, caps.glProgramUniform2iEXT, caps.glProgramUniform2ivEXT, caps.glProgramUniform3fEXT, caps.glProgramUniform3fvEXT, caps.glProgramUniform3iEXT, caps.glProgramUniform3ivEXT, caps.glProgramUniform4fEXT, caps.glProgramUniform4fvEXT, caps.glProgramUniform4iEXT, caps.glProgramUniform4ivEXT, caps.glProgramUniformMatrix2fvEXT, caps.glProgramUniformMatrix3fvEXT, caps.glProgramUniformMatrix4fvEXT, caps.glUseProgramStagesEXT, caps.glValidateProgramPipelineEXT, caps.glProgramUniform1uiEXT, caps.glProgramUniform2uiEXT, caps.glProgramUniform3uiEXT, caps.glProgramUniform4uiEXT, caps.glProgramUniform1uivEXT, caps.glProgramUniform2uivEXT, caps.glProgramUniform3uivEXT, caps.glProgramUniform4uivEXT, caps.glProgramUniformMatrix2x3fvEXT, caps.glProgramUniformMatrix3x2fvEXT, caps.glProgramUniformMatrix2x4fvEXT, caps.glProgramUniformMatrix4x2fvEXT, caps.glProgramUniformMatrix3x4fvEXT, caps.glProgramUniformMatrix4x3fvEXT);
    }

    public static void glActiveShaderProgramEXT(int pipeline, int program) {
        long __functionAddress = GLES.getCapabilities().glActiveShaderProgramEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, pipeline, program);
    }

    public static void glBindProgramPipelineEXT(int pipeline) {
        long __functionAddress = GLES.getCapabilities().glBindProgramPipelineEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, pipeline);
    }

    public static int nglCreateShaderProgramvEXT(int type, int count, long strings) {
        long __functionAddress = GLES.getCapabilities().glCreateShaderProgramvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callPI(__functionAddress, type, count, strings);
    }

    public static int glCreateShaderProgramvEXT(int type, PointerBuffer strings) {
        return EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.remaining(), MemoryUtil.memAddress(strings));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence ... strings) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, strings);
            int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, strings.length, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, strings.length);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glCreateShaderProgramvEXT(int type, CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            long stringsAddress = APIUtil.apiArray(stack, MemoryUtil::memUTF8, string);
            int __result = EXTSeparateShaderObjects.nglCreateShaderProgramvEXT(type, 1, stringsAddress);
            APIUtil.apiArrayFree(stringsAddress, 1);
            int n = __result;
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglDeleteProgramPipelinesEXT(int n, long pipelines) {
        long __functionAddress = GLES.getCapabilities().glDeleteProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, pipelines);
    }

    public static void glDeleteProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glDeleteProgramPipelinesEXT(int pipeline) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.ints(pipeline);
            EXTSeparateShaderObjects.nglDeleteProgramPipelinesEXT(1, MemoryUtil.memAddress(pipelines));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGenProgramPipelinesEXT(int n, long pipelines) {
        long __functionAddress = GLES.getCapabilities().glGenProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, n, pipelines);
    }

    public static void glGenProgramPipelinesEXT(IntBuffer pipelines) {
        EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(pipelines.remaining(), MemoryUtil.memAddress(pipelines));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGenProgramPipelinesEXT() {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer pipelines = stack.callocInt(1);
            EXTSeparateShaderObjects.nglGenProgramPipelinesEXT(1, MemoryUtil.memAddress(pipelines));
            int n = pipelines.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramPipelineInfoLogEXT(int pipeline, int bufSize, long length, long infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetProgramPipelineInfoLogEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPPV(__functionAddress, pipeline, bufSize, length, infoLog);
    }

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, IntBuffer length, ByteBuffer infoLog) {
        if (Checks.CHECKS && length != null) {
            Checks.checkBuffer((Buffer)length, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, infoLog.remaining(), MemoryUtil.memAddressSafe(length), MemoryUtil.memAddress(infoLog));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLogEXT(int pipeline, int bufSize) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String glGetProgramPipelineInfoLogEXT(int pipeline) {
        int bufSize = EXTSeparateShaderObjects.glGetProgramPipelineiEXT(pipeline, 35716);
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        ByteBuffer infoLog = MemoryUtil.memAlloc(bufSize);
        try {
            IntBuffer length = stack.ints(0);
            EXTSeparateShaderObjects.nglGetProgramPipelineInfoLogEXT(pipeline, bufSize, MemoryUtil.memAddress(length), MemoryUtil.memAddress(infoLog));
            String string = MemoryUtil.memUTF8(infoLog, length.get(0));
            return string;
        }
        finally {
            MemoryUtil.memFree(infoLog);
            stack.setPointer(stackPointer);
        }
    }

    public static void nglGetProgramPipelineivEXT(int pipeline, int pname, long params) {
        long __functionAddress = GLES.getCapabilities().glGetProgramPipelineivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipeline, pname, params);
    }

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, IntBuffer params) {
        if (Checks.CHECKS) {
            Checks.checkBuffer((Buffer)params, 1);
        }
        EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int glGetProgramPipelineiEXT(int pipeline, int pname) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            IntBuffer params = stack.callocInt(1);
            EXTSeparateShaderObjects.nglGetProgramPipelineivEXT(pipeline, pname, MemoryUtil.memAddress(params));
            int n = params.get(0);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static boolean glIsProgramPipelineEXT(int pipeline) {
        long __functionAddress = GLES.getCapabilities().glIsProgramPipelineEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        return JNI.callZ(__functionAddress, pipeline);
    }

    public static void glProgramParameteriEXT(int program, int pname, int value) {
        long __functionAddress = GLES.getCapabilities().glProgramParameteriEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, pname, value);
    }

    public static void glProgramUniform1fEXT(int program, int location, float v0) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void nglProgramUniform1fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1fvEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform1iEXT(int program, int location, int v0) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void nglProgramUniform1ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1ivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2fEXT(int program, int location, float v0, float v1) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void nglProgramUniform2fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2fvEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform2iEXT(int program, int location, int v0, int v1) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void nglProgramUniform2ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2ivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3fEXT(int program, int location, float v0, float v1, float v2) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void nglProgramUniform3fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3fvEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform3iEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void nglProgramUniform3ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3ivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4fEXT(int program, int location, float v0, float v1, float v2, float v3) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4fEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform4fvEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4fvEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void glProgramUniform4iEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4iEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform4ivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4ivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2fvEXT(program, location, value.remaining() >> 2, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3fvEXT(program, location, value.remaining() / 9, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4fvEXT(program, location, value.remaining() >> 4, transpose, MemoryUtil.memAddress(value));
    }

    public static void glUseProgramStagesEXT(int pipeline, int stages, int program) {
        long __functionAddress = GLES.getCapabilities().glUseProgramStagesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, pipeline, stages, program);
    }

    public static void glValidateProgramPipelineEXT(int pipeline) {
        long __functionAddress = GLES.getCapabilities().glValidateProgramPipelineEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, pipeline);
    }

    public static void glProgramUniform1uiEXT(int program, int location, int v0) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0);
    }

    public static void glProgramUniform2uiEXT(int program, int location, int v0, int v1) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1);
    }

    public static void glProgramUniform3uiEXT(int program, int location, int v0, int v1, int v2) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2);
    }

    public static void glProgramUniform4uiEXT(int program, int location, int v0, int v1, int v2, int v3) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4uiEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callV(__functionAddress, program, location, v0, v1, v2, v3);
    }

    public static void nglProgramUniform1uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform1uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform1uivEXT(program, location, value.remaining(), MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform2uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform2uivEXT(program, location, value.remaining() >> 1, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform3uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform3uivEXT(program, location, value.remaining() / 3, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniform4uivEXT(int program, int location, int count, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, IntBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniform4uivEXT(program, location, value.remaining() >> 2, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x3fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x2fvEXT(program, location, value.remaining() / 6, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix2x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix2x4fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x2fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x2fvEXT(program, location, value.remaining() >> 3, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix3x4fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix3x4fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void nglProgramUniformMatrix4x3fvEXT(int program, int location, int count, boolean transpose, long value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, count, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, FloatBuffer value) {
        EXTSeparateShaderObjects.nglProgramUniformMatrix4x3fvEXT(program, location, value.remaining() / 12, transpose, MemoryUtil.memAddress(value));
    }

    public static void glDeleteProgramPipelinesEXT(int[] pipelines) {
        long __functionAddress = GLES.getCapabilities().glDeleteProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGenProgramPipelinesEXT(int[] pipelines) {
        long __functionAddress = GLES.getCapabilities().glGenProgramPipelinesEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, pipelines.length, pipelines);
    }

    public static void glGetProgramPipelineInfoLogEXT(int pipeline, int[] length, ByteBuffer infoLog) {
        long __functionAddress = GLES.getCapabilities().glGetProgramPipelineInfoLogEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            if (length != null) {
                Checks.checkBuffer(length, 1);
            }
        }
        JNI.callPPV(__functionAddress, pipeline, infoLog.remaining(), length, MemoryUtil.memAddress(infoLog));
    }

    public static void glGetProgramPipelineivEXT(int pipeline, int pname, int[] params) {
        long __functionAddress = GLES.getCapabilities().glGetProgramPipelineivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
            Checks.checkBuffer(params, 1);
        }
        JNI.callPV(__functionAddress, pipeline, pname, params);
    }

    public static void glProgramUniform1fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform1ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform2ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform3ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4fvEXT(int program, int location, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniform4ivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4ivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, transpose, value);
    }

    public static void glProgramUniformMatrix3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 9, transpose, value);
    }

    public static void glProgramUniformMatrix4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 4, transpose, value);
    }

    public static void glProgramUniform1uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform1uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length, value);
    }

    public static void glProgramUniform2uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform2uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 1, value);
    }

    public static void glProgramUniform3uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform3uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 3, value);
    }

    public static void glProgramUniform4uivEXT(int program, int location, int[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniform4uivEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 2, value);
    }

    public static void glProgramUniformMatrix2x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix3x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 6, transpose, value);
    }

    public static void glProgramUniformMatrix2x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix2x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix4x2fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4x2fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length >> 3, transpose, value);
    }

    public static void glProgramUniformMatrix3x4fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix3x4fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }

    public static void glProgramUniformMatrix4x3fvEXT(int program, int location, boolean transpose, float[] value) {
        long __functionAddress = GLES.getCapabilities().glProgramUniformMatrix4x3fvEXT;
        if (Checks.CHECKS) {
            Checks.checkFunctionAddress(__functionAddress);
        }
        JNI.callPV(__functionAddress, program, location, value.length / 12, transpose, value);
    }
}

